/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.DynamicGroupTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.dupLocator.iterators.CountingNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.structuralsearch.DefaultMatchResultSink;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.inspection.SSBasedInspectionCompiledPatternsCache;
import com.intellij.structuralsearch.inspection.StructuralSearchInspectionToolWrapper;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.util.DuplicateFilteringResultSink;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SSBasedInspection
extends LocalInspectionTool
implements DynamicGroupTool {
    static final Object LOCK = new Object();
    @NonNls
    public static final String SHORT_NAME = "SSBasedInspection";
    private final List<Configuration> myConfigurations = ContainerUtil.createLockFreeCopyOnWriteList();
    final Set<String> myProblemsReported = new HashSet<String>(1);
    private InspectionProfileImpl mySessionProfile = null;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SSBasedInspection.$$$reportNull$$$0(0);
        }
        ConfigurationManager.writeConfigurations(node, this.myConfigurations);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            SSBasedInspection.$$$reportNull$$$0(1);
        }
        this.myProblemsReported.clear();
        this.myConfigurations.clear();
        ConfigurationManager.readConfigurations(node, this.myConfigurations);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = SSBasedInspection.getGeneralGroupName();
        if (string == null) {
            SSBasedInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            SSBasedInspection.$$$reportNull$$$0(3);
        }
        super.initialize(context);
        this.mySessionProfile = ((GlobalInspectionContextBase)context).getCurrentProfile();
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            SSBasedInspection.$$$reportNull$$$0(4);
        }
        super.cleanup(project);
        this.mySessionProfile = null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SSBasedInspection.$$$reportNull$$$0(5);
        }
        if (this.myConfigurations.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SSBasedInspection.$$$reportNull$$$0(6);
            }
            return psiElementVisitor;
        }
        Project project = holder.getProject();
        final InspectionProfileImpl profile = this.mySessionProfile != null ? this.mySessionProfile : InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
        for (Configuration configuration2 : this.myConfigurations) {
            SSBasedInspection.register(configuration2);
        }
        final Map<Configuration, Matcher> compiledOptions = SSBasedInspectionCompiledPatternsCache.getInstance(project).getCompiledOptions(this.myConfigurations);
        if (compiledOptions.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SSBasedInspection.$$$reportNull$$$0(7);
            }
            return psiElementVisitor;
        }
        PairProcessor processor = (matchResult, configuration) -> {
            PsiElement element = matchResult.getMatch();
            if (holder.getFile() != element.getContainingFile()) {
                return false;
            }
            LocalQuickFix fix = SSBasedInspection.createQuickFix(project, matchResult, configuration);
            Configuration mainConfiguration = this.getMainConfiguration((Configuration)configuration);
            String name = (String)ObjectUtils.notNull((Object)mainConfiguration.getProblemDescriptor(), (Object)mainConfiguration.getName());
            ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor(element, name, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            holder.registerProblem((ProblemDescriptor)new ProblemDescriptorWithReporterName((ProblemDescriptorBase)descriptor, configuration.getUuid().toString()));
            return true;
        };
        for (Map.Entry<Configuration, Matcher> entry : compiledOptions.entrySet()) {
            Configuration configuration3 = entry.getKey();
            Matcher matcher = entry.getValue();
            if (matcher == null) continue;
            matcher.getMatchContext().setSink(new DuplicateFilteringResultSink(new InspectionResultSink((PairProcessor<? super MatchResult, ? super Configuration>)processor, configuration3)));
        }
        return new PsiElementVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LexicalNodesFilter.getInstance().accepts(element)) {
                    return;
                }
                Object object = LOCK;
                synchronized (object) {
                    SsrFilteringNodeIterator matchedNodes = new SsrFilteringNodeIterator(element);
                    for (Map.Entry entry : compiledOptions.entrySet()) {
                        block8: {
                            Configuration configuration = (Configuration)entry.getKey();
                            Matcher matcher = (Matcher)entry.getValue();
                            if (matcher == null || !matcher.checkIfShouldAttemptToMatch((NodeIterator)matchedNodes) || !profile.isToolEnabled(HighlightDisplayKey.find((String)configuration.getUuid().toString()), element)) continue;
                            int nodeCount = matcher.getMatchContext().getPattern().getNodeCount();
                            try {
                                matcher.processMatchesInElement((NodeIterator)new CountingNodeIterator(nodeCount, (NodeIterator)matchedNodes));
                            }
                            catch (StructuralSearchException e) {
                                if (!SSBasedInspection.this.myProblemsReported.add(configuration.getName())) break block8;
                                String message = e.getMessage().replace("a3cd264774bf4efb9ab609b250c5165c", "");
                                UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.ERROR).setContent(SSRBundle.message("inspection.script.problem", message, configuration.getName())).setImportant(true).notify(element.getProject());
                            }
                        }
                        matchedNodes.reset();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/inspection/SSBasedInspection$1", "visitElement"));
            }
        };
    }

    public static void register(Configuration configuration) {
        if (configuration.getOrder() != 0) {
            return;
        }
        String shortName = configuration.getUuid().toString();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key != null) {
            if (!SSBasedInspection.isMetaDataChanged(configuration, key)) {
                return;
            }
            HighlightDisplayKey.unregister((String)shortName);
        }
        String suppressId = configuration.getSuppressId();
        String name = configuration.getName();
        if (suppressId == null) {
            HighlightDisplayKey.register((String)shortName, () -> name, (String)SHORT_NAME);
        } else {
            HighlightDisplayKey.register((String)shortName, () -> name, (String)suppressId, (String)SHORT_NAME);
        }
    }

    private static boolean isMetaDataChanged(Configuration configuration, HighlightDisplayKey key) {
        if (StringUtil.isEmpty((String)configuration.getSuppressId()) ? !SHORT_NAME.equals(key.getID()) : !configuration.getSuppressId().equals(key.getID())) {
            return true;
        }
        return !configuration.getName().equals(HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key));
    }

    public List<LocalInspectionToolWrapper> getChildren() {
        return this.getConfigurations().stream().filter(configuration -> configuration.getOrder() == 0).map(configuration -> new StructuralSearchInspectionToolWrapper(this.getConfigurationsWithUuid(configuration.getUuid()))).collect(Collectors.toList());
    }

    static LocalQuickFix createQuickFix(Project project, MatchResult matchResult, Configuration configuration) {
        if (!(configuration instanceof ReplaceConfiguration)) {
            return null;
        }
        ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)configuration;
        final Replacer replacer = new Replacer(project, replaceConfiguration.getReplaceOptions());
        final ReplacementInfo replacementInfo = replacer.buildReplacement(matchResult);
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = SSRBundle.message("SSRInspection.replace.with", replacementInfo.getReplacement());
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement element;
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((element = descriptor.getPsiElement()) != null) {
                    replacer.replace(replacementInfo);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = SSRBundle.message("SSRInspection.family.name", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/structuralsearch/inspection/SSBasedInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private Configuration getMainConfiguration(Configuration configuration) {
        if (configuration.getOrder() == 0) {
            return configuration;
        }
        UUID uuid = configuration.getUuid();
        return this.myConfigurations.stream().filter(c -> c.getOrder() == 0 && uuid.equals(c.getUuid())).findFirst().orElse(configuration);
    }

    public List<Configuration> getConfigurations() {
        return Collections.unmodifiableList(this.myConfigurations);
    }

    public List<Configuration> getConfigurationsWithUuid(@NotNull UUID uuid) {
        if (uuid == null) {
            SSBasedInspection.$$$reportNull$$$0(8);
        }
        List configurations = ContainerUtil.filter(this.myConfigurations, c -> uuid.equals(c.getUuid()));
        configurations.sort(Comparator.comparingInt(Configuration::getOrder));
        return configurations;
    }

    public boolean addConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(9);
        }
        if (this.myConfigurations.contains(configuration)) {
            return false;
        }
        this.myConfigurations.add(configuration);
        return true;
    }

    public boolean addConfigurations(@NotNull Collection<? extends Configuration> configurations) {
        if (configurations == null) {
            SSBasedInspection.$$$reportNull$$$0(10);
        }
        boolean changed = false;
        for (Configuration configuration : configurations) {
            changed |= this.addConfiguration(configuration);
        }
        return changed;
    }

    public boolean removeConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(11);
        }
        return this.myConfigurations.remove(configuration);
    }

    public boolean removeConfigurationsWithUuid(@NotNull UUID uuid) {
        if (uuid == null) {
            SSBasedInspection.$$$reportNull$$$0(12);
        }
        return this.myConfigurations.removeIf(c -> c.getUuid().equals(uuid));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/SSBasedInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationsWithUuid";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeConfigurationsWithUuid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InspectionResultSink
    extends DefaultMatchResultSink {
        private final Configuration myConfiguration;
        private PairProcessor<? super MatchResult, ? super Configuration> myProcessor;

        InspectionResultSink(PairProcessor<? super MatchResult, ? super Configuration> processor, Configuration configuration) {
            this.myProcessor = processor;
            this.myConfiguration = configuration;
        }

        @Override
        public void newMatch(MatchResult result) {
            this.myProcessor.process((Object)result, (Object)this.myConfiguration);
        }

        @Override
        public void matchingFinished() {
            this.myProcessor = null;
        }
    }
}

