/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class TextFilter
extends FilterAction {
    boolean myShowHierarchy;

    public TextFilter(FilterTable filterTable) {
        super(SSRBundle.messagePointer("text.filter.name", new Object[0]), filterTable);
    }

    @Override
    public boolean hasFilter() {
        NamedScriptableDefinition variable = this.myTable.getVariable();
        if (!(variable instanceof MatchVariableConstraint)) {
            return false;
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        return !StringUtil.isEmpty((String)constraint.getRegExp()) || constraint.isWithinHierarchy();
    }

    @Override
    public void clearFilter() {
        NamedScriptableDefinition variable = this.myTable.getVariable();
        if (!(variable instanceof MatchVariableConstraint)) {
            return;
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        constraint.setRegExp("");
        constraint.setWholeWordsOnly(false);
        constraint.setWithinHierarchy(false);
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (!(this.myTable.getVariable() instanceof MatchVariableConstraint)) {
            return false;
        }
        StructuralSearchProfile profile = this.myTable.getProfile();
        this.myShowHierarchy = profile.isApplicableConstraint("TEXT HIERARCHY", nodes, completePattern, target);
        return profile.isApplicableConstraint("TEXT", nodes, completePattern, target);
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        MatchVariableConstraint constraint = (MatchVariableConstraint)this.myTable.getVariable();
        String value = constraint.isInvertRegExp() ? "!" + constraint.getRegExp() : constraint.getRegExp();
        this.myLabel.append(SSRBundle.message("text.0.label", value));
        if (constraint.isWholeWordsOnly()) {
            this.myLabel.append(SSRBundle.message("whole.words.label", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        if (constraint.isWithinHierarchy()) {
            this.myLabel.append(SSRBundle.message("within.hierarchy.label", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    @Override
    public FilterEditor getEditor() {
        return new FilterEditor<MatchVariableConstraint>(this.myTable.getVariable(), this.myTable.getConstraintChangedCallback()){
            private final EditorTextField myTextField;
            private final JCheckBox myWordsCheckBox;
            private final JCheckBox myHierarchyCheckBox;
            private final JLabel myTextLabel;
            private final ContextHelpLabel myHelpLabel;
            {
                this.myTextField = UIUtil.createRegexComponent("", TextFilter.this.myTable.getProject());
                this.myWordsCheckBox = new JCheckBox(SSRBundle.message("whole.words.check.box", new Object[0]), false);
                this.myHierarchyCheckBox = new JCheckBox(SSRBundle.message("within.type.hierarchy.check.box", new Object[0]), false);
                this.myTextLabel = new JLabel(SSRBundle.message("text.label", new Object[0]));
                this.myHelpLabel = ContextHelpLabel.create((String)SSRBundle.message("text.filter.help.text", new Object[0]));
            }

            @Override
            protected void layoutComponents() {
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myTextLabel).addComponent((Component)this.myTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel)).addGroup(layout.createSequentialGroup().addComponent(this.myWordsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myHierarchyCheckBox)));
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myTextLabel).addComponent((Component)this.myTextField).addComponent((Component)this.myHelpLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myWordsCheckBox).addComponent(this.myHierarchyCheckBox)));
            }

            @Override
            protected void loadValues() {
                this.myTextField.setText((((MatchVariableConstraint)this.myConstraint).isInvertRegExp() ? "!" : "") + ((MatchVariableConstraint)this.myConstraint).getRegExp());
                this.myWordsCheckBox.setSelected(((MatchVariableConstraint)this.myConstraint).isWholeWordsOnly());
                this.myHierarchyCheckBox.setSelected(((MatchVariableConstraint)this.myConstraint).isWithinHierarchy());
                this.myHierarchyCheckBox.setVisible(TextFilter.this.myShowHierarchy);
            }

            @Override
            public void saveValues() {
                String text = this.myTextField.getText();
                if (text.startsWith("!")) {
                    ((MatchVariableConstraint)this.myConstraint).setRegExp(text.substring(1));
                    ((MatchVariableConstraint)this.myConstraint).setInvertRegExp(true);
                } else {
                    ((MatchVariableConstraint)this.myConstraint).setRegExp(text);
                    ((MatchVariableConstraint)this.myConstraint).setInvertRegExp(false);
                }
                ((MatchVariableConstraint)this.myConstraint).setWholeWordsOnly(this.myWordsCheckBox.isSelected());
                ((MatchVariableConstraint)this.myConstraint).setWithinHierarchy(this.myHierarchyCheckBox.isSelected());
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myTextField;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myTextField};
            }
        };
    }
}

