/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.snapShooter;

import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.snapShooter.SnapShotClient;
import com.intellij.uiDesigner.snapShooter.SnapShotRemoteComponent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SnapShotTreeModel
implements TreeModel {
    private final SnapShotClient myClient;
    private final SnapShotRemoteComponent myRoot;

    public SnapShotTreeModel(SnapShotClient client) {
        this.myClient = client;
        this.myRoot = new SnapShotRemoteComponent(0, Object.class.getName(), "", "Root");
    }

    @Override
    public Object getRoot() {
        return this.myRoot;
    }

    @Override
    public Object getChild(Object parent, int index) {
        SnapShotRemoteComponent component = (SnapShotRemoteComponent)parent;
        return this.checkGetChildren(component)[index];
    }

    private SnapShotRemoteComponent[] checkGetChildren(SnapShotRemoteComponent component) {
        if (component.getChildren() == null) {
            try {
                component.setChildren(this.myClient.listChildren(component.getId()));
            }
            catch (IOException e) {
                SnapShotTreeModel.reportDisconnection(this.myClient);
                return new SnapShotRemoteComponent[0];
            }
        }
        return component.getChildren();
    }

    private static void reportDisconnection(SnapShotClient client) {
        Messages.showMessageDialog((String)"Disconnected from remote application", (String)"Create Form Snapshot", (Icon)Messages.getErrorIcon());
        client.setDisconnected();
    }

    @Override
    public int getChildCount(Object parent) {
        SnapShotRemoteComponent component = (SnapShotRemoteComponent)parent;
        return this.checkGetChildren(component).length;
    }

    @Override
    public boolean isLeaf(Object node) {
        SnapShotRemoteComponent component = (SnapShotRemoteComponent)node;
        return this.checkGetChildren(component).length == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        SnapShotRemoteComponent component = (SnapShotRemoteComponent)parent;
        SnapShotRemoteComponent[] snapShotRemoteComponents = this.checkGetChildren(component);
        for (int i = 0; i < snapShotRemoteComponents.length; ++i) {
            if (snapShotRemoteComponents[i] != child) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }
}

