/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.DynamicBundle;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.wizard.BeanProperty;
import com.intellij.uiDesigner.wizard.BeanPropertyListCellRenderer;
import com.intellij.uiDesigner.wizard.BeanPropertyTableCellRenderer;
import com.intellij.uiDesigner.wizard.FormProperty2BeanProperty;
import com.intellij.uiDesigner.wizard.FormPropertyTableCellRenderer;
import com.intellij.uiDesigner.wizard.WizardData;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class BindToExistingBeanStep
extends StepAdapter {
    private static final Logger LOG = Logger.getInstance(BindToExistingBeanStep.class);
    private JScrollPane myScrollPane;
    private JTable myTable;
    private final WizardData myData;
    private final MyTableModel myTableModel;
    private JCheckBox myChkIsModified;
    private JCheckBox myChkGetData;
    private JCheckBox myChkSetData;
    private JPanel myPanel;

    BindToExistingBeanStep(@NotNull WizardData data) {
        if (data == null) {
            BindToExistingBeanStep.$$$reportNull$$$0(0);
        }
        this.myData = data;
        this.$$$setupUI$$$();
        this.myTableModel = new MyTableModel();
        this.myTable.setModel(this.myTableModel);
        this.myTable.setSelectionMode(0);
        this.myTable.getColumnModel().setColumnSelectionAllowed(true);
        this.myScrollPane.getViewport().setBackground(this.myTable.getBackground());
        this.myTable.setSurrendersFocusOnKeystroke(true);
        TableColumn column = this.myTable.getColumnModel().getColumn(0);
        column.setCellRenderer((TableCellRenderer)((Object)new FormPropertyTableCellRenderer(this.myData.myProject)));
        column = this.myTable.getColumnModel().getColumn(1);
        column.setCellRenderer((TableCellRenderer)((Object)new BeanPropertyTableCellRenderer()));
        MyTableCellEditor cellEditor = new MyTableCellEditor();
        column.setCellEditor(cellEditor);
        DefaultCellEditor editor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        editor.setClickCountToStart(1);
        this.myTable.setRowHeight(((MyTableCellEditor)cellEditor).myCbx.getPreferredSize().height);
        this.myChkGetData.setSelected(true);
        this.myChkGetData.setEnabled(false);
        this.myChkSetData.setSelected(true);
        this.myChkSetData.setEnabled(false);
        this.myChkIsModified.setSelected(this.myData.myGenerateIsModified);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void _init() {
        LOG.assertTrue(!this.myData.myBindToNewBean);
        LOG.assertTrue(this.myData.myBeanClass != null);
        this.myTableModel.fireTableDataChanged();
    }

    public void _commit(boolean finishChosen) {
        TableCellEditor cellEditor = this.myTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        this.myData.myGenerateIsModified = this.myChkIsModified.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myScrollPane = jBScrollPane;
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = new JBTable();
        this.myTable = jBTable;
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myChkGetData = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", BindToExistingBeanStep.class).getString("bind.to.bean.getdata.checkbox"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChkSetData = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", BindToExistingBeanStep.class).getString("bind.to.bean.setdata.checkbox"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChkIsModified = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", BindToExistingBeanStep.class).getString("bind.to.bean.ismodified.checkbox"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/uiDesigner/wizard/BindToExistingBeanStep", "<init>"));
    }

    private final class MyTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final ComboBox myCbx = new ComboBox();
        private int myEditingRow;

        MyTableCellEditor() {
            this.myCbx.setEditable(true);
            this.myCbx.setRenderer((ListCellRenderer)((Object)new BeanPropertyListCellRenderer()));
            this.myCbx.registerTableCellEditor((TableCellEditor)this);
            JComponent editorComponent = (JComponent)this.myCbx.getEditor().getEditorComponent();
            editorComponent.setBorder(null);
            this.myEditingRow = -1;
        }

        private boolean canConvert(@NonNls String type1, @NonNls String type2) {
            if ("boolean".equals(type1) || "boolean".equals(type2)) {
                return type1.equals(type2);
            }
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myEditingRow = row;
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCbx.getModel();
            model.removeAllElements();
            model.addElement(null);
            String[] rProps = PropertyUtilBase.getReadableProperties((PsiClass)((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBeanClass, (boolean)true);
            Object[] wProps = PropertyUtilBase.getWritableProperties((PsiClass)((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBeanClass, (boolean)true);
            ArrayList<BeanProperty> rwProps = new ArrayList<BeanProperty>();
            block0: for (int i = rProps.length - 1; i >= 0; --i) {
                String propName = rProps[i];
                if (ArrayUtil.find((Object[])wProps, (Object)propName) == -1) continue;
                LOG.assertTrue(rwProps.stream().noneMatch(bp -> bp.myName.equals(propName)));
                PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBeanClass, (String)propName, (boolean)false, (boolean)true);
                if (getter == null) continue;
                PsiType returnType = getter.getReturnType();
                LOG.assertTrue(returnType != null);
                String typeName = returnType.getCanonicalText();
                LOG.assertTrue(typeName != null);
                if (!"boolean".equals(typeName) && !"java.lang.String".equals(typeName)) continue;
                for (int j = ((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings.length - 1; j >= 0; --j) {
                    BeanProperty _property = ((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings[j].myBeanProperty;
                    if (j != row && _property != null && propName.equals(_property.myName)) continue block0;
                }
                if (!this.canConvert(((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings[row].myFormProperty.getComponentPropertyClassName(), typeName)) continue;
                rwProps.add(new BeanProperty(propName, typeName));
            }
            Collections.sort(rwProps);
            for (BeanProperty rwProp : rwProps) {
                model.addElement(rwProp);
            }
            if (((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings[row].myBeanProperty != null) {
                this.myCbx.setSelectedItem((Object)((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings[row].myBeanProperty);
            } else {
                this.myCbx.setSelectedIndex(0);
            }
            return this.myCbx;
        }

        @Override
        public Object getCellEditorValue() {
            LOG.assertTrue(this.myEditingRow != -1);
            try {
                Object selectedItem = this.myCbx.getEditor().getItem();
                if (selectedItem instanceof BeanProperty) {
                    Object object = selectedItem;
                    return object;
                }
                if (selectedItem instanceof String) {
                    String fieldName = ((String)selectedItem).trim();
                    if (fieldName.length() == 0) {
                        Object var3_4 = null;
                        return var3_4;
                    }
                    String fieldType = ((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings[this.myEditingRow].myFormProperty.getComponentPropertyClassName();
                    BeanProperty beanProperty = new BeanProperty(fieldName, fieldType);
                    return beanProperty;
                }
                throw new IllegalArgumentException("unknown selectedItem: " + selectedItem);
            }
            finally {
                this.myEditingRow = -1;
            }
        }
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private final String[] myColumnNames = new String[]{UIDesignerBundle.message("column.form.field", new Object[0]), UIDesignerBundle.message("column.bean.property", new Object[0])};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.myColumnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.myColumnNames[column];
        }

        @Override
        public int getRowCount() {
            return ((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings.length;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return ((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings[row].myFormProperty;
            }
            if (column == 1) {
                return ((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings[row].myBeanProperty;
            }
            throw new IllegalArgumentException("unknown column: " + column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            LOG.assertTrue(column == 1);
            FormProperty2BeanProperty binding = ((BindToExistingBeanStep)BindToExistingBeanStep.this).myData.myBindings[row];
            binding.myBeanProperty = (BeanProperty)value;
        }
    }
}

