/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.xml.XmlBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TrimZenCodingFilter
extends ZenCodingFilter {
    private static final Pattern PATTERN = Pattern.compile("^([\\s|\u00a0])?[\\d|#|\\-|\\*|\u2022]+\\.?\\s*");

    @Override
    @NotNull
    public String getSuffix() {
        return "t";
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        if (context == null) {
            TrimZenCodingFilter.$$$reportNull$$$0(0);
        }
        return context.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"emmet.filter.trim.line.markers", (Object[])new Object[0]);
        if (string == null) {
            TrimZenCodingFilter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String filterText(@NotNull String text, @NotNull TemplateToken token) {
        XmlTag tag;
        if (text == null) {
            TrimZenCodingFilter.$$$reportNull$$$0(2);
        }
        if (token == null) {
            TrimZenCodingFilter.$$$reportNull$$$0(3);
        }
        if ((tag = token.getXmlTag()) != null && !tag.getText().isEmpty()) {
            tag.accept((PsiElementVisitor)new XmlElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    if (!tag.isEmpty()) {
                        XmlTagValue tagValue = tag.getValue();
                        Matcher matcher = PATTERN.matcher(tagValue.getText());
                        if (matcher.matches()) {
                            ApplicationManager.getApplication().runWriteAction(() -> tagValue.setText(matcher.replaceAll("")));
                        }
                    }
                    tag.acceptChildren((PsiElementVisitor)this);
                }
            });
            String string = tag.getText();
            if (string == null) {
                TrimZenCodingFilter.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = PATTERN.matcher(token.getTemplateText()).replaceAll("");
        if (string == null) {
            TrimZenCodingFilter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public GenerationNode filterNode(@NotNull GenerationNode node) {
        if (node == null) {
            TrimZenCodingFilter.$$$reportNull$$$0(6);
        }
        TrimZenCodingFilter.doFilter(node);
        GenerationNode generationNode = node;
        if (generationNode == null) {
            TrimZenCodingFilter.$$$reportNull$$$0(7);
        }
        return generationNode;
    }

    private static void doFilter(GenerationNode node) {
        String surroundedText = node.getSurroundedText();
        if (surroundedText != null) {
            node.setSurroundedText(PATTERN.matcher(surroundedText).replaceAll(""));
        }
        for (GenerationNode child : node.getChildren()) {
            TrimZenCodingFilter.doFilter(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

