/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.beust.jcommander.JCommander;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.testng.RemoteTestNGStarter;
import com.intellij.util.PathUtil;
import com.intellij.util.net.NetUtils;
import com.theoryinpractice.testng.configuration.SearchingForTestsTask;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class TestNGRunnableState
extends JavaTestFrameworkRunnableState<TestNGConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)"TestNG Runner");
    private static final String TESTNG_TEST_FRAMEWORK_NAME = "TestNG";
    private final TestNGConfiguration config;
    private int port;

    public TestNGRunnableState(ExecutionEnvironment environment, TestNGConfiguration config) {
        super(environment);
        this.config = config;
    }

    @NotNull
    protected String getFrameworkName() {
        return TESTNG_TEST_FRAMEWORK_NAME;
    }

    protected boolean configureByModule(Module module) {
        return module != null && this.getConfiguration().getPersistantData().getScope() != TestSearchScope.WHOLE_PROJECT;
    }

    protected void configureRTClasspath(JavaParameters javaParameters, Module module) {
        javaParameters.getClassPath().addFirst(PathUtil.getJarPathForClass(RemoteTestNGStarter.class));
        javaParameters.getClassPath().addTail(PathUtil.getJarPathForClass(JCommander.class));
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        javaParameters.setMainClass("com.intellij.rt.testng.RemoteTestNGStarter");
        try {
            this.port = NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            throw new ExecutionException("Unable to bind to port " + this.port, (Throwable)e);
        }
        TestData data = this.getConfiguration().getPersistantData();
        if (data.getOutputDirectory() != null && !data.getOutputDirectory().isEmpty()) {
            javaParameters.getProgramParametersList().add("-d", data.getOutputDirectory());
        }
        javaParameters.getProgramParametersList().add("-usedefaultlisteners", String.valueOf(data.USE_DEFAULT_REPORTERS));
        StringBuilder buf = new StringBuilder();
        if (data.TEST_LISTENERS != null && !data.TEST_LISTENERS.isEmpty()) {
            buf.append(StringUtil.join(data.TEST_LISTENERS, (String)";"));
        }
        this.collectListeners(javaParameters, buf, "com.theoryinpractice.testng.listener", ";");
        if (buf.length() > 0) {
            javaParameters.getProgramParametersList().add("-listener", buf.toString());
        }
        this.createServerSocket(javaParameters);
        this.createTempFiles(javaParameters);
        return javaParameters;
    }

    protected List<String> getNamedParams(String parameters) {
        try {
            Integer.parseInt(parameters);
            return super.getNamedParams(parameters);
        }
        catch (NumberFormatException e) {
            return Arrays.asList(parameters.split(" "));
        }
    }

    @NotNull
    protected String getForkMode() {
        return "none";
    }

    public SearchingForTestsTask createSearchingForTestsTask() {
        return new SearchingForTestsTask(this.myServerSocket, this.config, this.myTempFile){

            @Override
            protected void onFound() {
                super.onFound();
                TestNGRunnableState.this.writeClassesPerModule(this.myClasses);
            }
        };
    }

    protected void writeClassesPerModule(Map<PsiClass, Map<PsiMethod, List<String>>> classes) {
        if (this.forkPerModule()) {
            TreeMap<Module, ArrayList<String>> perModule = new TreeMap<Module, ArrayList<String>>((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true));
            for (PsiClass psiClass : classes.keySet()) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                if (module == null) continue;
                ArrayList<String> list = (ArrayList<String>)perModule.get(module);
                if (list == null) {
                    list = new ArrayList<String>();
                    perModule.put(module, list);
                }
                list.add(psiClass.getQualifiedName());
            }
            try {
                this.writeClassesPerModule(this.getConfiguration().getPackage(), this.getJavaParameters(), perModule, "");
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    protected String getFrameworkId() {
        return "testng";
    }

    protected void passTempFile(ParametersList parametersList, String tempFilePath) {
        parametersList.add("-temp", tempFilePath);
    }

    @NotNull
    public TestNGConfiguration getConfiguration() {
        TestNGConfiguration testNGConfiguration = this.config;
        if (testNGConfiguration == null) {
            TestNGRunnableState.$$$reportNull$$$0(0);
        }
        return testNGConfiguration;
    }

    protected TestSearchScope getScope() {
        return this.getConfiguration().getPersistantData().getScope();
    }

    protected void passForkMode(String forkMode, File tempFile, JavaParameters parameters) throws ExecutionException {
        ParametersList parametersList = parameters.getProgramParametersList();
        List params = parametersList.getParameters();
        int paramIdx = params.size() - 1;
        for (int i = 0; i < params.size(); ++i) {
            String param = (String)params.get(i);
            if (!"-temp".equals(param)) continue;
            paramIdx = i;
            break;
        }
        parametersList.addAt(paramIdx, "@@@" + tempFile.getAbsolutePath());
        if (this.getForkSocket() != null) {
            parametersList.addAt(paramIdx, "-debugSocket" + this.getForkSocket().getLocalPort());
        }
    }

    protected void collectPackagesToOpen(List<String> options) {
        SourceScope sourceScope;
        PsiPackage aPackage;
        TestData data = this.getConfiguration().getPersistantData();
        if (TestType.METHOD.getType().equals(data.TEST_OBJECT) || TestType.CLASS.getType().equals(data.TEST_OBJECT)) {
            options.add(StringUtil.getPackageName((String)data.MAIN_CLASS_NAME));
        } else if (TestType.PACKAGE.getType().equals(data.TEST_OBJECT) && (aPackage = JavaPsiFacade.getInstance((Project)this.getConfiguration().getProject()).findPackage(data.PACKAGE_NAME)) != null && (sourceScope = data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration())) != null) {
            TestNGRunnableState.collectSubPackages(options, (PsiPackage)aPackage, (GlobalSearchScope)sourceScope.getGlobalSearchScope());
        }
    }

    protected boolean useModulePath() {
        return this.getConfiguration().isUseModulePath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGRunnableState", "getConfiguration"));
    }
}

