/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration.browser;

import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.MessageInfoException;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import com.theoryinpractice.testng.model.TestClassFilter;

public class TestClassBrowser
extends BrowseModuleValueActionListener {
    protected TestNGConfigurationEditor editor;

    public TestClassBrowser(Project project, TestNGConfigurationEditor editor) {
        super(project);
        this.editor = editor;
    }

    protected String showDialog() {
        ClassFilter.ClassFilterWithScope filter;
        try {
            filter = this.getFilter();
        }
        catch (MessageInfoException e) {
            MessagesEx.MessageInfo message = e.getMessageInfo();
            message.showNow();
            return null;
        }
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)this.getProject()).createWithInnerClassesScopeChooser("Choose Test Class", filter.getScope(), (ClassFilter)filter, null);
        this.init(chooser);
        chooser.showDialog();
        PsiClass psiclass = chooser.getSelected();
        if (psiclass == null) {
            return null;
        }
        this.onClassChoosen(psiclass);
        return psiclass.getQualifiedName();
    }

    protected void onClassChoosen(PsiClass psiClass) {
    }

    protected PsiClass findClass(String className) {
        return this.editor.getModuleSelector().findClass(className);
    }

    public ClassFilter.ClassFilterWithScope getFilter() throws MessageInfoException {
        TestNGConfiguration config = new TestNGConfiguration(this.getProject());
        this.editor.applyEditorTo(config);
        GlobalSearchScope scope = this.getSearchScope(config.getModules());
        if (scope == null) {
            scope = GlobalSearchScope.allScope((Project)this.getProject());
        }
        return new TestClassFilter(scope, this.getProject(), false);
    }

    protected GlobalSearchScope getSearchScope(Module[] modules) {
        if (modules == null || modules.length == 0) {
            return null;
        }
        GlobalSearchScope[] scopes = (GlobalSearchScope[])ContainerUtil.map2Array((Object[])modules, GlobalSearchScope.class, module -> GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        return GlobalSearchScope.union((GlobalSearchScope[])scopes);
    }

    private void init(TreeClassChooser chooser) {
        String s = this.getText();
        PsiClass psiclass = this.findClass(s);
        if (psiclass == null) {
            return;
        }
        PsiDirectory psidirectory = psiclass.getContainingFile().getContainingDirectory();
        if (psidirectory != null) {
            chooser.selectDirectory(psidirectory);
        }
        chooser.select(psiclass);
    }
}

