/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import gnu.trove.THashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.server.embedder.Maven2ModelConverter;

public class UnresolvedArtifactsCollector {
    private final boolean myFailOnUnresolved;
    private final Set<MavenId> myUnresolvedIds = new THashSet();

    public UnresolvedArtifactsCollector(boolean failOnUnresolved) {
        this.myFailOnUnresolved = failOnUnresolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveUnresolvedIds(Set<MavenId> result) {
        Set<MavenId> set = this.myUnresolvedIds;
        synchronized (set) {
            result.addAll(this.myUnresolvedIds);
            this.myUnresolvedIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectAndSetResolved(Artifact artifact) {
        if (!artifact.isResolved()) {
            Set<MavenId> set = this.myUnresolvedIds;
            synchronized (set) {
                this.myUnresolvedIds.add(Maven2ModelConverter.createMavenId(artifact));
            }
        }
        if (!this.myFailOnUnresolved) {
            artifact.setResolved(true);
        }
    }
}

