/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.TestCaseLoader;
import com.intellij.TestRecorder;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.idea.Bombed;
import com.intellij.idea.RecordExecution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.tests.ExternalClasspathClassLoader;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestAdapterCache;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Parameterized;

public class TestAll
implements Test {
    private static final String MAX_FAILURE_TEST_COUNT_FLAG = "idea.max.failure.test.count";
    private static final int MAX_FAILURE_TEST_COUNT;
    private static final Filter PERFORMANCE_ONLY;
    private static final Filter NO_PERFORMANCE;
    public static final Filter NOT_BOMBED;
    private final TestCaseLoader myTestCaseLoader;
    private int myRunTests = -1;
    private TestRecorder myTestRecorder;
    private static final List<Throwable> outClassLoadingProblems;
    private static JUnit4TestAdapterCache ourUnit4TestAdapterCache;

    public TestAll(String rootPackage) throws Throwable {
        this(rootPackage, TestAll.getClassRoots());
    }

    public TestAll(String rootPackage, List<? extends File> classesRoots) throws ClassNotFoundException {
        String classFilterName = "tests/testGroups.properties";
        this.myTestCaseLoader = new TestCaseLoader(classFilterName);
        this.myTestCaseLoader.addFirstTest(Class.forName("_FirstInSuiteTest"));
        this.myTestCaseLoader.addLastTest(Class.forName("_LastInSuiteTest"));
        this.myTestCaseLoader.fillTestCases(rootPackage, classesRoots);
        outClassLoadingProblems.addAll(this.myTestCaseLoader.getClassLoadingErrors());
    }

    public static List<Throwable> getLoadingClassProblems() {
        return outClassLoadingProblems;
    }

    public static List<File> getClassRoots() {
        String testRoots = System.getProperty("test.roots");
        if (testRoots != null) {
            System.out.println("Collecting tests from roots specified by test.roots property: " + testRoots);
            return ContainerUtil.map((Object[])testRoots.split(";"), File::new);
        }
        ArrayList roots = ExternalClasspathClassLoader.getRoots();
        if (roots != null) {
            List excludeRoots = ExternalClasspathClassLoader.getExcludeRoots();
            if (excludeRoots != null) {
                System.out.println("Skipping tests from " + excludeRoots.size() + " roots");
                roots = new ArrayList(roots);
                roots.removeAll((Collection<?>)new THashSet((Collection)excludeRoots, FileUtil.FILE_HASHING_STRATEGY));
            }
            System.out.println("Collecting tests from roots specified by classpath.file property: " + roots);
            return roots;
        }
        ClassLoader loader = TestAll.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            return TestAll.getClassRoots(((URLClassLoader)loader).getURLs());
        }
        if (loader instanceof UrlClassLoader) {
            List urls = ((UrlClassLoader)loader).getBaseUrls();
            return TestAll.getClassRoots(urls.toArray(new URL[0]));
        }
        return ContainerUtil.map((Object[])System.getProperty("java.class.path").split(File.pathSeparator), File::new);
    }

    private static List<File> getClassRoots(URL[] urls) {
        List classLoaderRoots = ContainerUtil.map((Object[])urls, url -> new File(VfsUtilCore.urlToPath((String)VfsUtilCore.convertFromUrl((URL)url))));
        System.out.println("Collecting tests from " + classLoaderRoots);
        return classLoaderRoots;
    }

    public int countTestCases() {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        int count = 0;
        for (Class aClass : this.myTestCaseLoader.getClasses()) {
            Test test = this.getTest(aClass);
            if (test == null) continue;
            count += test.countTestCases();
        }
        return count;
    }

    private void addErrorMessage(TestResult testResult, String message) {
        String processedTestsMessage = this.myRunTests <= 0 ? "None of tests was run" : this.myRunTests + " tests processed";
        try {
            testResult.startTest((Test)this);
            testResult.addError((Test)this, new Throwable(processedTestsMessage + " before: " + message));
            testResult.endTest((Test)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult testResult) {
        this.loadTestRecorder();
        TestListener testListener = TestAll.loadDiscoveryListener();
        if (testListener != null) {
            testResult.addListener(testListener);
        }
        List classes = this.myTestCaseLoader.getClasses();
        System.out.println("------");
        System.out.println("Running tests:");
        for (Object aClass : classes) {
            System.out.println(((Class)aClass).getName());
        }
        System.out.println("------");
        int totalTests = classes.size();
        for (Class aClass : classes) {
            boolean recording = false;
            if (this.myTestRecorder != null && TestAll.shouldRecord(aClass)) {
                this.myTestRecorder.beginRecording(aClass, aClass.getAnnotation(RecordExecution.class));
                recording = true;
            }
            try {
                this.runNextTest(testResult, totalTests, aClass);
            }
            finally {
                if (recording) {
                    this.myTestRecorder.endRecording();
                }
            }
            if (!testResult.shouldStop()) continue;
            break;
        }
        if (testListener instanceof Closeable) {
            try {
                ((Closeable)testListener).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static TestListener loadDiscoveryListener() {
        String discoveryListener = System.getProperty("test.discovery.listener");
        if (discoveryListener != null) {
            try {
                return (TestListener)Class.forName(discoveryListener).newInstance();
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    private static boolean shouldRecord(@NotNull Class<?> aClass) {
        if (aClass == null) {
            TestAll.$$$reportNull$$$0(0);
        }
        return aClass.getAnnotation(RecordExecution.class) != null;
    }

    private void loadTestRecorder() {
        String recorderClassName = System.getProperty("test.recorder.class");
        if (recorderClassName != null) {
            try {
                Class<?> recorderClass = Class.forName(recorderClassName);
                this.myTestRecorder = (TestRecorder)recorderClass.newInstance();
            }
            catch (Exception e) {
                System.out.println("Error loading test recorder class '" + recorderClassName + "': " + e);
            }
        }
    }

    private void runNextTest(TestResult testResult, int totalTests, Class<?> testCaseClass) {
        ++this.myRunTests;
        if (testResult.errorCount() + testResult.failureCount() > MAX_FAILURE_TEST_COUNT && MAX_FAILURE_TEST_COUNT >= 0) {
            this.addErrorMessage(testResult, "Too many errors. Executed: " + this.myRunTests + " of " + totalTests);
            testResult.stop();
            return;
        }
        TestAll.log("\nRunning " + testCaseClass.getName());
        Test test = this.getTest(testCaseClass);
        if (test == null) {
            return;
        }
        try {
            test.run(testResult);
        }
        catch (Throwable t) {
            testResult.addError(test, t);
        }
    }

    @Nullable
    private Test getTest(final @NotNull Class<?> testCaseClass) {
        if (testCaseClass == null) {
            TestAll.$$$reportNull$$$0(1);
        }
        try {
            if ((testCaseClass.getModifiers() & 1) == 0) {
                return null;
            }
            Bombed classBomb = testCaseClass.getAnnotation(Bombed.class);
            if (classBomb != null && TestFrameworkUtil.bombExplodes((Bombed)classBomb)) {
                return new ExplodedBomb(testCaseClass.getName(), classBomb);
            }
            Method suiteMethod = TestAll.safeFindMethod(testCaseClass, "suite");
            if (suiteMethod != null && !TestCaseLoader.isPerformanceTestsRun()) {
                return (Test)suiteMethod.invoke(null, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
            }
            if (TestFrameworkUtil.isJUnit4TestClass(testCaseClass, (boolean)false)) {
                boolean runEverything;
                boolean isPerformanceTest = TestCaseLoader.isPerformanceTest(null, testCaseClass);
                boolean bl = runEverything = TestCaseLoader.isIncludingPerformanceTestsRun() || isPerformanceTest && TestCaseLoader.isPerformanceTestsRun();
                if (runEverything) {
                    return this.createJUnit4Adapter(testCaseClass);
                }
                RunWith runWithAnnotation = testCaseClass.getAnnotation(RunWith.class);
                if (runWithAnnotation != null && Parameterized.class.isAssignableFrom(runWithAnnotation.value())) {
                    if (TestCaseLoader.isPerformanceTestsRun() != isPerformanceTest) {
                        return null;
                    }
                    return this.createJUnit4Adapter(testCaseClass);
                }
                JUnit4TestAdapter adapter = this.createJUnit4Adapter(testCaseClass);
                try {
                    adapter.filter(NOT_BOMBED.intersect(TestCaseLoader.isPerformanceTestsRun() ? PERFORMANCE_ONLY : NO_PERFORMANCE));
                }
                catch (NoTestsRemainException noTestsRemainException) {
                    // empty catch block
                }
                return adapter;
            }
            final int[] testsCount = new int[]{0};
            TestSuite suite = new TestSuite(testCaseClass){

                public void addTest(Test test) {
                    if (!(test instanceof TestCase)) {
                        this.doAddTest(test);
                    } else {
                        Bombed methodBomb;
                        String name = ((TestCase)test).getName();
                        if ("warning".equals(name)) {
                            return;
                        }
                        if (!TestCaseLoader.isIncludingPerformanceTestsRun() && TestCaseLoader.isPerformanceTestsRun() ^ TestCaseLoader.isPerformanceTest((String)name, (Class)testCaseClass)) {
                            return;
                        }
                        Method method = this.findTestMethod((TestCase)test);
                        Bombed bombed = methodBomb = method == null ? null : method.getAnnotation(Bombed.class);
                        if (methodBomb == null) {
                            this.doAddTest(test);
                        } else if (TestFrameworkUtil.bombExplodes((Bombed)methodBomb)) {
                            this.doAddTest((Test)new ExplodedBomb(method.getDeclaringClass().getName() + "." + method.getName(), methodBomb));
                        }
                    }
                }

                private void doAddTest(Test test) {
                    testsCount[0] = testsCount[0] + 1;
                    super.addTest(test);
                }

                @Nullable
                private Method findTestMethod(TestCase testCase) {
                    return TestAll.safeFindMethod(testCase.getClass(), testCase.getName());
                }
            };
            return testsCount[0] > 0 ? suite : null;
        }
        catch (Throwable t) {
            System.err.println("Failed to load test: " + testCaseClass.getName());
            t.printStackTrace(System.err);
            return null;
        }
    }

    @NotNull
    protected JUnit4TestAdapter createJUnit4Adapter(@NotNull Class<?> testCaseClass) {
        if (testCaseClass == null) {
            TestAll.$$$reportNull$$$0(2);
        }
        return new JUnit4TestAdapter(testCaseClass, TestAll.getJUnit4TestAdapterCache());
    }

    private static JUnit4TestAdapterCache getJUnit4TestAdapterCache() {
        if (ourUnit4TestAdapterCache == null) {
            try {
                ourUnit4TestAdapterCache = (JUnit4TestAdapterCache)Class.forName("org.apache.tools.ant.taskdefs.optional.junit.CustomJUnit4TestAdapterCache").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Failed to create CustomJUnit4TestAdapterCache, the default JUnit4TestAdapterCache will be used and ignored tests won't be properly reported: " + e.toString());
                ourUnit4TestAdapterCache = JUnit4TestAdapterCache.getDefault();
            }
        }
        return ourUnit4TestAdapterCache;
    }

    @Nullable
    private static Method safeFindMethod(Class<?> klass, String name) {
        return ReflectionUtil.getMethod(klass, (String)name, (Class[])new Class[0]);
    }

    private static void log(String message) {
        TeamCityLogger.info((String)message);
    }

    static {
        Logger.setFactory(TestLoggerFactory.class);
        MAX_FAILURE_TEST_COUNT = Integer.parseInt((String)ObjectUtils.chooseNotNull((Object)System.getProperty(MAX_FAILURE_TEST_COUNT_FLAG), (Object)"150"));
        PERFORMANCE_ONLY = new Filter(){

            public boolean shouldRun(Description description) {
                String className = description.getClassName();
                String methodName = description.getMethodName();
                return TestFrameworkUtil.isPerformanceTest((String)methodName, (String)className);
            }

            public String describe() {
                return "Performance Tests Only";
            }
        };
        NO_PERFORMANCE = new Filter(){

            public boolean shouldRun(Description description) {
                return !PERFORMANCE_ONLY.shouldRun(description);
            }

            public String describe() {
                return "All Except Performance";
            }
        };
        NOT_BOMBED = new Filter(){

            public boolean shouldRun(Description description) {
                return !this.isBombed(description);
            }

            public String describe() {
                return "Not @Bombed";
            }

            private boolean isBombed(Description description) {
                Bombed bombed = (Bombed)description.getAnnotation(Bombed.class);
                return bombed != null && !TestFrameworkUtil.bombExplodes((Bombed)bombed);
            }
        };
        outClassLoadingProblems = new ArrayList<Throwable>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/TestAll";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRecord";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createJUnit4Adapter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExplodedBomb
    extends TestCase {
        private final Bombed myBombed;

        ExplodedBomb(@NotNull String testName, @NotNull Bombed bombed) {
            if (testName == null) {
                ExplodedBomb.$$$reportNull$$$0(0);
            }
            if (bombed == null) {
                ExplodedBomb.$$$reportNull$$$0(1);
            }
            super(testName);
            this.myBombed = bombed;
        }

        protected void runTest() throws Throwable {
            String description = this.myBombed.description().isEmpty() ? "" : " (" + this.myBombed.description() + ")";
            ExplodedBomb.fail((String)("Bomb created by " + this.myBombed.user() + description + " now explodes!"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bombed";
                    break;
                }
            }
            objectArray[1] = "com/intellij/TestAll$ExplodedBomb";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

