/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.ide.TypeNameEP;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.DomPatterns;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IconDescriptionBundleEP;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Actions;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.Separator;
import org.jetbrains.idea.devkit.dom.impl.PropertyKeyReferenceProvider;

public class I18nReferenceContributor
extends PsiReferenceContributor {
    private static final String INTENTION_ACTION_TAG = "intentionAction";
    private static final String INTENTION_ACTION_BUNDLE_TAG = "bundleName";
    private static final String SEPARATOR_TAG = "separator";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            I18nReferenceContributor.$$$reportNull$$$0(0);
        }
        I18nReferenceContributor.registerKeyProviders(registrar);
        I18nReferenceContributor.registerBundleNameProviders(registrar);
    }

    private static void registerKeyProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"key", "groupKey"}, Holder.CONFIGURABLE_EP, Holder.INSPECTION_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "groupKey", "groupBundle"));
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"resourceKey"}, Holder.TYPE_NAME_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "resourceKey", "resourceBundle"));
        XmlAttributeValuePattern separatorKeyPattern = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"key"}).withSuperParent(2, (ElementPattern)DomPatterns.tagWithDom((String)SEPARATOR_TAG, Separator.class));
        registrar.registerReferenceProvider((ElementPattern)separatorKeyPattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider((NullableFunction<? super XmlTag, String>)((NullableFunction)tag -> {
            DomElement domElement = DomUtil.getDomElement((PsiElement)tag);
            if (domElement == null) {
                return null;
            }
            Actions actions = (Actions)DomUtil.getParentOfType((DomElement)domElement, Actions.class, (boolean)true);
            return actions != null ? actions.getResourceBundle().getStringValue() : null;
        })));
        XmlTagPattern.Capture intentionActionKeyTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("categoryKey")).withParent((ElementPattern)DomPatterns.tagWithDom((String)INTENTION_ACTION_TAG, Extension.class));
        registrar.registerReferenceProvider((ElementPattern)intentionActionKeyTagPattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider(true, null, INTENTION_ACTION_BUNDLE_TAG));
    }

    private static void registerBundleNameProviders(PsiReferenceRegistrar registrar) {
        PsiReferenceProvider bundleReferenceProvider = new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new MyResourceBundleReference(element)};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        XmlTagPattern.Capture resourceBundleTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("resource-bundle")).withParent((ElementPattern)DomPatterns.tagWithDom((String)"idea-plugin", IdeaPlugin.class));
        registrar.registerReferenceProvider((ElementPattern)resourceBundleTagPattern, bundleReferenceProvider);
        XmlAttributeValuePattern actionsResourceBundlePattern = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"resource-bundle"}).withSuperParent(2, (ElementPattern)DomPatterns.tagWithDom((String)"actions", Actions.class));
        registrar.registerReferenceProvider((ElementPattern)actionsResourceBundlePattern, bundleReferenceProvider);
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"bundle"}, "groupBundle", Holder.CONFIGURABLE_EP, Holder.INSPECTION_EP), bundleReferenceProvider);
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"resourceBundle"}, Holder.TYPE_NAME_EP, Holder.ICON_DESCRIPTION_BUNDLE_EP), bundleReferenceProvider);
        XmlTagPattern.Capture intentionActionBundleTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName(INTENTION_ACTION_BUNDLE_TAG)).withParent((ElementPattern)DomPatterns.tagWithDom((String)INTENTION_ACTION_TAG, Extension.class));
        registrar.registerReferenceProvider((ElementPattern)intentionActionBundleTagPattern, bundleReferenceProvider);
    }

    private static XmlAttributeValuePattern extensionAttributePattern(String[] attributeNames, final String ... extensionPointClassNames) {
        return (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])attributeNames).inFile((ElementPattern)DomPatterns.inDomFile(IdeaPlugin.class))).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().and((ElementPattern)DomPatterns.withDom((ElementPattern)DomPatterns.domElement(Extension.class).with((PatternCondition)new PatternCondition<Extension>("relevantEP"){

            public boolean accepts(@NotNull Extension extension, ProcessingContext context) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                assert (extensionPoint != null);
                PsiClass beanClass = (PsiClass)extensionPoint.getBeanClass().getValue();
                for (String name : extensionPointClassNames) {
                    if (!InheritanceUtil.isInheritor((PsiClass)beanClass, (String)name)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$2", "accepts"));
            }
        }))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor", "registerReferenceProviders"));
    }

    private static class MyResourceBundleReference
    extends ResourceBundleReference
    implements EmptyResolveMessageProvider {
        private MyResourceBundleReference(PsiElement element) {
            super(element, false);
        }

        public Object @NotNull [] getVariants() {
            Project project = this.myElement.getProject();
            PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance((Project)project);
            ArrayList variants = new ArrayList();
            referenceManager.processPropertiesFiles(GlobalSearchScopesCore.projectProductionScope((Project)project), (baseName, propertiesFile) -> {
                Icon icon = propertiesFile.getContainingFile().getIcon(2);
                String relativePath = ProjectUtil.calcRelativeToProjectPath((VirtualFile)propertiesFile.getVirtualFile(), (Project)project);
                variants.add(LookupElementBuilder.create((Object)propertiesFile, (String)baseName).withIcon(icon).withTailText(" (" + relativePath + ")", true));
                return true;
            }, (BundleNameEvaluator)this);
            Object[] objectArray = variants.toArray(LookupElement.EMPTY_ARRAY);
            if (objectArray == null) {
                MyResourceBundleReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            return "Cannot resolve property bundle";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$MyResourceBundleReference", "getVariants"));
        }
    }

    private static class Holder {
        private static final String CONFIGURABLE_EP = ConfigurableEP.class.getName();
        private static final String INSPECTION_EP = InspectionEP.class.getName();
        private static final String ICON_DESCRIPTION_BUNDLE_EP = IconDescriptionBundleEP.class.getName();
        private static final String TYPE_NAME_EP = TypeNameEP.class.getName();

        private Holder() {
        }
    }
}

