/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionNotFoundInspectionBase;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

public class IntentionDescriptionNotFoundInspection
extends DescriptionNotFoundInspectionBase {
    public IntentionDescriptionNotFoundInspection() {
        super(DescriptionType.INTENTION);
    }

    @Override
    protected CreateHtmlDescriptionFix getFix(Module module, String descriptionDir) {
        return new CreateHtmlDescriptionFix(descriptionDir, module, DescriptionType.INTENTION);
    }

    @Override
    protected boolean skipIfNotRegistered(PsiClass epClass) {
        List<ExtensionCandidate> registrations = ExtensionLocatorKt.locateExtensionsByPsiClass(epClass);
        return registrations.isEmpty();
    }

    @Override
    @NotNull
    protected String getHasNotDescriptionError() {
        return "Intention does not have a description";
    }

    @Override
    @NotNull
    protected String getHasNotBeforeAfterError() {
        return "Intention must have 'before.*.template' and 'after.*.template' beside 'description.html'";
    }
}

