/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\"\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a*\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0002\u001a\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0014H\u0002\"\u0019\u0010\u0000\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"allowedServiceNames", "", "", "Lorg/jetbrains/annotations/NotNull;", "allowedServiceQualifiedNames", "", "classesToCheck", "Lgnu/trove/THashSet;", "kotlin.jvm.PlatformType", "ignoredTagNames", "interfacesToCheck", "serviceBeanFqn", "checkAttributes", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "qualifiedName", "findExtensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "clazz", "Lorg/jetbrains/uast/UClass;", "project", "Lcom/intellij/openapi/project/Project;", "findExtensionPointByImplementationClass", "searchString", "isAllowedParameters", "list", "Lcom/intellij/psi/PsiParameterList;", "extensionPoint", "isAppLevelExtensionPoint", "isServiceAnnotation", "isExtensionBean", "aClass", "intellij.devkit"})
public final class NonDefaultConstructorInspectionKt {
    private static final String serviceBeanFqn = "com.intellij.openapi.components.ServiceDescriptor";
    private static final THashSet<String> ignoredTagNames;
    private static final Set<String> allowedServiceQualifiedNames;
    private static final List<String> allowedServiceNames;
    private static final THashSet<String> interfacesToCheck;
    private static final THashSet<String> classesToCheck;

    private static final ExtensionPoint findExtensionPoint(UClass clazz, Project project) {
        UClass parentClass;
        UElement uElement = clazz.getUastParent();
        if (!(uElement instanceof UClass)) {
            uElement = null;
        }
        if ((parentClass = (UClass)uElement) == null) {
            String string = clazz.getQualifiedName();
            if (string == null) {
                return null;
            }
            String qualifiedName = string;
            return NonDefaultConstructorInspectionKt.findExtensionPointByImplementationClass(qualifiedName, qualifiedName, project);
        }
        String string = parentClass.getQualifiedName();
        if (string == null) {
            return null;
        }
        String parentQualifiedName = string;
        return NonDefaultConstructorInspectionKt.findExtensionPointByImplementationClass(parentQualifiedName, parentQualifiedName + '$' + clazz.getJavaPsi().getName(), project);
    }

    /*
     * WARNING - void declaration
     */
    private static final ExtensionPoint findExtensionPointByImplementationClass(String searchString, String qualifiedName, Project project) {
        void result;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        boolean strictMatch = searchString == qualifiedName;
        ExtensionLocatorKt.processExtensionDeclarations(searchString, project, strictMatch, (Function2<? super Extension, ? super XmlTag, Boolean>)((Function2)new Function2<Extension, XmlTag, Boolean>(qualifiedName, (Ref.ObjectRef)result, strictMatch){
            final /* synthetic */ String $qualifiedName;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ boolean $strictMatch;

            /*
             * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
             * Unable to fully structure code
             * Enabled aggressive block sorting
             */
            public final boolean invoke(@NotNull Extension extension, @NotNull XmlTag tag) {
                block17: {
                    block15: {
                        block18: {
                            block14: {
                                block16: {
                                    Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
                                    Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                                    v0 = extension.getExtensionPoint();
                                    if (v0 == null) {
                                        return true;
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"extension.extensionPoint\u2026xtensionDeclarations true");
                                    point = v0;
                                    v1 = point.getBeanClass();
                                    Intrinsics.checkExpressionValueIsNotNull(v1, (String)"point.beanClass");
                                    v2 = v1.getStringValue();
                                    if (v2 == null) break block16;
                                    var4_4 = v2;
                                    tmp = -1;
                                    switch (var4_4.hashCode()) {
                                        case -1710499692: {
                                            if (var4_4.equals("com.intellij.openapi.components.ServiceDescriptor")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 1: {
                                            v3 = tag.getAttributes();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"tag.attributes");
                                            $this$any$iv = v3;
                                            $i$f$any = false;
                                            var7_12 = $this$any$iv;
                                            var8_15 = var7_12.length;
                                            var9_18 = 0;
                                            while (var9_18 < var8_15) {
                                                it = element$iv = var7_12[var9_18];
                                                $i$a$-any-NonDefaultConstructorInspectionKt$findExtensionPointByImplementationClass$1$2 = false;
                                                v4 = it;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                                                if (!(Intrinsics.areEqual((Object)v4.getName(), (Object)"serviceImplementation") != false && Intrinsics.areEqual((Object)it.getValue(), (Object)this.$qualifiedName) != false)) {
                                                    ++var9_18;
                                                    continue;
                                                }
                                                ** GOTO lbl40
                                            }
                                            return true;
lbl40:
                                            // 1 sources

                                            v5 = true;
                                            if (v5 == false) return true;
                                            this.$result.element = point;
                                            return false;
                                        }
                                        default: {
                                            if (Intrinsics.areEqual((Object)tag.getName(), (Object)"className")) break block17;
                                            v6 = tag.getSubTags();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"tag.subTags");
                                            $this$any$iv = v6;
                                            $i$f$any = false;
                                            var7_13 = $this$any$iv;
                                            var8_16 = var7_13.length;
                                            break;
                                        }
                                    }
                                    break block18;
                                }
                                v7 = tag.getAttributes();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"tag.attributes");
                                $this$any$iv = v7;
                                $i$f$any = false;
                                var7_11 = $this$any$iv;
                                var8_14 = var7_11.length;
                                var9_17 = 0;
                                while (var9_17 < var8_14) {
                                    it = element$iv = var7_11[var9_17];
                                    $i$a$-any-NonDefaultConstructorInspectionKt$findExtensionPointByImplementationClass$1$1 = false;
                                    v8 = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
                                    if (!(Intrinsics.areEqual((Object)v8.getName(), (Object)"implementation") != false && Intrinsics.areEqual((Object)it.getValue(), (Object)this.$qualifiedName) != false)) {
                                        ++var9_17;
                                        continue;
                                    }
                                    break block14;
                                }
                                return true;
                            }
                            v9 = true;
                            if (v9 == false) return true;
                            this.$result.element = point;
                            return false;
                        }
                        for (var9_19 = 0; var9_19 < var8_16; ++var9_19) {
                            it = element$iv = var7_13[var9_19];
                            $i$a$-any-NonDefaultConstructorInspectionKt$findExtensionPointByImplementationClass$1$3 = false;
                            v10 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                            if (!(Intrinsics.areEqual((Object)v10.getName(), (Object)"className") != false && (this.$strictMatch != false || it.textMatches((CharSequence)this.$qualifiedName) != false))) continue;
                            v11 = true;
                            break block15;
                        }
                        v11 = false;
                    }
                    if (!v11) {
                        if (NonDefaultConstructorInspectionKt.access$checkAttributes(tag, this.$qualifiedName) == false) return true;
                    }
                }
                this.$result.element = point;
                return false;
            }
            {
                this.$qualifiedName = string;
                this.$result = objectRef;
                this.$strictMatch = bl;
                super(2);
            }
        }));
        return (ExtensionPoint)result.element;
    }

    private static final boolean checkAttributes(XmlTag tag, String qualifiedName) {
        boolean bl;
        block2: {
            if (ignoredTagNames.contains((Object)tag.getName())) {
                return false;
            }
            XmlAttribute[] xmlAttributeArray = tag.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttributeArray, (String)"tag.attributes");
            XmlAttribute[] $this$any$iv = xmlAttributeArray;
            boolean $i$f$any = false;
            XmlAttribute[] xmlAttributeArray2 = $this$any$iv;
            int n = xmlAttributeArray2.length;
            for (int i = 0; i < n; ++i) {
                String name;
                XmlAttribute element$iv;
                XmlAttribute it = element$iv = xmlAttributeArray2[i];
                boolean bl2 = false;
                XmlAttribute xmlAttribute = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttribute, (String)"it");
                Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttribute.getName(), (String)"it.name");
                boolean bl3 = (StringsKt.startsWith$default((String)name, (String)"implementation", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"instance")) && Intrinsics.areEqual((Object)it.getValue(), (Object)qualifiedName);
                if (!bl3) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean isAllowedParameters(PsiParameterList list, ExtensionPoint extensionPoint, boolean isAppLevelExtensionPoint, boolean isServiceAnnotation) {
        if (list.isEmpty()) {
            return true;
        }
        if (!isServiceAnnotation) {
            ExtensionPoint extensionPoint2 = extensionPoint;
            if (Intrinsics.areEqual((Object)(extensionPoint2 != null ? extensionPoint2.getEffectiveQualifiedName() : null), (Object)"com.intellij.semContributor")) {
                return false;
            }
        }
        PsiParameter[] psiParameterArray = list.getParameters();
        int n = psiParameterArray.length;
        for (int i = 0; i < n; ++i) {
            PsiClassType type;
            PsiParameter parameter;
            PsiParameter psiParameter = parameter = psiParameterArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameter");
            if (psiParameter.isVarArgs()) {
                return false;
            }
            PsiType psiType = parameter.getType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            if ((PsiClassType)psiType == null) {
                return false;
            }
            String name = type.getClassName();
            if (!allowedServiceNames.contains(name)) {
                return false;
            }
            PsiClass psiClass = type.resolve();
            if (psiClass == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"(type.resolve() ?: return false)");
            String qualifiedName = psiClass.getQualifiedName();
            if (!CollectionsKt.contains((Iterable)allowedServiceQualifiedNames, (Object)qualifiedName)) {
                return false;
            }
            if (!isAppLevelExtensionPoint || isServiceAnnotation || !Intrinsics.areEqual((Object)name, (Object)"Project")) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isExtensionBean(UClass aClass) {
        void found;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        InheritanceUtil.processSupers((PsiClass)aClass.getJavaPsi(), (boolean)true, (Processor)((Processor)new Processor<PsiClass>((Ref.BooleanRef)found){
            final /* synthetic */ Ref.BooleanRef $found;

            public final boolean process(PsiClass it) {
                PsiClass psiClass = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"it");
                String qualifiedName = psiClass.getQualifiedName();
                this.$found.element = (it.isInterface() ? NonDefaultConstructorInspectionKt.access$getInterfacesToCheck$p() : NonDefaultConstructorInspectionKt.access$getClassesToCheck$p()).contains((Object)qualifiedName);
                return !this.$found.element;
            }
            {
                this.$found = booleanRef;
            }
        }));
        return found.element;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        ignoredTagNames = new THashSet((Collection)CollectionsKt.listOf((Object[])new String[]{"semContributor", "modelFacade", "scriptGenerator", "editorActionHandler", "editorTypedHandler", "dataImporter", "java.error.fix", "explainPlanProvider"}));
        allowedServiceQualifiedNames = SetsKt.setOf((Object[])new String[]{"com.intellij.openapi.project.Project", "com.intellij.openapi.module.Module", "com.intellij.util.messages.MessageBus", "com.intellij.openapi.options.SchemeManagerFactory", "com.intellij.openapi.editor.actionSystem.TypedActionHandler", "com.intellij.database.Dbms"});
        Iterable $this$map$iv = allowedServiceQualifiedNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringUtil.getShortName((String)it);
            collection.add(string2);
        }
        allowedServiceNames = (List)var3_3;
        interfacesToCheck = new THashSet((Collection)CollectionsKt.listOf((Object[])new String[]{"com.intellij.codeInsight.daemon.LineMarkerProvider", "com.intellij.openapi.fileTypes.SyntaxHighlighterFactory"}));
        classesToCheck = new THashSet((Collection)CollectionsKt.listOf((Object[])new String[]{"com.intellij.codeInsight.completion.CompletionContributor", "com.intellij.codeInsight.completion.CompletionConfidence", "com.intellij.psi.PsiReferenceContributor"}));
    }

    public static final /* synthetic */ boolean access$isExtensionBean(UClass aClass) {
        return NonDefaultConstructorInspectionKt.isExtensionBean(aClass);
    }

    public static final /* synthetic */ ExtensionPoint access$findExtensionPoint(UClass clazz, Project project) {
        return NonDefaultConstructorInspectionKt.findExtensionPoint(clazz, project);
    }

    public static final /* synthetic */ boolean access$isAllowedParameters(PsiParameterList list, ExtensionPoint extensionPoint, boolean isAppLevelExtensionPoint, boolean isServiceAnnotation) {
        return NonDefaultConstructorInspectionKt.isAllowedParameters(list, extensionPoint, isAppLevelExtensionPoint, isServiceAnnotation);
    }

    public static final /* synthetic */ boolean access$checkAttributes(XmlTag tag, String qualifiedName) {
        return NonDefaultConstructorInspectionKt.checkAttributes(tag, qualifiedName);
    }

    public static final /* synthetic */ THashSet access$getInterfacesToCheck$p() {
        return interfacesToCheck;
    }

    public static final /* synthetic */ THashSet access$getClassesToCheck$p() {
        return classesToCheck;
    }
}

