/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ClassExtensionPoint;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;

public class RegisterExtensionFix
implements IntentionAction {
    private final PsiClass myExtensionClass;
    private final Set<? extends ExtensionPointCandidate> myEPCandidates;
    private static final Map<String, String> KEY_MAP = ContainerUtil.immutableMapBuilder().put((Object)KeyedFactoryEPBean.class.getName(), (Object)"key").put((Object)KeyedLazyInstanceEP.class.getName(), (Object)"key").put((Object)FileTypeExtensionPoint.class.getName(), (Object)"filetype").put((Object)LanguageExtensionPoint.class.getName(), (Object)"language").put((Object)ClassExtensionPoint.class.getName(), (Object)"forClass").build();

    public RegisterExtensionFix(PsiClass extensionClass, Set<? extends ExtensionPointCandidate> epCandidates) {
        this.myExtensionClass = extensionClass;
        this.myEPCandidates = epCandidates;
    }

    @NotNull
    public String getText() {
        return "Register extension";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RegisterExtensionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            RegisterExtensionFix.$$$reportNull$$$0(1);
        }
        return !DumbService.isDumb((Project)project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            RegisterExtensionFix.$$$reportNull$$$0(2);
        }
        PluginDescriptorChooser.show(project, editor, file, (Consumer<? super DomFileElement<IdeaPlugin>>)((Consumer)element -> this.doFix(editor, (DomFileElement<IdeaPlugin>)element)));
    }

    private void doFix(Editor editor, final DomFileElement<IdeaPlugin> element) {
        if (this.myEPCandidates.size() == 1) {
            this.registerExtension(element, this.myEPCandidates.iterator().next());
        } else {
            BaseListPopupStep<ExtensionPointCandidate> popupStep = new BaseListPopupStep<ExtensionPointCandidate>("Choose Extension Point", new ArrayList<ExtensionPointCandidate>(this.myEPCandidates)){

                public PopupStep onChosen(ExtensionPointCandidate selectedValue, boolean finalChoice) {
                    RegisterExtensionFix.this.registerExtension((DomFileElement<IdeaPlugin>)element, selectedValue);
                    return FINAL_CHOICE;
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep).showInBestPositionFor(editor);
        }
    }

    private void registerExtension(DomFileElement<IdeaPlugin> selectedValue, ExtensionPointCandidate candidate) {
        PsiElement navTarget = (PsiElement)WriteCommandAction.writeCommandAction((Project)selectedValue.getFile().getProject(), (PsiFile[])new PsiFile[]{selectedValue.getFile()}).compute(() -> {
            Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<? extends IdeaPlugin>)selectedValue, candidate.epName);
            Extension extension = extensions.addExtension(candidate.epName);
            XmlTag tag = extension.getXmlTag();
            XmlAttributeValue target = null;
            String keyAttrName = KEY_MAP.get(candidate.beanClassName);
            if (keyAttrName != null) {
                XmlAttribute attr = tag.setAttribute(keyAttrName, "");
                target = attr.getValueElement();
            }
            if (candidate.attributeName != null) {
                tag.setAttribute(candidate.attributeName, this.myExtensionClass.getQualifiedName());
            } else {
                XmlTag subTag = tag.createChildTag(candidate.tagName, null, this.myExtensionClass.getQualifiedName(), false);
                tag.addSubTag(subTag, false);
            }
            return target != null ? target : extension.getXmlTag();
        });
        PsiNavigateUtil.navigate((PsiElement)navTarget);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

