/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.internal.AnalyzeUnloadablePluginsAction;
import org.jetbrains.idea.devkit.internal.PluginUnloadabilityStatus;
import org.jetbrains.idea.devkit.internal.UnloadabilityStatus;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J^\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/devkit/internal/AnalyzeUnloadablePluginsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "analyzePluginFile", "ideaPlugin", "Lorg/jetbrains/idea/devkit/dom/IdeaPlugin;", "analysisErrors", "", "", "components", "nonDynamicEPs", "", "unspecifiedDynamicEPs", "serviceOverrides", "allowOwnEPs", "", "analyzeUnloadable", "Lorg/jetbrains/idea/devkit/internal/PluginUnloadabilityStatus;", "allPlugins", "", "Lcom/intellij/psi/xml/XmlFile;", "resolvePluginDependency", "dependency", "Lorg/jetbrains/idea/devkit/dom/Dependency;", "showReport", "project", "Lcom/intellij/openapi/project/Project;", "result", "intellij.devkit"})
public final class AnalyzeUnloadablePluginsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        IdeView ideView = view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        PsiDirectory dir = ideView != null ? ideView.getOrChooseDirectory() : null;
        boolean bl = false;
        List result = new ArrayList();
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable runnable = new Runnable(this, dir, project2, result){
            final /* synthetic */ AnalyzeUnloadablePluginsAction this$0;
            final /* synthetic */ PsiDirectory $dir;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $result;

            public final void run() {
                boolean $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this){
                    final /* synthetic */ actionPerformed.show.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final T compute() {
                        void $this$filterIsInstanceTo$iv$iv;
                        PsiFile[] psiFileArray;
                        ProgressIndicator pi;
                        boolean bl = false;
                        ProgressManager progressManager = ProgressManager.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                        ProgressIndicator progressIndicator = pi = progressManager.getProgressIndicator();
                        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"pi");
                        progressIndicator.setIndeterminate(false);
                        PsiDirectory psiDirectory = this.this$0.$dir;
                        GlobalSearchScope globalSearchScope = psiDirectory == null ? GlobalSearchScopesCore.projectProductionScope((Project)this.this$0.$project) : GlobalSearchScopesCore.directoryScope((PsiDirectory)this.this$0.$dir, (boolean)true);
                        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"when (dir) {\n           \u2026pe(dir, true)\n          }");
                        GlobalSearchScope searchScope = globalSearchScope;
                        PsiFile[] psiFileArray2 = FilenameIndex.getFilesByName((Project)this.this$0.$project, (String)"plugin.xml", (GlobalSearchScope)searchScope);
                        boolean bl2 = false;
                        Object object = psiFileArray2;
                        boolean bl3 = false;
                        if (((PsiFile[])object).length == 0) {
                            boolean bl4 = false;
                            psiFileArray = FilenameIndex.getFilesByName((Project)this.this$0.$project, (String)"plugin.xml", (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)this.this$0.$project));
                        } else {
                            psiFileArray = psiFileArray2;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiFileArray, (String)"FilenameIndex.getFilesBy\u2026oductionScope(project)) }");
                        Object[] $this$filterIsInstance$iv22 = psiFileArray;
                        boolean $i$f$filterIsInstance = false;
                        object = $this$filterIsInstance$iv22;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof XmlFile)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List pluginXmlFiles = (List)destination$iv$iv;
                        boolean $this$filterIsInstance$iv22 = false;
                        for (XmlFile pluginXmlFile : (Iterable)pluginXmlFiles) {
                            void processed;
                            pi.checkCanceled();
                            pi.setFraction((double)processed / (double)pluginXmlFiles.size());
                            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.this$0.$project);
                            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                            if (projectRootManager.getFileIndex().isUnderSourceRootOfType(pluginXmlFile.getVirtualFile(), JavaModuleSourceRootTypes.PRODUCTION)) {
                                if (DescriptorUtil.getIdeaPlugin(pluginXmlFile) == null) {
                                } else {
                                    IdeaPlugin ideaPlugin;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)ideaPlugin, (String)"DescriptorUtil.getIdeaPl\u2026luginXmlFile) ?: continue");
                                    PluginUnloadabilityStatus status = AnalyzeUnloadablePluginsAction.access$analyzeUnloadable(this.this$0.this$0, ideaPlugin, pluginXmlFiles);
                                    this.this$0.$result.add(status);
                                    pi.setText(status.getPluginId());
                                }
                            }
                            ++processed;
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = analyzeUnloadablePluginsAction;
                this.$dir = psiDirectory;
                this.$project = project;
                this.$result = list;
            }
        };
        StringBuilder stringBuilder = new StringBuilder().append("Analyzing Plugins (");
        Object object = dir;
        if (object == null || (object = object.getName()) == null) {
            object = "Project";
        }
        boolean show2 = progressManager.runProcessWithProgressSynchronously(runnable, stringBuilder.append((String)object).append(')').toString(), true, e.getProject());
        if (show2) {
            this.showReport(project2, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showReport(Project project, List<PluginUnloadabilityStatus> result) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv33222;
        boolean bl;
        void $this$filterTo$iv$iv42222;
        Iterable $this$filterTo$iv$iv322322;
        Iterable $this$filterTo$iv$iv22322;
        void $this$filterTo$iv$iv52222;
        Object it;
        boolean bl2;
        Object $this$any$iv;
        StringBuilder $this$buildString;
        StringBuilder stringBuilder;
        block32: {
            boolean bl3 = false;
            stringBuilder = new StringBuilder();
            boolean bl4 = false;
            boolean bl5 = false;
            $this$buildString = stringBuilder;
            boolean bl6 = false;
            $this$any$iv = result;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    it = (PluginUnloadabilityStatus)element$iv;
                    boolean bl7 = false;
                    Collection collection = ((PluginUnloadabilityStatus)it).getAnalysisErrors();
                    boolean bl8 = false;
                    if (!(!collection.isEmpty())) continue;
                    bl2 = true;
                    break block32;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            void $this$filterTo$iv$iv62222;
            $this$any$iv = $this$buildString;
            String $i$f$any = "Analysis errors:";
            boolean bl9 = false;
            StringBuilder stringBuilder2 = ((StringBuilder)$this$any$iv).append($i$f$any);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            Object $this$filter$iv = result;
            boolean $i$f$filter222 = false;
            it = $this$filter$iv;
            Collection destination$iv$iv22 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv62222) {
                PluginUnloadabilityStatus it2 = (PluginUnloadabilityStatus)t;
                boolean bl10 = false;
                Collection collection = it2.getAnalysisErrors();
                boolean bl3 = false;
                if (!(!collection.isEmpty())) continue;
                destination$iv$iv22.add(t);
            }
            for (PluginUnloadabilityStatus status : (List)destination$iv$iv22) {
                $this$filter$iv = $this$buildString;
                String $i$f$filter222 = status.getPluginId();
                boolean $this$filterTo$iv$iv62222 = false;
                StringBuilder stringBuilder3 = ((StringBuilder)$this$filter$iv).append($i$f$filter222);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
                for (String analysisError : status.getAnalysisErrors()) {
                    StringBuilder $this$filterTo$iv$iv62222 = $this$buildString;
                    boolean destination$iv$iv22 = false;
                    StringBuilder stringBuilder4 = $this$filterTo$iv$iv62222.append(analysisError);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder4);
                }
                StringsKt.appendln((StringBuilder)$this$buildString);
            }
        }
        Object $this$filter$iv = result;
        boolean $i$f$filter242 = false;
        Iterable $i$f$filter222 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv52222) {
            PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)element$iv$iv;
            boolean bl12 = false;
            if (!(pluginUnloadabilityStatus.getStatus() == UnloadabilityStatus.UNLOADABLE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unloadablePlugins = (List)destination$iv$iv;
        $this$filter$iv = $this$buildString;
        String $i$f$filter242 = "Can unload " + unloadablePlugins.size() + " plugins out of " + result.size();
        boolean $this$filterTo$iv$iv52222 = false;
        StringBuilder stringBuilder5 = ((StringBuilder)$this$filter$iv).append($i$f$filter242);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        for (PluginUnloadabilityStatus status : unloadablePlugins) {
            StringBuilder $this$filterTo$iv$iv52222 = $this$buildString;
            destination$iv$iv = status.getPluginId();
            $i$f$filterTo = false;
            StringBuilder stringBuilder6 = $this$filterTo$iv$iv52222.append((String)destination$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        Iterable $this$filter$iv2 = result;
        boolean $i$f$filter3 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv22322 = new ArrayList();
        boolean $i$f$filterTo2223222 = false;
        for (Object t : $this$filterTo$iv$iv22322) {
            PluginUnloadabilityStatus it4 = (PluginUnloadabilityStatus)t;
            boolean bl13 = false;
            if (!(it4.getStatus() == UnloadabilityStatus.USES_COMPONENTS)) continue;
            destination$iv$iv22322.add(t);
        }
        Object $this$sortedByDescending$iv = (List)destination$iv$iv22322;
        boolean $i$f$sortedByDescending232 = false;
        $this$filterTo$iv$iv22322 = $this$sortedByDescending$iv;
        boolean destination$iv$iv22322 = false;
        Comparator $i$f$filterTo2223222 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getComponents().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getComponents().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List pluginsUsingComponents = CollectionsKt.sortedWith((Iterable)$this$filterTo$iv$iv22322, (Comparator)$i$f$filterTo2223222);
        $this$sortedByDescending$iv = $this$buildString;
        String $i$f$sortedByDescending232 = "Plugins using components (" + pluginsUsingComponents.size() + "):";
        boolean $this$filterTo$iv$iv22322 = false;
        StringBuilder stringBuilder7 = ((StringBuilder)$this$sortedByDescending$iv).append($i$f$sortedByDescending232);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder7);
        for (PluginUnloadabilityStatus status : pluginsUsingComponents) {
            StringBuilder $this$filterTo$iv$iv22322 = $this$buildString;
            String destination$iv$iv22322 = status.getPluginId() + " (" + status.getComponents().size() + ')';
            boolean $i$f$filterTo2223222 = false;
            StringBuilder stringBuilder8 = $this$filterTo$iv$iv22322.append(destination$iv$iv22322);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder8, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder8);
            for (String componentName : status.getComponents()) {
                StringBuilder $i$f$filterTo2223222 = $this$buildString;
                String element$iv$iv = "  " + componentName;
                boolean bl4 = false;
                StringBuilder stringBuilder9 = $i$f$filterTo2223222.append(element$iv$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder9, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder9);
            }
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        Iterable $this$filter$iv3 = result;
        boolean $i$f$filter = false;
        Iterable destination$iv$iv22322 = $this$filter$iv3;
        Collection destination$iv$iv32322 = new ArrayList();
        boolean $i$f$filterTo32322 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv322322) {
            PluginUnloadabilityStatus it5 = (PluginUnloadabilityStatus)element$iv$iv;
            boolean bl14 = false;
            if (!(it5.getStatus() == UnloadabilityStatus.USES_SERVICE_OVERRIDES)) continue;
            destination$iv$iv32322.add(element$iv$iv);
        }
        Object $this$sortedByDescending$iv2 = (List)destination$iv$iv32322;
        boolean $i$f$sortedByDescending332 = false;
        $this$filterTo$iv$iv322322 = $this$sortedByDescending$iv2;
        boolean destination$iv$iv32322 = false;
        Comparator $i$f$filterTo32322 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getServiceOverrides().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getServiceOverrides().size();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List pluginsUsingServiceOverrides = CollectionsKt.sortedWith((Iterable)$this$filterTo$iv$iv322322, (Comparator)$i$f$filterTo32322);
        $this$sortedByDescending$iv2 = $this$buildString;
        String $i$f$sortedByDescending332 = "Plugins using service overrides (" + pluginsUsingServiceOverrides.size() + "):";
        boolean $this$filterTo$iv$iv322322 = false;
        StringBuilder stringBuilder10 = ((StringBuilder)$this$sortedByDescending$iv2).append($i$f$sortedByDescending332);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder10, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder10);
        for (PluginUnloadabilityStatus status : pluginsUsingServiceOverrides) {
            StringBuilder $this$filterTo$iv$iv322322 = $this$buildString;
            String destination$iv$iv32322 = status.getPluginId() + " (" + CollectionsKt.joinToString$default((Iterable)status.getServiceOverrides(), null, null, null, (int)0, null, null, (int)63, null) + ')';
            boolean $i$f$filterTo32322 = false;
            StringBuilder stringBuilder11 = $this$filterTo$iv$iv322322.append(destination$iv$iv32322);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder11, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder11);
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        Object $this$filter$iv4 = result;
        boolean $i$f$filter432 = false;
        Iterable destination$iv$iv32322 = $this$filter$iv4;
        Iterator<Map.Entry<String, Set<String>>> destination$iv$iv4 = new ArrayList();
        boolean bl5 = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv42222) {
            PluginUnloadabilityStatus it232 = (PluginUnloadabilityStatus)element$iv$iv3;
            bl = false;
            if (!(it232.getStatus() == UnloadabilityStatus.NON_DYNAMIC_IN_DEPENDENCIES)) continue;
            destination$iv$iv4.add((Map.Entry<String, Set<String>>)element$iv$iv3);
        }
        List pluginsWithOptionalDependencies = (List)((Object)destination$iv$iv4);
        $this$filter$iv4 = $this$buildString;
        String $i$f$filter432 = "Plugins not unloadable because of optional dependencies (" + pluginsWithOptionalDependencies.size() + "):";
        boolean $this$filterTo$iv$iv42222 = false;
        StringBuilder stringBuilder12 = ((StringBuilder)$this$filter$iv4).append($i$f$filter432);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder12, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder12);
        for (PluginUnloadabilityStatus status : pluginsWithOptionalDependencies) {
            Object $this$filterTo$iv$iv42222 = $this$buildString;
            destination$iv$iv4 = status.getPluginId();
            boolean bl6 = false;
            StringBuilder stringBuilder13 = ((StringBuilder)$this$filterTo$iv$iv42222).append((String)((Object)destination$iv$iv4));
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder13, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder13);
            Map<String, Set<String>> map = status.getNonDynamicEPsInDependencies();
            boolean element$iv$iv = false;
            destination$iv$iv4 = map.entrySet().iterator();
            while (destination$iv$iv4.hasNext()) {
                Object element$iv$iv3 = $this$filterTo$iv$iv42222 = destination$iv$iv4.next();
                boolean it232 = false;
                String string = (String)element$iv$iv3.getKey();
                element$iv$iv3 = $this$filterTo$iv$iv42222;
                it232 = false;
                Set eps = (Set)element$iv$iv3.getValue();
                element$iv$iv3 = $this$buildString;
                String it232 = "  " + string + " - " + CollectionsKt.joinToString$default((Iterable)eps, null, null, null, (int)0, null, null, (int)63, null);
                bl = false;
                StringBuilder stringBuilder14 = ((StringBuilder)element$iv$iv3).append(it232);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder14, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder14);
            }
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        Object $this$filter$iv5 = result;
        boolean $i$f$filter522 = false;
        destination$iv$iv4 = $this$filter$iv5;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo522 = false;
        for (Object element$iv$iv52 : $this$filterTo$iv$iv33222) {
            PluginUnloadabilityStatus it6 = (PluginUnloadabilityStatus)element$iv$iv52;
            boolean bl15 = false;
            if (!(it6.getStatus() == UnloadabilityStatus.USES_NON_DYNAMIC_EPS)) continue;
            collection.add(element$iv$iv52);
        }
        List nonDynamicPlugins = (List)collection;
        $this$filter$iv5 = nonDynamicPlugins;
        $i$f$filter522 = false;
        if (!$this$filter$iv5.isEmpty()) {
            $this$filter$iv5 = $this$buildString;
            String $i$f$filter522 = "Plugins with EPs explicitly marked as dynamic=false:";
            boolean $this$filterTo$iv$iv33222 = false;
            StringBuilder stringBuilder15 = ((StringBuilder)$this$filter$iv5).append($i$f$filter522);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder15, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder15);
            for (PluginUnloadabilityStatus nonDynamicPlugin : nonDynamicPlugins) {
                StringBuilder $this$filterTo$iv$iv33222 = $this$buildString;
                String string = nonDynamicPlugin.getPluginId() + " (" + nonDynamicPlugin.getNonDynamicEPs().size() + ')';
                $i$f$filterTo522 = false;
                StringBuilder stringBuilder16 = $this$filterTo$iv$iv33222.append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder16, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder16);
                for (String ep : nonDynamicPlugin.getNonDynamicEPs()) {
                    StringBuilder $i$f$filterTo522 = $this$buildString;
                    String element$iv$iv3 = "  " + ep;
                    boolean element$iv$iv52 = false;
                    StringBuilder stringBuilder17 = $i$f$filterTo522.append(element$iv$iv3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder17, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder17);
                }
            }
            StringsKt.appendln((StringBuilder)$this$buildString);
        }
        Object $this$filter$iv6 = result;
        boolean $i$f$filter622 = false;
        Iterable iterable = $this$filter$iv6;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterTo6222222 = false;
        for (Object element$iv$iv422 : iterable) {
            boolean bl7;
            block33: {
                PluginUnloadabilityStatus it7 = (PluginUnloadabilityStatus)element$iv$iv422;
                boolean bl17 = false;
                Iterable $this$any$iv2 = it7.getUnspecifiedDynamicEPs();
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        String it8 = (String)element$iv;
                        boolean bl18 = false;
                        if (!(!StringsKt.startsWith$default((String)it8, (String)"cidr", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it8, (String)"appcode", (boolean)false, (int)2, null))) continue;
                        bl7 = true;
                        break block33;
                    }
                    bl7 = false;
                }
            }
            if (!bl7) continue;
            destination$iv$iv6.add(element$iv$iv422);
        }
        List closePlugins = (List)destination$iv$iv6;
        $this$filter$iv6 = closePlugins;
        $i$f$filter622 = false;
        if (!$this$filter$iv6.isEmpty()) {
            $this$filter$iv6 = $this$buildString;
            String $i$f$filter622 = "Plugins with non-dynamic EPs (" + closePlugins.size() + "):";
            boolean bl8 = false;
            StringBuilder stringBuilder18 = ((StringBuilder)$this$filter$iv6).append($i$f$filter622);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder18, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder18);
            Iterable iterable2 = closePlugins;
            boolean $i$f$sortedBy22 = false;
            Iterable $i$f$filterTo6222222 = iterable2;
            boolean element$iv$iv52 = false;
            Comparator element$iv$iv422 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getUnspecifiedDynamicEPs().size());
                    it = (PluginUnloadabilityStatus)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getUnspecifiedDynamicEPs().size();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            for (PluginUnloadabilityStatus status : CollectionsKt.sortedWith((Iterable)$i$f$filterTo6222222, (Comparator)element$iv$iv422)) {
                StringBuilder stringBuilder19 = $this$buildString;
                String $i$f$sortedBy22 = status.getPluginId() + " (" + status.getUnspecifiedDynamicEPs().size() + ')';
                boolean $i$f$filterTo6222222 = false;
                StringBuilder stringBuilder20 = stringBuilder19.append($i$f$sortedBy22);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder20, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder20);
                for (String string : status.getUnspecifiedDynamicEPs()) {
                    StringBuilder $i$f$filterTo6222222 = $this$buildString;
                    String element$iv$iv52 = "  " + string;
                    boolean element$iv$iv422 = false;
                    StringBuilder stringBuilder21 = $i$f$filterTo6222222.append(element$iv$iv52);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder21, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder21);
                }
            }
            StringsKt.appendln((StringBuilder)$this$buildString);
        }
        boolean $i$f$filter622 = false;
        Map epUsagesMap = new LinkedHashMap();
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : result) {
            for (String ep : pluginUnloadabilityStatus.getUnspecifiedDynamicEPs()) {
                epUsagesMap.put(ep, ((Number)epUsagesMap.getOrDefault(ep, 0)).intValue() + 1);
            }
        }
        Iterable iterable3 = MapsKt.toList((Map)epUsagesMap);
        boolean $i$f$filter7 = false;
        Iterable $i$f$filterTo6222222 = iterable3;
        Collection destination$iv$iv7 = new ArrayList();
        boolean $i$f$filterTo7 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it9 = (Pair)element$iv$iv;
            boolean bl19 = false;
            if (!(!StringsKt.startsWith$default((String)((String)it9.getFirst()), (String)"cidr", (boolean)false, (int)2, null))) continue;
            destination$iv$iv7.add(element$iv$iv);
        }
        Iterable iterable4 = (List)destination$iv$iv7;
        boolean $i$f$sortedByDescending = false;
        Iterable iterable5 = iterable4;
        boolean bl9 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(((Number)it.getSecond()).intValue());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ((Number)it.getSecond()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List epUsagesList = CollectionsKt.sortedWith((Iterable)iterable5, (Comparator)comparator);
        StringBuilder stringBuilder22 = $this$buildString;
        String string = "EP usage statistics (" + epUsagesList.size() + " non-dynamic EPs remaining):";
        boolean bl10 = false;
        StringBuilder stringBuilder23 = stringBuilder22.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder23, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder23);
        for (Pair pair : epUsagesList) {
            $this$buildString.append(((Number)pair.getSecond()).intValue() + ": " + (String)pair.getFirst());
            StringsKt.appendln((StringBuilder)$this$buildString);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String report = string2;
        stringBuilder = StringCompanionObject.INSTANCE;
        String string3 = "AnalyzeUnloadablePlugins-Report-%s.txt";
        Object[] objectArray = new Object[]{DateFormatUtil.formatDateTime((long)System.currentTimeMillis())};
        boolean bl22 = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        String fileName = string4;
        LightVirtualFile file = new LightVirtualFile(fileName, (CharSequence)report);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    /*
     * WARNING - void declaration
     */
    private final PluginUnloadabilityStatus analyzeUnloadable(IdeaPlugin ideaPlugin, List<? extends XmlFile> allPlugins) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        Set unspecifiedDynamicEPs = new LinkedHashSet();
        boolean bl2 = false;
        Set nonDynamicEPs = new LinkedHashSet();
        boolean bl3 = false;
        List analysisErrors = new ArrayList();
        boolean bl4 = false;
        List serviceOverrides = new ArrayList();
        boolean bl5 = false;
        List components = new ArrayList();
        this.analyzePluginFile(ideaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, true);
        Iterator<Dependency> iterator = ideaPlugin.getDependencies().iterator();
        while (iterator.hasNext()) {
            String configFileName;
            Dependency dependency;
            Dependency dependency2 = dependency = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependency2, (String)"dependency");
            GenericAttributeValue<PathReference> genericAttributeValue = dependency2.getConfigFile();
            Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue, (String)"dependency.configFile");
            if (genericAttributeValue.getStringValue() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)configFileName, (String)"dependency.configFile.stringValue ?: continue");
            IdeaPlugin depIdeaPlugin = this.resolvePluginDependency(dependency);
            if (depIdeaPlugin == null) {
                analysisErrors.add("Failed to resolve dependency descriptor file " + configFileName);
                continue;
            }
            Iterator<Dependency> iterator2 = depIdeaPlugin.getDependencies().iterator();
            while (iterator2.hasNext()) {
                Dependency nestedDependency;
                Dependency dependency3 = nestedDependency = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)dependency3, (String)"nestedDependency");
                GenericAttributeValue<PathReference> genericAttributeValue2 = dependency3.getConfigFile();
                Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue2, (String)"nestedDependency.configFile");
                if (genericAttributeValue2.getStringValue() == null) continue;
                IdeaPlugin ideaPlugin2 = (IdeaPlugin)nestedDependency.getValue();
                analysisErrors.add("Unsupported nested dependency on " + (ideaPlugin2 != null ? ideaPlugin2.getId() : null) + " in " + configFileName);
            }
            this.analyzePluginFile(depIdeaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, true);
        }
        boolean bl6 = false;
        List componentsInOptionalDependencies = new ArrayList();
        boolean configFileName = false;
        Map nonDynamicEPsInOptionalDependencies = new LinkedHashMap();
        boolean depIdeaPlugin = false;
        List serviceOverridesInDependencies = new ArrayList();
        Iterable $this$mapNotNull$iv = allPlugins;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            IdeaPlugin ideaPlugin3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl7 = false;
            XmlFile it = (XmlFile)element$iv$iv;
            boolean bl8 = false;
            if (DescriptorUtil.getIdeaPlugin(it) == null) continue;
            boolean bl9 = false;
            boolean bl10 = false;
            IdeaPlugin it$iv$iv = ideaPlugin3;
            boolean bl11 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterator iterator4 = ((List)destination$iv$iv).iterator();
        while (iterator4.hasNext()) {
            IdeaPlugin descriptor;
            IdeaPlugin ideaPlugin4 = descriptor = (IdeaPlugin)iterator4.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideaPlugin4, (String)"descriptor");
            Iterator<Dependency> iterator5 = ideaPlugin4.getDependencies().iterator();
            while (iterator5.hasNext()) {
                Dependency dependency;
                Dependency dependency4 = dependency = iterator5.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)dependency4, (String)"dependency");
                GenericAttributeValue<Boolean> genericAttributeValue = dependency4.getOptional();
                Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue, (String)"dependency.optional");
                if (!Intrinsics.areEqual((Object)((Boolean)genericAttributeValue.getValue()), (Object)true) || !Intrinsics.areEqual((Object)dependency.getValue(), (Object)ideaPlugin)) continue;
                IdeaPlugin depIdeaPlugin2 = this.resolvePluginDependency(dependency);
                if (depIdeaPlugin2 == null) {
                    GenericAttributeValue<PathReference> genericAttributeValue3 = dependency.getConfigFile();
                    Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue3, (String)"dependency.configFile");
                    if (genericAttributeValue3.getStringValue() == null) continue;
                    StringBuilder stringBuilder = new StringBuilder().append("Failed to resolve dependency descriptor file ");
                    GenericAttributeValue<PathReference> genericAttributeValue4 = dependency.getConfigFile();
                    Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue4, (String)"dependency.configFile");
                    analysisErrors.add(stringBuilder.append(genericAttributeValue4.getStringValue()).toString());
                    continue;
                }
                boolean bl12 = false;
                Set nonDynamicEPsInDependency = new LinkedHashSet();
                this.analyzePluginFile(depIdeaPlugin2, analysisErrors, componentsInOptionalDependencies, nonDynamicEPsInDependency, nonDynamicEPsInDependency, serviceOverridesInDependencies, false);
                Collection collection = nonDynamicEPsInDependency;
                boolean bl13 = false;
                if (!(!collection.isEmpty())) continue;
                String string = descriptor.getPluginId();
                if (string == null) {
                    string = "<unknown>";
                }
                nonDynamicEPsInOptionalDependencies.put(string, nonDynamicEPsInDependency);
            }
        }
        String string = ideaPlugin.getPluginId();
        if (string == null) {
            string = "?";
        }
        return new PluginUnloadabilityStatus(string, unspecifiedDynamicEPs, nonDynamicEPs, nonDynamicEPsInOptionalDependencies, components, serviceOverrides, analysisErrors);
    }

    private final IdeaPlugin resolvePluginDependency(Dependency dependency) {
        IdeaPlugin ideaPlugin;
        XmlFile xmlFile = dependency.getResolvedConfigFile();
        GenericAttributeValue<PathReference> genericAttributeValue = dependency.getConfigFile();
        Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue, (String)"dependency.configFile");
        String configFileName = genericAttributeValue.getStringValue();
        if (xmlFile == null && configFileName != null) {
            DomManager domManager = dependency.getManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)domManager, (String)"dependency.manager");
            Project project = domManager.getProject();
            Object[] matchingFiles = FilenameIndex.getFilesByName((Project)project, (String)configFileName, (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)project));
            Intrinsics.checkExpressionValueIsNotNull((Object)matchingFiles, (String)"matchingFiles");
            Object object = ArraysKt.singleOrNull((Object[])matchingFiles);
            if (!(object instanceof XmlFile)) {
                object = null;
            }
            xmlFile = (XmlFile)object;
        }
        XmlFile xmlFile2 = xmlFile;
        if (xmlFile2 != null) {
            XmlFile xmlFile3 = xmlFile2;
            boolean bl = false;
            boolean bl2 = false;
            XmlFile it = xmlFile3;
            boolean bl3 = false;
            ideaPlugin = DescriptorUtil.getIdeaPlugin(it);
        } else {
            ideaPlugin = null;
        }
        return ideaPlugin;
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzePluginFile(IdeaPlugin ideaPlugin, List<String> analysisErrors, List<String> components, Set<String> nonDynamicEPs, Set<String> unspecifiedDynamicEPs, List<String> serviceOverrides, boolean allowOwnEPs) {
        String string;
        Collection collection;
        Iterable list$iv$iv;
        Object it;
        Object $this$flatMapTo$iv$iv;
        Object ep;
        void $this$flatMapTo$iv$iv2;
        List<Extensions> list = ideaPlugin.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"ideaPlugin.extensions");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap2 = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            Extensions it2 = (Extensions)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = it2.collectExtensions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            Extension extension;
            Extension extension2 = extension = (Extension)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)extension2, (String)"extension");
            ep = extension2.getExtensionPoint();
            if (ep == null) {
                analysisErrors.add("Cannot resolve EP " + extension.getXmlElementName());
                continue;
            }
            if (allowOwnEPs && (Intrinsics.areEqual((Object)ep.getModule(), (Object)ideaPlugin.getModule()) || Intrinsics.areEqual((Object)ep.getModule(), (Object)extension.getModule()))) continue;
            GenericAttributeValue<Boolean> genericAttributeValue = ep.getDynamic();
            Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue, (String)"ep.dynamic");
            Boolean $i$f$flatMap2 = (Boolean)genericAttributeValue.getValue();
            if (Intrinsics.areEqual((Object)$i$f$flatMap2, (Object)false)) {
                String string2 = ep.getEffectiveQualifiedName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ep.effectiveQualifiedName");
                nonDynamicEPs.add(string2);
            } else if ($i$f$flatMap2 == null) {
                String string3 = ep.getEffectiveQualifiedName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ep.effectiveQualifiedName");
                unspecifiedDynamicEPs.add(string3);
            }
            if (!Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.applicationService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.projectService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.moduleService") || !Intrinsics.areEqual((Object)extension.getXmlTag().getAttributeValue("overrides"), (Object)"true")) continue;
            String string4 = extension.getXmlTag().getAttributeValue("serviceInterface");
            if (string4 == null) {
                string4 = "<unknown>";
            }
            serviceOverrides.add(string4);
        }
        List<ApplicationComponents> list2 = ideaPlugin.getApplicationComponents();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ideaPlugin.applicationComponents");
        Iterable $this$flatMap$iv2 = list2;
        boolean $i$f$flatMap3 = false;
        ep = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        destination$iv$iv = $this$flatMapTo$iv$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            Object element$iv$iv = destination$iv$iv.next();
            it = (ApplicationComponents)element$iv$iv;
            boolean bl = false;
            ApplicationComponents applicationComponents = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationComponents, (String)"it");
            list$iv$iv = applicationComponents.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$mapTo$iv = (List)destination$iv$iv2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            Component.Application $i$f$flatMapTo22 = (Component.Application)item$iv;
            collection = components;
            boolean bl = false;
            void v8 = it3;
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v8.getImplementationClass();
            Intrinsics.checkExpressionValueIsNotNull(genericDomValue, (String)"it.implementationClass");
            String string5 = genericDomValue.getRawText();
            if (string5 == null) {
                string5 = "?";
            }
            string = string5;
            collection.add(string);
        }
        List<ProjectComponents> list3 = ideaPlugin.getProjectComponents();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"ideaPlugin.projectComponents");
        $this$flatMap$iv2 = list3;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo32 = false;
        Iterator bl = $this$flatMapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            it = (ProjectComponents)element$iv$iv;
            boolean bl2 = false;
            Object object = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$mapTo$iv = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it4;
            Component.Project $i$f$flatMapTo32 = (Component.Project)item$iv;
            collection = components;
            boolean bl3 = false;
            void v13 = it4;
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v13.getImplementationClass();
            Intrinsics.checkExpressionValueIsNotNull(genericDomValue, (String)"it.implementationClass");
            String string6 = genericDomValue.getRawText();
            if (string6 == null) {
                string6 = "?";
            }
            string = string6;
            collection.add(string);
        }
        List<ModuleComponents> list4 = ideaPlugin.getModuleComponents();
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"ideaPlugin.moduleComponents");
        $this$flatMap$iv2 = list4;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo42 = false;
        Iterator bl3 = $this$flatMapTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            Object element$iv$iv = bl3.next();
            it = (ModuleComponents)element$iv$iv;
            boolean bl4 = false;
            Object object = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$mapTo$iv = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it5;
            Component.Module $i$f$flatMapTo42 = (Component.Module)item$iv;
            collection = components;
            boolean bl5 = false;
            void v18 = it5;
            Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"it");
            GenericDomValue<PsiClass> genericDomValue = v18.getImplementationClass();
            Intrinsics.checkExpressionValueIsNotNull(genericDomValue, (String)"it.implementationClass");
            String string7 = genericDomValue.getRawText();
            if (string7 == null) {
                string7 = "?";
            }
            string = string7;
            collection.add(string);
        }
    }

    public static final /* synthetic */ PluginUnloadabilityStatus access$analyzeUnloadable(AnalyzeUnloadablePluginsAction $this, IdeaPlugin ideaPlugin, List allPlugins) {
        return $this.analyzeUnloadable(ideaPlugin, allPlugins);
    }
}

