/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation.structure;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.AddToGroup;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.ExtensionPoints;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.dom.KeyboardShortcut;
import org.jetbrains.idea.devkit.dom.PluginModule;
import org.jetbrains.idea.devkit.dom.Separator;
import org.jetbrains.idea.devkit.dom.Vendor;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.ExtensionDomExtender;

public final class PluginDescriptorStructureUtil {
    public static final Icon DEFAULT_ICON = AllIcons.Nodes.Tag;
    private static final Set<String> KNOWN_TOP_LEVEL_NODE_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"id", "name", "version", "category", "resource-bundle"});
    private static final Map<String, String> TAG_DISPLAY_NAME_REPLACEMENTS = new ContainerUtil.ImmutableMapBuilder().put((Object)"psi", (Object)"PSI").put((Object)"dom", (Object)"DOM").put((Object)"sdk", (Object)"SDK").put((Object)"junit", (Object)"JUnit").put((Object)"idea", (Object)"IDEA").put((Object)"javaee", (Object)"JavaEE").put((Object)"jsf", (Object)"JSF").put((Object)"mvc", (Object)"MVC").put((Object)"el", (Object)"EL").put((Object)"id", (Object)"ID").put((Object)"jsp", (Object)"JSP").put((Object)"xml", (Object)"XML").put((Object)"ast", (Object)"AST").put((Object)"gdsl", (Object)"GDSL").put((Object)"pom", (Object)"POM").put((Object)"html", (Object)"HTML").put((Object)"php", (Object)"PHP").build();

    private PluginDescriptorStructureUtil() {
    }

    @NotNull
    public static String getTagDisplayText(@Nullable XmlTag tag) {
        DomElement element = PluginDescriptorStructureUtil.getDomElement(tag);
        if (element == null) {
            return PluginDescriptorStructureUtil.safeGetTagDisplayText(tag);
        }
        if (element instanceof Action) {
            String actionId = ((Action)element).getId().getStringValue();
            if (StringUtil.isNotEmpty((String)actionId)) {
                String string = actionId;
                if (string == null) {
                    PluginDescriptorStructureUtil.$$$reportNull$$$0(0);
                }
                return string;
            }
        } else if (element instanceof ExtensionPoint) {
            ExtensionPoint epElement = (ExtensionPoint)element;
            String epName = epElement.getName().getStringValue();
            if (StringUtil.isNotEmpty((String)epName)) {
                String string = epName;
                if (string == null) {
                    PluginDescriptorStructureUtil.$$$reportNull$$$0(1);
                }
                return string;
            }
            String epQualifiedName = epElement.getQualifiedName().getStringValue();
            if (StringUtil.isNotEmpty((String)epQualifiedName)) {
                String string = PluginDescriptorStructureUtil.toShortName(epQualifiedName);
                if (string == null) {
                    PluginDescriptorStructureUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
        } else if (element instanceof Separator) {
            return "----------";
        }
        return PluginDescriptorStructureUtil.toDisplayName(element.getXmlElementName());
    }

    @NotNull
    public static String safeGetTagDisplayText(@Nullable XmlTag tag) {
        String string = tag != null ? PluginDescriptorStructureUtil.toDisplayName(tag.getLocalName()) : DevKitBundle.message("error.plugin.xml.tag.invalid", new Object[0]);
        if (string == null) {
            PluginDescriptorStructureUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static Icon getTagIcon(@Nullable XmlTag tag) {
        DomElement element = PluginDescriptorStructureUtil.getDomElement(tag);
        if (element == null) {
            return tag != null ? DEFAULT_ICON : null;
        }
        return (Icon)ObjectUtils.notNull((Object)ElementPresentationManager.getIcon((Object)element), (Object)DEFAULT_ICON);
    }

    @Nullable
    public static String getTagLocationString(@Nullable XmlTag tag) {
        DomElement element = PluginDescriptorStructureUtil.getDomElement(tag);
        if (element == null) {
            return null;
        }
        if (element instanceof PluginModule) {
            return PluginDescriptorStructureUtil.getPluginModuleLocation((PluginModule)element);
        }
        if (element instanceof IdeaVersion) {
            return PluginDescriptorStructureUtil.getIdeaVersionLocation((IdeaVersion)element);
        }
        if (element instanceof Extensions) {
            return PluginDescriptorStructureUtil.getExtensionsLocation((Extensions)element);
        }
        if (element instanceof ExtensionPoints) {
            return PluginDescriptorStructureUtil.getExtensionPointsLocation(element);
        }
        if (element instanceof ExtensionPoint) {
            return PluginDescriptorStructureUtil.getExtensionPointLocation((ExtensionPoint)element);
        }
        if (element instanceof With) {
            return PluginDescriptorStructureUtil.getWithLocation((With)element);
        }
        if (element instanceof Component) {
            return PluginDescriptorStructureUtil.getComponentLocation((Component)element);
        }
        if (element instanceof Group) {
            return PluginDescriptorStructureUtil.getGroupLocation((Group)element);
        }
        if (element instanceof AddToGroup) {
            return PluginDescriptorStructureUtil.getAddToGroupLocation((AddToGroup)element);
        }
        if (element instanceof Extension) {
            return PluginDescriptorStructureUtil.getExtensionLocation((Extension)element);
        }
        if (element instanceof KeyboardShortcut) {
            return PluginDescriptorStructureUtil.getKeyboardShortcutLocation((KeyboardShortcut)element);
        }
        if (element instanceof Vendor) {
            return PluginDescriptorStructureUtil.getVendorLocation((Vendor)element);
        }
        if (element.getParent() instanceof IdeaPlugin && element instanceof GenericDomValue) {
            return PluginDescriptorStructureUtil.getTopLevelNodeLocation((GenericDomValue)element);
        }
        return PluginDescriptorStructureUtil.guessTagLocation(element);
    }

    private static String getPluginModuleLocation(PluginModule pluginModule) {
        return pluginModule.getValue().getStringValue();
    }

    @Nullable
    private static String getIdeaVersionLocation(IdeaVersion element) {
        String since = element.getSinceBuild().getStringValue();
        if (StringUtil.isNotEmpty((String)since)) {
            String until = element.getUntilBuild().getStringValue();
            return since + " - " + (StringUtil.isNotEmpty((String)until) ? until : "...");
        }
        return null;
    }

    @Nullable
    private static String getExtensionsLocation(Extensions element) {
        return element.getDefaultExtensionNs().getStringValue();
    }

    @Nullable
    private static String getExtensionPointsLocation(DomElement element) {
        DomElement parent = element.getParent();
        if (parent instanceof IdeaPlugin) {
            return ((IdeaPlugin)parent).getPluginId();
        }
        return null;
    }

    @Nullable
    private static String getExtensionPointLocation(ExtensionPoint element) {
        String epInterface = element.getInterface().getStringValue();
        if (StringUtil.isNotEmpty((String)epInterface)) {
            return PluginDescriptorStructureUtil.toShortName(epInterface);
        }
        String epBeanClass = element.getBeanClass().getStringValue();
        if (StringUtil.isNotEmpty((String)epBeanClass)) {
            return PluginDescriptorStructureUtil.toShortName(epBeanClass);
        }
        return null;
    }

    @Nullable
    private static String getWithLocation(With element) {
        return element.getAttribute().getStringValue();
    }

    @Nullable
    private static String getComponentLocation(Component element) {
        String implementationClassText = element.getImplementationClass().getRawText();
        return PluginDescriptorStructureUtil.toShortName(implementationClassText);
    }

    @Nullable
    private static String getGroupLocation(ActionOrGroup element) {
        return element.getId().getStringValue();
    }

    @Nullable
    private static String getAddToGroupLocation(AddToGroup element) {
        return element.getGroupId().getStringValue();
    }

    @Nullable
    private static String getExtensionLocation(Extension element) {
        String extensionsNamespace;
        DomElement parent = element.getParent();
        if (parent instanceof Extensions && "com.intellij".equals(extensionsNamespace = ((Extensions)parent).getDefaultExtensionNs().getStringValue())) {
            String elementName = element.getXmlElementName();
            if (elementName.equalsIgnoreCase("applicationService") || elementName.equalsIgnoreCase("projectService") || elementName.equalsIgnoreCase("moduleService")) {
                String result = element.getId().getStringValue();
                if (StringUtil.isEmpty((String)result)) {
                    result = PluginDescriptorStructureUtil.toShortName(PluginDescriptorStructureUtil.firstNotNullAttribute(element, "serviceInterface", "serviceImplementation"));
                }
                return result;
            }
            if (elementName.equalsIgnoreCase("intentionAction")) {
                return PluginDescriptorStructureUtil.toShortName(PluginDescriptorStructureUtil.getSubTagText(element, "className"));
            }
            if (elementName.equalsIgnoreCase("dom.extender")) {
                String result = element.getId().getStringValue();
                if (StringUtil.isEmpty((String)result)) {
                    result = PluginDescriptorStructureUtil.toShortName(PluginDescriptorStructureUtil.firstNotNullAttribute(element, "extenderClass"));
                }
                return result;
            }
            if (elementName.equalsIgnoreCase("stacktrace.fold")) {
                return PluginDescriptorStructureUtil.firstNotNullAttribute(element, "substring");
            }
        }
        return PluginDescriptorStructureUtil.guessTagLocation(element);
    }

    @Nullable
    private static String getKeyboardShortcutLocation(KeyboardShortcut element) {
        return element.getFirstKeystroke().getStringValue();
    }

    @NotNull
    private static String getVendorLocation(Vendor element) {
        String string = element.getValue();
        if (string == null) {
            PluginDescriptorStructureUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static String getTopLevelNodeLocation(GenericDomValue<?> element) {
        if (element instanceof Dependency) {
            Dependency dependency = (Dependency)element;
            String result = dependency.getRawText();
            Boolean optional = (Boolean)dependency.getOptional().getValue();
            if (optional != null && optional.booleanValue()) {
                result = result + " [optional]";
            }
            return result;
        }
        if (KNOWN_TOP_LEVEL_NODE_NAMES.contains(StringUtil.toLowerCase((String)element.getXmlElementName()))) {
            return element.getRawText();
        }
        return null;
    }

    @Nullable
    private static String guessTagLocation(DomElement element) {
        String location = PluginDescriptorStructureUtil.toShortName(PluginDescriptorStructureUtil.firstNotNullAttribute(element, "instance", "class", "implementation", "implementationClass", "interface", "interfaceClass"));
        if (location == null && !(element instanceof Action)) {
            location = PluginDescriptorStructureUtil.firstNotNullAttribute(element, "id", "name", "displayName", "shortName");
        }
        if (location == null) {
            location = PluginDescriptorStructureUtil.firstNotNullAttribute(element, "file");
        }
        if (location != null) {
            return location;
        }
        DomGenericInfo genericInfo = element.getGenericInfo();
        List attrDescriptions = genericInfo.getAttributeChildrenDescriptions();
        String possibleOnlyAttrValue = null;
        for (DomAttributeChildDescription description2 : attrDescriptions) {
            String value = description2.getDomAttributeValue(element).getStringValue();
            if (StringUtil.isEmpty((String)value)) continue;
            if (possibleOnlyAttrValue == null) {
                possibleOnlyAttrValue = value;
                continue;
            }
            possibleOnlyAttrValue = null;
            break;
        }
        if (possibleOnlyAttrValue != null && StringUtil.countChars(possibleOnlyAttrValue, (char)'.') > 2) {
            possibleOnlyAttrValue = PluginDescriptorStructureUtil.toShortName(possibleOnlyAttrValue);
        }
        if (possibleOnlyAttrValue != null) {
            return possibleOnlyAttrValue;
        }
        if (attrDescriptions.isEmpty() && genericInfo.getFixedChildrenDescriptions().isEmpty() && element instanceof GenericDomValue) {
            return ((GenericDomValue)element).getRawText();
        }
        return null;
    }

    @Nullable
    private static String toShortName(@Nullable String fqName) {
        if (fqName == null || fqName.contains(" ")) {
            return null;
        }
        String shortName = StringUtil.substringAfterLast((String)fqName, (String)".");
        if (shortName != null) {
            return shortName;
        }
        return fqName;
    }

    @NotNull
    private static String toDisplayName(@NotNull String tagName) {
        if (tagName == null) {
            PluginDescriptorStructureUtil.$$$reportNull$$$0(5);
        }
        String result = tagName.replaceAll("-", " ").replaceAll("\\.", "|");
        String[] words = NameUtil.nameToWords((String)result);
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            String replacement = TAG_DISPLAY_NAME_REPLACEMENTS.get(StringUtil.toLowerCase((String)word));
            if (replacement == null) continue;
            words[i] = replacement;
        }
        result = StringUtil.join((String[])words, (String)" ");
        String string = result = StringUtil.capitalizeWords((String)result, (boolean)true);
        if (string == null) {
            PluginDescriptorStructureUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static String firstNotNullAttribute(DomElement element, String ... attributes) {
        DomGenericInfo genericInfo = element.getGenericInfo();
        for (String attribute : attributes) {
            String value;
            DomAttributeChildDescription description2 = genericInfo.getAttributeChildDescription(attribute);
            if (description2 == null || !StringUtil.isNotEmpty((String)(value = description2.getDomAttributeValue(element).getStringValue()))) continue;
            return value;
        }
        return null;
    }

    @Nullable
    private static String getSubTagText(DomElement element, String subTagName) {
        DomFixedChildDescription subTagDescription = element.getGenericInfo().getFixedChildDescription(subTagName);
        if (subTagDescription == null) {
            return null;
        }
        return subTagDescription.getValues(element).stream().filter(e -> e instanceof ExtensionDomExtender.SimpleTagValue).map(e -> (ExtensionDomExtender.SimpleTagValue)e).map(GenericValue::getStringValue).findAny().orElse(null);
    }

    @Nullable
    private static DomElement getDomElement(@Nullable XmlTag tag) {
        if (tag == null) {
            return null;
        }
        Project project = tag.getProject();
        return DomManager.getDomManager((Project)project).getDomElement(tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/navigation/structure/PluginDescriptorStructureUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagDisplayText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "safeGetTagDisplayText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendorLocation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/navigation/structure/PluginDescriptorStructureUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

