/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes.metadata;

import com.intellij.ide.ui.UIThemeMetadata;
import com.intellij.ide.ui.UIThemeMetadataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UIThemeMetadataService {
    public static final ExtensionPointName<UIThemeMetadataProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.themeMetadataProvider");
    private final Map<UIThemeMetadata, Map<String, UIThemeMetadata.UIKeyMetadata>> myCache = new HashMap<UIThemeMetadata, Map<String, UIThemeMetadata.UIKeyMetadata>>();

    public static UIThemeMetadataService getInstance() {
        return (UIThemeMetadataService)ServiceManager.getService(UIThemeMetadataService.class);
    }

    public UIThemeMetadataService() {
        List themeMetadata = ContainerUtil.mapNotNull((Collection)EP_NAME.getExtensionList(), UIThemeMetadataProvider::loadMetadata);
        for (UIThemeMetadata metadata : themeMetadata) {
            this.myCache.put(metadata, ContainerUtil.newMapFromValues(metadata.getUiKeyMetadata().iterator(), o -> o.getKey()));
        }
    }

    public boolean processAllKeys(PairProcessor<? super UIThemeMetadata, ? super UIThemeMetadata.UIKeyMetadata> processor) {
        for (Map.Entry<UIThemeMetadata, Map<String, UIThemeMetadata.UIKeyMetadata>> entry : this.myCache.entrySet()) {
            for (Map.Entry<String, UIThemeMetadata.UIKeyMetadata> uiKeyMetadataEntry : entry.getValue().entrySet()) {
                if (processor.process((Object)entry.getKey(), (Object)uiKeyMetadataEntry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> findByKey(String key) {
        for (Map.Entry<UIThemeMetadata, Map<String, UIThemeMetadata.UIKeyMetadata>> entry : this.myCache.entrySet()) {
            UIThemeMetadata.UIKeyMetadata byKey = entry.getValue().get(key);
            if (byKey == null) continue;
            return Pair.pair((Object)entry.getKey(), (Object)byKey);
        }
        return null;
    }
}

