/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.editor.PropertyBundleEditorStructureViewElement;
import com.intellij.lang.properties.editor.PropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorBundle;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleEditorShowQuickFixesAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ResourceBundleEditorShowQuickFixesAction.class);

    public ResourceBundleEditorShowQuickFixesAction() {
        super(ResourceBundleEditorBundle.messagePointer("resource.bundle.editor.show.quick.fixes.action.text", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] descriptorsAndSources;
        ResourceBundleEditor editor;
        if (e == null) {
            ResourceBundleEditorShowQuickFixesAction.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((editor = ResourceBundleEditorShowQuickFixesAction.getEditor(e)) != null);
        PropertyBundleEditorStructureViewElement element = (PropertyBundleEditorStructureViewElement)editor.getSelectedElementIfOnlyOne();
        LOG.assertTrue(element != null);
        PsiFile file = editor.getResourceBundle().getDefaultPropertiesFile().getContainingFile();
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        boolean isQuickFixListEmpty = true;
        for (Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey> p : descriptorsAndSources = element.getProblemDescriptors()) {
            ResourceBundleEditorProblemDescriptor d = (ResourceBundleEditorProblemDescriptor)p.getFirst();
            HighlightDisplayKey sourceKey = (HighlightDisplayKey)p.getSecond();
            QuickFix[] fixes = d.getFixes();
            if (fixes == null) continue;
            for (int i = 0; i < fixes.length; ++i) {
                intentions.inspectionFixesToShow.add(new HighlightInfo.IntentionActionDescriptor((IntentionAction)new RBEQuickFixWrapper(d, i), null, null, AllIcons.Actions.IntentionBulb, sourceKey, null, null));
                isQuickFixListEmpty = false;
            }
        }
        if (isQuickFixListEmpty) {
            return;
        }
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new IntentionListStep(null, null, file, project, CachedIntentions.create((Project)project, (PsiFile)file, null, (ShowIntentionsPass.IntentionsInfo)intentions))).showInBestPositionFor(e.getDataContext());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ResourceBundleEditorShowQuickFixesAction.$$$reportNull$$$0(1);
        }
        ResourceBundleEditor editor = ResourceBundleEditorShowQuickFixesAction.getEditor(e);
        e.getPresentation().setEnabledAndVisible(editor != null && editor.getSelectedElementIfOnlyOne() instanceof PropertyStructureViewElement);
    }

    private static ResourceBundleEditor getEditor(@NotNull AnActionEvent e) {
        FileEditor editor;
        if (e == null) {
            ResourceBundleEditorShowQuickFixesAction.$$$reportNull$$$0(2);
        }
        return (editor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR)) instanceof ResourceBundleEditor ? (ResourceBundleEditor)editor : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleEditorShowQuickFixesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RBEQuickFixWrapper
    implements IntentionAction {
        private final ResourceBundleEditorProblemDescriptor myDescriptor;
        private final int myIndex;

        private RBEQuickFixWrapper(ResourceBundleEditorProblemDescriptor descriptor, int index) {
            this.myDescriptor = descriptor;
            this.myIndex = index;
        }

        @Nls
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                RBEQuickFixWrapper.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getQuickFix().getFamilyName();
            if (string == null) {
                RBEQuickFixWrapper.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                RBEQuickFixWrapper.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                RBEQuickFixWrapper.$$$reportNull$$$0(3);
            }
            QuickFix<ResourceBundleEditorProblemDescriptor> fix = this.getQuickFix();
            ThrowableRunnable fixAction = () -> fix.applyFix(project, (CommonProblemDescriptor)this.myDescriptor);
            if (fix.startInWriteAction()) {
                WriteAction.run((ThrowableRunnable)fixAction);
            } else {
                fixAction.run();
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private QuickFix<ResourceBundleEditorProblemDescriptor> getQuickFix() {
            return this.myDescriptor.getFixes()[this.myIndex];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/editor/ResourceBundleEditorShowQuickFixesAction$RBEQuickFixWrapper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleEditorShowQuickFixesAction$RBEQuickFixWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

