/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;

public class TextMateBraceMatcher
implements BraceMatcher {
    public int getBraceTokenGroupId(IElementType tokenType) {
        return -1;
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        if (iterator.getStart() == iterator.getEnd()) {
            return false;
        }
        IElementType tokenType = iterator.getTokenType();
        String currentSelector = tokenType != null ? tokenType.toString() : null;
        return TextMateEditorUtils.getHighlightingPairForLeftChar(fileText.charAt(iterator.getStart()), currentSelector) != null;
    }

    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        int end = iterator.getEnd();
        if (end == 0 || end == iterator.getStart()) {
            return false;
        }
        IElementType tokenType = iterator.getTokenType();
        String currentSelector = tokenType != null ? tokenType.toString() : null;
        return TextMateEditorUtils.getHighlightingPairForRightChar(fileText.charAt(end - 1), currentSelector) != null;
    }

    public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
        return true;
    }

    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        return false;
    }

    @Nullable
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        if (type == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(0);
        }
        return null;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            TextMateBraceMatcher.$$$reportNull$$$0(1);
        }
        return true;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateBraceMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOppositeBraceTokenType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

