/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell.protocol;

import java.io.Serializable;
import java.util.Objects;

public class CodeSnippet
implements Serializable {
    private String myId;
    private Kind myKind;
    private SubKind mySubKind;
    private String myCodeText;
    private String myPresentation;

    public CodeSnippet() {
    }

    public CodeSnippet(String id, Kind kind, SubKind subKind, String codeText, String presentation) {
        this.myId = id;
        this.myKind = kind;
        this.mySubKind = subKind;
        this.myCodeText = codeText;
        this.myPresentation = presentation;
    }

    public String getId() {
        return this.myId;
    }

    public Kind getKind() {
        return this.myKind;
    }

    public SubKind getSubKind() {
        return this.mySubKind;
    }

    public String getCodeText() {
        return this.myCodeText;
    }

    public String getPresentation() {
        return this.myPresentation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeSnippet snippet = (CodeSnippet)o;
        if (!Objects.equals(this.myId, snippet.myId)) {
            return false;
        }
        if (this.myKind != snippet.myKind) {
            return false;
        }
        if (this.mySubKind != snippet.mySubKind) {
            return false;
        }
        if (!Objects.equals(this.myCodeText, snippet.myCodeText)) {
            return false;
        }
        return Objects.equals(this.myPresentation, snippet.myPresentation);
    }

    public int hashCode() {
        int result = this.myId != null ? this.myId.hashCode() : 0;
        result = 31 * result + (this.myKind != null ? this.myKind.hashCode() : 0);
        result = 31 * result + (this.mySubKind != null ? this.mySubKind.hashCode() : 0);
        result = 31 * result + (this.myCodeText != null ? this.myCodeText.hashCode() : 0);
        result = 31 * result + (this.myPresentation != null ? this.myPresentation.hashCode() : 0);
        return result;
    }

    public static enum SubKind {
        SINGLE_TYPE_IMPORT_SUBKIND(Kind.IMPORT),
        TYPE_IMPORT_ON_DEMAND_SUBKIND(Kind.IMPORT),
        SINGLE_STATIC_IMPORT_SUBKIND(Kind.IMPORT),
        STATIC_IMPORT_ON_DEMAND_SUBKIND(Kind.IMPORT),
        CLASS_SUBKIND(Kind.TYPE_DECL),
        INTERFACE_SUBKIND(Kind.TYPE_DECL),
        ENUM_SUBKIND(Kind.TYPE_DECL),
        ANNOTATION_TYPE_SUBKIND(Kind.TYPE_DECL),
        METHOD_SUBKIND(Kind.METHOD),
        VAR_DECLARATION_SUBKIND(Kind.VAR),
        VAR_DECLARATION_WITH_INITIALIZER_SUBKIND(Kind.VAR, true, true),
        TEMP_VAR_EXPRESSION_SUBKIND(Kind.VAR, true, true),
        VAR_VALUE_SUBKIND(Kind.EXPRESSION, true, true),
        ASSIGNMENT_SUBKIND(Kind.EXPRESSION, true, true),
        OTHER_EXPRESSION_SUBKIND(Kind.EXPRESSION, true, true),
        STATEMENT_SUBKIND(Kind.STATEMENT, true, false),
        UNKNOWN_SUBKIND(Kind.ERRONEOUS, false, false);

        private final boolean isExecutable;
        private final boolean hasValue;
        private final Kind kind;

        private SubKind(Kind kind) {
            this.kind = kind;
            this.isExecutable = false;
            this.hasValue = false;
        }

        private SubKind(Kind kind, boolean isExecutable, boolean hasValue) {
            this.kind = kind;
            this.isExecutable = isExecutable;
            this.hasValue = hasValue;
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public Kind kind() {
            return this.kind;
        }
    }

    public static enum Kind {
        IMPORT(true),
        TYPE_DECL(true),
        METHOD(true),
        VAR(true),
        EXPRESSION(false),
        STATEMENT(false),
        ERRONEOUS(false),
        UNKNOWN(false);

        private final boolean isPersistent;

        private Kind(boolean isPersistent) {
            this.isPersistent = isPersistent;
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }
    }

    public static enum Status {
        VALID(true, true),
        RECOVERABLE_DEFINED(true, true),
        RECOVERABLE_NOT_DEFINED(true, false),
        DROPPED(false, false),
        OVERWRITTEN(false, false),
        REJECTED(false, false),
        NONEXISTENT(false, false),
        UNKNOWN(false, false);

        private final boolean myIsActive;
        private final boolean myIsDefined;

        private Status(boolean isActive, boolean isDefined) {
            this.myIsActive = isActive;
            this.myIsDefined = isDefined;
        }

        public boolean isActive() {
            return this.myIsActive;
        }

        public boolean isDefined() {
            return this.myIsDefined;
        }
    }
}

