/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.visitors;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.InstanceField;
import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.diagnostic.hprof.util.FileChannelBackedWriteBuffer;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J_\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0016\u00a2\u0006\u0002\u0010#J(\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0016J(\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0016J(\u0010.\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u000201H\u0016J\u0014\u00102\u001a\u00020\u0013*\u00020\u000b2\u0006\u00103\u001a\u00020\rH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/CreateAuxiliaryFilesVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "auxOffsetsChannel", "Ljava/nio/channels/FileChannel;", "auxChannel", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "parser", "Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "(Ljava/nio/channels/FileChannel;Ljava/nio/channels/FileChannel;Lcom/intellij/diagnostic/hprof/classstore/ClassStore;Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;)V", "aux", "Lcom/intellij/diagnostic/hprof/util/FileChannelBackedWriteBuffer;", "directByteBufferCapacityOffset", "", "directByteBufferClass", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "directByteBufferFdOffset", "offsets", "postVisit", "", "preVisit", "visitClassDump", "classId", "", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "writeId", "id", "Companion", "intellij.platform.ide.impl"})
public final class CreateAuxiliaryFilesVisitor
extends HProfVisitor {
    private FileChannelBackedWriteBuffer offsets;
    private FileChannelBackedWriteBuffer aux;
    private ClassDefinition directByteBufferClass;
    private int directByteBufferCapacityOffset;
    private int directByteBufferFdOffset;
    private final FileChannel auxOffsetsChannel;
    private final FileChannel auxChannel;
    private final ClassStore classStore;
    private final HProfEventBasedParser parser;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.offsets = new FileChannelBackedWriteBuffer(this.auxOffsetsChannel, false, 2, null);
        this.aux = new FileChannelBackedWriteBuffer(this.auxChannel, false, 2, null);
        this.directByteBufferClass = null;
        ClassDefinition dbbClass = this.classStore.getClassIfExists("java.nio.DirectByteBuffer");
        if (dbbClass != null) {
            this.directByteBufferClass = dbbClass;
            this.directByteBufferCapacityOffset = dbbClass.computeOffsetOfField("capacity", this.classStore);
            this.directByteBufferFdOffset = dbbClass.computeOffsetOfField("fd", this.classStore);
            if (this.directByteBufferCapacityOffset == -1 || this.directByteBufferFdOffset == -1) {
                LOG.error("DirectByteBuffer.capacity and/or .fd field is missing.");
            }
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        fileChannelBackedWriteBuffer.writeInt(0);
    }

    @Override
    public void postVisit() {
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.aux;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer.close();
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        fileChannelBackedWriteBuffer2.close();
    }

    @Override
    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)elementType), (String)"elementType");
        boolean bl = arrayObjectId <= (long)Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        bl = fileChannelBackedWriteBuffer.position() / 4 == (int)arrayObjectId;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.aux;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer2.writeInt(fileChannelBackedWriteBuffer3.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        ClassDefinition classDefinition = this.classStore.getClassForPrimitiveArray(elementType);
        if (classDefinition == null) {
            Intrinsics.throwNpe();
        }
        this.writeId(fileChannelBackedWriteBuffer4, (int)classDefinition.getId());
        bl = numberOfElements <= (long)Integer.MAX_VALUE;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer5 = this.aux;
        if (fileChannelBackedWriteBuffer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer5.writeNonNegativeLEB128Int((int)numberOfElements);
    }

    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Intrinsics.checkParameterIsNotNull((Object)constants, (String)"constants");
        Intrinsics.checkParameterIsNotNull((Object)staticFields, (String)"staticFields");
        Intrinsics.checkParameterIsNotNull((Object)instanceFields, (String)"instanceFields");
        boolean bl = classId <= (long)Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        bl = fileChannelBackedWriteBuffer.position() / 4 == (int)classId;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.aux;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer2.writeInt(fileChannelBackedWriteBuffer3.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        this.writeId(fileChannelBackedWriteBuffer4, 0);
    }

    @Override
    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        long it;
        long element$iv;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        boolean bl = arrayObjectId <= (long)Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = arrayClassObjectId <= (long)Integer.MAX_VALUE;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        bl = fileChannelBackedWriteBuffer.position() / 4 == (int)arrayObjectId;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.aux;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer2.writeInt(fileChannelBackedWriteBuffer3.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        this.writeId(fileChannelBackedWriteBuffer4, (int)arrayClassObjectId);
        long[] $this$count$iv = objects;
        boolean $i$f$count22 = false;
        int count$iv = 0;
        long[] lArray = $this$count$iv;
        int n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = lArray[n];
            boolean bl7 = false;
            if (!(it != 0L)) continue;
            ++count$iv;
        }
        int nonNullElementsCount = count$iv;
        long[] $i$f$count22 = objects;
        count$iv = 0;
        int nullElementsCount = $i$f$count22.length - nonNullElementsCount;
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer5 = this.aux;
        if (fileChannelBackedWriteBuffer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer5.writeNonNegativeLEB128Int(nullElementsCount);
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer6 = this.aux;
        if (fileChannelBackedWriteBuffer6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer6.writeNonNegativeLEB128Int(nonNullElementsCount);
        long[] $this$forEach$iv = objects;
        boolean $i$f$forEach = false;
        lArray = $this$forEach$iv;
        n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = lArray[n];
            boolean bl8 = false;
            if (it == 0L) continue;
            boolean bl9 = it <= (long)Integer.MAX_VALUE;
            boolean bl10 = false;
            boolean bl11 = false;
            if (_Assertions.ENABLED && !bl9) {
                boolean bl12 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer7 = this.aux;
            if (fileChannelBackedWriteBuffer7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            }
            this.writeId(fileChannelBackedWriteBuffer7, (int)it);
        }
    }

    @Override
    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        boolean bl = objectId <= (long)Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = classObjectId <= (long)Integer.MAX_VALUE;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        bl = fileChannelBackedWriteBuffer.position() / 4 == (int)objectId;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.aux;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer2.writeInt(fileChannelBackedWriteBuffer3.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        this.writeId(fileChannelBackedWriteBuffer4, (int)classObjectId);
        int classOffset = 0;
        ClassDefinition objectClass = this.classStore.get(classObjectId);
        CreateAuxiliaryFilesVisitor createAuxiliaryFilesVisitor = this;
        boolean bl7 = false;
        boolean bl8 = false;
        CreateAuxiliaryFilesVisitor $this$run = createAuxiliaryFilesVisitor;
        boolean bl9 = false;
        ClassDefinition classDef = objectClass;
        while (true) {
            InstanceField[] $this$forEach$iv = classDef.getRefInstanceFields();
            boolean $i$f$forEach = false;
            InstanceField[] instanceFieldArray = $this$forEach$iv;
            int n = instanceFieldArray.length;
            for (int j = 0; j < n; ++j) {
                InstanceField element$iv;
                InstanceField it = element$iv = instanceFieldArray[j];
                boolean bl10 = false;
                int offset = classOffset + it.getOffset();
                long value2 = bytes.getLong(offset);
                if (value2 == 0L) {
                    FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer5 = $this$run.aux;
                    if (fileChannelBackedWriteBuffer5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                    }
                    $this$run.writeId(fileChannelBackedWriteBuffer5, 0);
                    continue;
                }
                long reference2 = $this$run.parser.remap(value2);
                boolean bl11 = reference2 != 0L;
                boolean bl12 = false;
                boolean bl13 = false;
                if (_Assertions.ENABLED && !bl11) {
                    boolean bl14 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer6 = $this$run.aux;
                if (fileChannelBackedWriteBuffer6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                }
                $this$run.writeId(fileChannelBackedWriteBuffer6, (int)reference2);
            }
            classOffset += classDef.getSuperClassOffset();
            if (classDef.getSuperClassId() == 0L) break;
            classDef = $this$run.classStore.get(classDef.getSuperClassId());
        }
        if (Intrinsics.areEqual((Object)objectClass, (Object)this.directByteBufferClass)) {
            if (this.directByteBufferCapacityOffset == -1 || this.directByteBufferFdOffset == -1) {
                FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer7 = this.aux;
                if (fileChannelBackedWriteBuffer7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                }
                fileChannelBackedWriteBuffer7.writeNonNegativeLEB128Int(1);
            } else {
                int directByteBufferCapacity = bytes.getInt(this.directByteBufferCapacityOffset);
                long directByteBufferFd = bytes.getLong(this.directByteBufferFdOffset);
                if (directByteBufferFd == 0L) {
                    FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer8 = this.aux;
                    if (fileChannelBackedWriteBuffer8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                    }
                    fileChannelBackedWriteBuffer8.writeNonNegativeLEB128Int(directByteBufferCapacity);
                } else {
                    FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer9 = this.aux;
                    if (fileChannelBackedWriteBuffer9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                    }
                    fileChannelBackedWriteBuffer9.writeNonNegativeLEB128Int(1);
                }
            }
        }
    }

    private final void writeId(@NotNull FileChannelBackedWriteBuffer $this$writeId, int id2) {
        $this$writeId.writeNonNegativeLEB128Int(id2);
    }

    public CreateAuxiliaryFilesVisitor(@NotNull FileChannel auxOffsetsChannel, @NotNull FileChannel auxChannel, @NotNull ClassStore classStore, @NotNull HProfEventBasedParser parser) {
        Intrinsics.checkParameterIsNotNull((Object)auxOffsetsChannel, (String)"auxOffsetsChannel");
        Intrinsics.checkParameterIsNotNull((Object)auxChannel, (String)"auxChannel");
        Intrinsics.checkParameterIsNotNull((Object)classStore, (String)"classStore");
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        this.auxOffsetsChannel = auxOffsetsChannel;
        this.auxChannel = auxChannel;
        this.classStore = classStore;
        this.parser = parser;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(CreateAuxiliaryFilesVisitor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Creat\u2026FilesVisitor::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/CreateAuxiliaryFilesVisitor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

