/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.SplitButtonAction;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutorRegistryImpl
extends ExecutorRegistry {
    private static final Logger LOG = Logger.getInstance(ExecutorRegistryImpl.class);
    public static final String RUNNERS_GROUP = "RunnerActions";
    public static final String RUN_CONTEXT_GROUP = "RunContextGroupInner";
    private final Set<String> myContextActionIdSet = new THashSet();
    private final Map<String, AnAction> myIdToAction = new THashMap();
    private final Map<String, AnAction> myContextActionIdToAction = new THashMap();

    public ExecutorRegistryImpl() {
        Executor.EXECUTOR_EXTENSION_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<Executor>(){

            public void extensionAdded(@NotNull Executor extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExecutorRegistryImpl.this.initExecutorActions(extension, ActionManager.getInstance());
            }

            public void extensionRemoved(@NotNull Executor extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ExecutorRegistryImpl.this.deinitExecutor(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    public synchronized void initExecutorActions(@NotNull Executor executor, @NotNull ActionManager actionManager) {
        ActionGroup runContextAction;
        Object toolbarAction;
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(0);
        }
        if (actionManager == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(1);
        }
        if (this.myContextActionIdSet.contains(executor.getContextActionId())) {
            LOG.error("Executor with context action id: \"" + executor.getContextActionId() + "\" was already registered!");
        }
        if (executor instanceof ExecutorGroup) {
            ExecutorGroup executorGroup = (ExecutorGroup)executor;
            SplitButtonAction toolbarActionGroup = new SplitButtonAction(new ExecutorGroupActionGroup(executorGroup, x$0 -> new ExecutorAction((Executor)x$0)));
            Presentation presentation2 = toolbarActionGroup.getTemplatePresentation();
            presentation2.setIcon(executor.getIcon());
            presentation2.setText(executor.getStartActionText());
            presentation2.setDescription(executor.getDescription());
            toolbarAction = toolbarActionGroup;
            runContextAction = new ExecutorGroupActionGroup(executorGroup, RunContextAction::new);
        } else {
            toolbarAction = new ExecutorAction(executor);
            runContextAction = new RunContextAction(executor);
        }
        Executor.ActionWrapper customizer = executor.runnerActionsGroupExecutorActionCustomizer();
        ExecutorRegistryImpl.registerAction(actionManager, executor.getId(), customizer == null ? toolbarAction : customizer.wrap((AnAction)toolbarAction), RUNNERS_GROUP, this.myIdToAction);
        ExecutorRegistryImpl.registerAction(actionManager, executor.getContextActionId(), (AnAction)runContextAction, RUN_CONTEXT_GROUP, this.myContextActionIdToAction);
        this.myContextActionIdSet.add(executor.getContextActionId());
    }

    private static void registerAction(@NotNull ActionManager actionManager, @NotNull String actionId, @NotNull AnAction anAction, @NotNull String groupId2, @NotNull Map<String, AnAction> map2) {
        AnAction action2;
        if (actionManager == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(2);
        }
        if (actionId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(3);
        }
        if (anAction == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(4);
        }
        if (groupId2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(5);
        }
        if (map2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(6);
        }
        if ((action2 = actionManager.getAction(actionId)) == null) {
            actionManager.registerAction(actionId, anAction);
            map2.put(actionId, anAction);
            action2 = anAction;
        }
        ((DefaultActionGroup)actionManager.getAction(groupId2)).add(action2, actionManager);
    }

    synchronized void deinitExecutor(@NotNull Executor executor) {
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(7);
        }
        this.myContextActionIdSet.remove(executor.getContextActionId());
        ExecutorRegistryImpl.unregisterAction(executor.getId(), RUNNERS_GROUP, this.myIdToAction);
        ExecutorRegistryImpl.unregisterAction(executor.getContextActionId(), RUN_CONTEXT_GROUP, this.myContextActionIdToAction);
    }

    private static void unregisterAction(@NotNull String actionId, @NotNull String groupId2, @NotNull Map<String, AnAction> map2) {
        ActionManager actionManager;
        DefaultActionGroup group;
        if (actionId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(8);
        }
        if (groupId2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(9);
        }
        if (map2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(10);
        }
        if ((group = (DefaultActionGroup)(actionManager = ActionManager.getInstance()).getAction(groupId2)) == null) {
            return;
        }
        group.remove(actionManager.getAction(actionId), actionManager);
        AnAction action2 = map2.get(actionId);
        if (action2 != null) {
            actionManager.unregisterAction(actionId);
            map2.remove(actionId);
        }
    }

    public Executor getExecutorById(@NotNull String executorId) {
        if (executorId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(11);
        }
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            if (!executorId.equals(executor.getId())) continue;
            return executor;
        }
        return null;
    }

    private void init(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(12);
        }
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            try {
                this.initExecutorActions(executor, actionManager);
            }
            catch (Throwable t) {
                LOG.error("executor initialization failed: " + executor.getClass().getName(), t);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initExecutorActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "deinitExecutor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getExecutorById";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ExecutorGroupActionGroup
    extends ActionGroup
    implements DumbAware {
        private final ExecutorGroup<?> myExecutorGroup;
        private final Function<? super Executor, ? extends AnAction> myChildConverter;

        private ExecutorGroupActionGroup(@NotNull ExecutorGroup<?> executorGroup, @NotNull Function<? super Executor, ? extends AnAction> childConverter) {
            if (executorGroup == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(0);
            }
            if (childConverter == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(1);
            }
            this.myExecutorGroup = executorGroup;
            this.myChildConverter = childConverter;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            List childExecutors = this.myExecutorGroup.childExecutors();
            AnAction[] result2 = new AnAction[childExecutors.size()];
            for (int i2 = 0; i2 < childExecutors.size(); ++i2) {
                result2[i2] = this.myChildConverter.apply((Executor)childExecutors.get(i2));
            }
            if (result2 == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(2);
            }
            return result2;
        }

        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(3);
            }
            if ((project = e.getProject()) == null || !project.isInitialized() || project.isDisposed()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(this.myExecutorGroup.isApplicable(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executorGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childConverter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorGroupActionGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorGroupActionGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ExecutorAction
    extends AnAction
    implements DumbAware,
    UpdateInBackground {
        private final Executor myExecutor;

        private ExecutorAction(@NotNull Executor executor) {
            if (executor == null) {
                ExecutorAction.$$$reportNull$$$0(0);
            }
            super(executor.getStartActionText(), executor.getDescription(), IconLoader.createLazy(() -> executor.getIcon()));
            this.myExecutor = executor;
        }

        private boolean canRun(@NotNull Project project, @NotNull List<SettingsAndEffectiveTarget> pairs) {
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(1);
            }
            if (pairs == null) {
                ExecutorAction.$$$reportNull$$$0(2);
            }
            if (pairs.isEmpty()) {
                return false;
            }
            for (SettingsAndEffectiveTarget pair : pairs) {
                ProgramRunner runner;
                RunConfiguration configuration = pair.getConfiguration();
                if (!(configuration instanceof CompoundRunConfiguration ? !this.canRun(project, ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets()) : (runner = ProgramRunner.getRunner((String)this.myExecutor.getId(), (RunProfile)configuration)) == null || !ExecutionTargetManager.canRun((RunConfiguration)configuration, (ExecutionTarget)pair.getTarget()) || ExecutionManager.getInstance((Project)project).isStarting(this.myExecutor.getId(), runner.getRunnerId()))) continue;
                return false;
            }
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            String text;
            if (e == null) {
                ExecutorAction.$$$reportNull$$$0(3);
            }
            Presentation presentation2 = e.getPresentation();
            Project project = e.getProject();
            if (project == null || !project.isInitialized() || project.isDisposed()) {
                presentation2.setEnabled(false);
                return;
            }
            RunnerAndConfigurationSettings selectedSettings = ExecutorAction.getSelectedConfiguration(project);
            boolean enabled = false;
            boolean hideDisabledExecutorButtons = false;
            if (selectedSettings != null) {
                if (DumbService.isDumb((Project)project) && !selectedSettings.getType().isDumbAware()) {
                    presentation2.setEnabled(false);
                    return;
                }
                presentation2.setIcon(this.getInformativeIcon(project, selectedSettings));
                RunConfiguration configuration = selectedSettings.getConfiguration();
                if (configuration instanceof CompoundRunConfiguration) {
                    enabled = this.canRun(project, ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets());
                } else {
                    ExecutionTarget target2 = ExecutionTargetManager.getActiveTarget((Project)project);
                    enabled = this.canRun(project, Collections.singletonList(new SettingsAndEffectiveTarget(configuration, target2)));
                    hideDisabledExecutorButtons = configuration.hideDisabledExecutorButtons();
                }
                if (enabled) {
                    presentation2.setDescription(this.myExecutor.getDescription());
                }
                text = this.myExecutor.getStartActionText(configuration.getName());
            } else {
                text = this.getTemplatePresentation().getTextWithMnemonic();
            }
            if (hideDisabledExecutorButtons) {
                presentation2.setEnabledAndVisible(enabled);
            } else {
                presentation2.setEnabled(enabled);
            }
            if (presentation2.isVisible()) {
                presentation2.setVisible(this.myExecutor.isApplicable(project));
            }
            presentation2.setText(text);
        }

        private Icon getInformativeIcon(@NotNull Project project, @NotNull RunnerAndConfigurationSettings selectedConfiguration2) {
            RunnerIconProvider provider;
            Icon icon2;
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(4);
            }
            if (selectedConfiguration2 == null) {
                ExecutorAction.$$$reportNull$$$0(5);
            }
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project);
            RunConfiguration configuration = selectedConfiguration2.getConfiguration();
            if (configuration instanceof RunnerIconProvider && (icon2 = (provider = (RunnerIconProvider)configuration).getExecutorIcon(configuration, this.myExecutor)) != null) {
                return icon2;
            }
            List runningDescriptors2 = executionManager.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)s -> s != null && s.getConfiguration() == selectedConfiguration2.getConfiguration()));
            runningDescriptors2 = ContainerUtil.filter(runningDescriptors2, descriptor2 -> {
                RunContentDescriptor contentDescriptor = RunContentManager.getInstance((Project)project).findContentDescriptor(this.myExecutor, descriptor2.getProcessHandler());
                return contentDescriptor != null && executionManager.getExecutors(contentDescriptor).contains(this.myExecutor);
            });
            if (!configuration.isAllowRunningInParallel() && !runningDescriptors2.isEmpty() && "Run".equals(this.myExecutor.getId())) {
                return AllIcons.Actions.Restart;
            }
            if (runningDescriptors2.isEmpty()) {
                return this.myExecutor.getIcon();
            }
            if (runningDescriptors2.size() == 1) {
                return ExecutionUtil.getLiveIndicator((Icon)this.myExecutor.getIcon());
            }
            return IconUtil.addText((Icon)this.myExecutor.getIcon(), (String)Integer.toString(runningDescriptors2.size()));
        }

        @Nullable
        private static RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull Project project) {
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(6);
            }
            return RunManager.getInstance((Project)project).getSelectedConfiguration();
        }

        private void run(@NotNull Project project, @Nullable RunConfiguration configuration, @Nullable RunnerAndConfigurationSettings settings, @NotNull DataContext dataContext) {
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(7);
            }
            if (dataContext == null) {
                ExecutorAction.$$$reportNull$$$0(8);
            }
            if (configuration instanceof CompoundRunConfiguration) {
                RunManager runManager = RunManager.getInstance((Project)project);
                for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets()) {
                    RunConfiguration subConfiguration = settingsAndEffectiveTarget.getConfiguration();
                    this.run(project, subConfiguration, runManager.findSettings(subConfiguration), dataContext);
                }
            } else {
                ExecutionEnvironmentBuilder builder2;
                ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder2 = settings == null ? null : ExecutionEnvironmentBuilder.createOrNull((Executor)this.myExecutor, (RunnerAndConfigurationSettings)settings);
                if (builder2 == null) {
                    return;
                }
                ExecutionManager.getInstance((Project)project).restartRunProfile(builder2.activeTarget().dataContext(dataContext).build());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ExecutorAction.$$$reportNull$$$0(9);
            }
            if ((project = e.getProject()) == null || project.isDisposed()) {
                return;
            }
            MacroManager.getInstance().cacheMacrosPreview(e.getDataContext());
            RunnerAndConfigurationSettings selectedConfiguration2 = ExecutorAction.getSelectedConfiguration(project);
            if (selectedConfiguration2 != null) {
                this.run(project, selectedConfiguration2.getConfiguration(), selectedConfiguration2, e.getDataContext());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedConfiguration";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInformativeIcon";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedConfiguration";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ExecutorRegistryActionConfigurationTuner
    implements ActionConfigurationCustomizer {
        ExecutorRegistryActionConfigurationTuner() {
        }

        @Override
        public void customize(@NotNull ActionManager manager) {
            if (manager == null) {
                ExecutorRegistryActionConfigurationTuner.$$$reportNull$$$0(0);
            }
            if (Executor.EXECUTOR_EXTENSION_NAME.hasAnyExtensions()) {
                ((ExecutorRegistryImpl)ExecutorRegistry.getInstance()).init(manager);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/execution/ExecutorRegistryImpl$ExecutorRegistryActionConfigurationTuner", "customize"));
        }
    }
}

