/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.DynamicBundle;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunOnTargetComboBox;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationVcsSupport;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.BaseRCSettingsConfigurable;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.RunConfigurationStorageUi;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.ValidationResult;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentsConfigurable;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class SingleConfigurationConfigurable<Config extends RunConfiguration>
extends BaseRCSettingsConfigurable {
    private static final LayeredIcon GEAR_WITH_DROPDOWN_ICON = new LayeredIcon(new Icon[]{AllIcons.General.GearPlain, AllIcons.General.Dropdown});
    private static final LayeredIcon GEAR_WITH_DROPDOWN_DISABLED_ICON = new LayeredIcon(new Icon[]{IconLoader.getDisabledIcon((Icon)AllIcons.General.GearPlain), IconLoader.getDisabledIcon((Icon)AllIcons.General.Dropdown)});
    private static final LayeredIcon GEAR_WITH_DROPDOWN_ERROR_ICON = new LayeredIcon(new Icon[]{AllIcons.General.Error, AllIcons.General.Dropdown});
    public static final DataKey<String> RUN_ON_TARGET_NAME_KEY = DataKey.create((String)"RunOnTargetName");
    private static final Logger LOG = Logger.getInstance(SingleConfigurationConfigurable.class);
    private final PlainDocument myNameDocument;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Executor myExecutor;
    private ValidationResult myLastValidationResult;
    private boolean myValidationResultValid;
    private MyValidatableComponent myComponent;
    private final String myDisplayName;
    private final String myHelpTopic;
    private final boolean myBrokenConfiguration;
    private RCStorageType myRCStorageType;
    @Nullable
    @NonNls
    private @SystemIndependent String myFolderPathIfStoredInArbitraryFile;
    private boolean myIsAllowRunningInParallel;
    private String myDefaultTargetName;
    private String myFolderName;
    private boolean myChangingNameFromCode;
    @Nullable
    Boolean myDotIdeaStorageVcsIgnored;

    private SingleConfigurationConfigurable(@NotNull RunnerAndConfigurationSettings settings, @Nullable Executor executor) {
        if (settings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(0);
        }
        super(ConfigurationSettingsEditorWrapper.createWrapper(settings), settings);
        this.myNameDocument = new PlainDocument();
        this.myLastValidationResult = null;
        this.myValidationResultValid = false;
        this.myIsAllowRunningInParallel = false;
        this.myDotIdeaStorageVcsIgnored = null;
        this.myProject = settings.getConfiguration().getProject();
        this.myExecutor = executor;
        Config configuration = this.getConfiguration();
        this.myDisplayName = ((RunnerAndConfigurationSettings)this.getSettings()).getName();
        this.myHelpTopic = configuration.getType().getHelpTopic();
        this.myBrokenConfiguration = !configuration.getType().isManaged();
        this.setFolderName(((RunnerAndConfigurationSettings)this.getSettings()).getFolderName());
        this.setNameText(configuration.getName());
        this.myNameDocument.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                RunConfiguration runConfiguration;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SingleConfigurationConfigurable.this.setModified(true);
                if (!SingleConfigurationConfigurable.this.myChangingNameFromCode && (runConfiguration = ((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).getConfiguration()) instanceof LocatableConfigurationBase) {
                    ((LocatableConfigurationBase)runConfiguration).setNameChangedByUser(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/SingleConfigurationConfigurable$1", "textChanged"));
            }
        });
        this.getEditor().addSettingsEditorListener((SettingsEditorListener)new SettingsEditorListener<RunnerAndConfigurationSettings>(){

            public void stateChanged(@NotNull SettingsEditor<RunnerAndConfigurationSettings> settingsEditor) {
                if (settingsEditor == null) {
                    2.$$$reportNull$$$0(0);
                }
                SingleConfigurationConfigurable.this.myValidationResultValid = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsEditor", "com/intellij/execution/impl/SingleConfigurationConfigurable$2", "stateChanged"));
            }
        });
    }

    @NotNull
    public static <Config extends RunConfiguration> SingleConfigurationConfigurable<Config> editSettings(@NotNull RunnerAndConfigurationSettings settings, @Nullable Executor executor) {
        if (settings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(1);
        }
        SingleConfigurationConfigurable<Config> configurable2 = new SingleConfigurationConfigurable<Config>(settings, executor);
        configurable2.reset();
        SingleConfigurationConfigurable<Config> singleConfigurationConfigurable = configurable2;
        if (singleConfigurationConfigurable == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(2);
        }
        return singleConfigurationConfigurable;
    }

    @Override
    boolean isSpecificallyModified() {
        return this.isStorageModified();
    }

    private boolean isStorageModified() {
        RunnerAndConfigurationSettings original = (RunnerAndConfigurationSettings)this.getSettings();
        switch (this.myRCStorageType) {
            case Workspace: {
                return !original.isStoredInLocalWorkspace();
            }
            case DotIdeaFolder: {
                return !original.isStoredInDotIdeaFolder();
            }
            case ArbitraryFileInProject: {
                return !original.isStoredInArbitraryFileInProject() || !PathUtil.getParentPath((String)StringUtil.notNullize((String)original.getPathIfStoredInArbitraryFileInProject())).equals(this.myFolderPathIfStoredInArbitraryFile);
            }
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)this.getSettings();
        RunConfiguration runConfiguration = settings.getConfiguration();
        settings.setName(this.getNameText());
        runConfiguration.setAllowRunningInParallel(this.myIsAllowRunningInParallel);
        if (runConfiguration instanceof TargetEnvironmentAwareRunProfile) {
            ((TargetEnvironmentAwareRunProfile)runConfiguration).setDefaultTargetName(this.myDefaultTargetName);
        }
        settings.setFolderName(this.myFolderName);
        if (this.isStorageModified()) {
            switch (this.myRCStorageType) {
                case Workspace: {
                    settings.storeInLocalWorkspace();
                    break;
                }
                case DotIdeaFolder: {
                    settings.storeInDotIdeaFolder();
                    break;
                }
                case ArbitraryFileInProject: {
                    if (SingleConfigurationConfigurable.getErrorIfBadFolderPathForStoringInArbitraryFile(this.myProject, this.myFolderPathIfStoredInArbitraryFile) != null) break;
                    String fileName = SingleConfigurationConfigurable.getFileNameByRCName(settings.getName());
                    settings.storeInArbitraryFileInProject(this.myFolderPathIfStoredInArbitraryFile + "/" + fileName);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.myRCStorageType));
                }
            }
        }
        super.apply();
        RunManagerImpl.getInstanceImpl(this.myProject).addConfiguration(settings);
    }

    public void reset() {
        RunnerAndConfigurationSettings configuration = (RunnerAndConfigurationSettings)this.getSettings();
        if (configuration instanceof RunnerAndConfigurationSettingsImpl) {
            configuration = ((RunnerAndConfigurationSettingsImpl)configuration).clone();
        }
        this.setNameText(configuration.getName());
        super.reset();
        if (this.myComponent == null) {
            this.myComponent = new MyValidatableComponent();
        }
        this.myComponent.doReset(configuration);
    }

    @NonNls
    @NotNull
    private static String getFileNameByRCName(@NotNull String rcName) {
        if (rcName == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(3);
        }
        String string = (String)Scheme_implKt.getMODERN_NAME_CONVERTER().invoke((Object)rcName) + ".run.xml";
        if (string == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    @Contract(value="_,null -> !null")
    private static String getErrorIfBadFolderPathForStoringInArbitraryFile(@NotNull Project project, @Nullable @NonNls @SystemIndependent String path) {
        if (project == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(5);
        }
        if (SingleConfigurationConfigurable.getDotIdeaStoragePath(project).equals(path)) {
            return null;
        }
        if (StringUtil.isEmpty((String)path)) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.path.not.specified", (Object[])new Object[0]);
        }
        if (path.endsWith("/.idea") || path.contains("/.idea/")) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.dot.idea.forbidden", (Object[])new Object[]{File.separator});
        }
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
        if (file2 != null && !file2.isDirectory()) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.path.expected", (Object[])new Object[0]);
        }
        String folderName = PathUtil.getFileName((String)path);
        String parentPath = PathUtil.getParentPath((String)path);
        while (file2 == null && !parentPath.isEmpty()) {
            if (!PathUtil.isValidFileName((String)folderName)) {
                return ExecutionBundle.message((String)"run.configuration.storage.folder.path.expected", (Object[])new Object[0]);
            }
            file2 = LocalFileSystem.getInstance().findFileByPath(parentPath);
            folderName = PathUtil.getFileName((String)parentPath);
            parentPath = PathUtil.getParentPath((String)parentPath);
        }
        if (file2 == null) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.not.within.project", (Object[])new Object[0]);
        }
        if (!file2.isDirectory()) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.path.expected", (Object[])new Object[0]);
        }
        if (ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file2, true) == null) {
            if (ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file2, false) == null) {
                return ExecutionBundle.message((String)"run.configuration.storage.folder.not.within.project", (Object[])new Object[0]);
            }
            return ExecutionBundle.message((String)"run.configuration.storage.folder.in.excluded.root", (Object[])new Object[0]);
        }
        return null;
    }

    void updateWarning() {
        this.myValidationResultValid = false;
        if (this.myComponent != null) {
            this.myComponent.updateWarning();
        }
    }

    @Override
    public final JComponent createComponent() {
        this.myComponent.myNameText.setEnabled(!this.myBrokenConfiguration);
        JComponent result2 = this.myComponent.getWholePanel();
        DataManager.registerDataProvider((JComponent)result2, dataId -> {
            RunOnTargetComboBox runOnComboBox;
            if (ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.is(dataId)) {
                return this.getEditor();
            }
            if (RUN_ON_TARGET_NAME_KEY.is(dataId) && (runOnComboBox = (RunOnTargetComboBox)this.myComponent.myRunOnComboBox) != null) {
                return runOnComboBox.getSelectedTargetName();
            }
            return null;
        });
        return result2;
    }

    final JComponent getValidationComponent() {
        return this.myComponent.myValidationPanel;
    }

    public boolean isStoredInFile() {
        return this.myRCStorageType == RCStorageType.DotIdeaFolder || this.myRCStorageType == RCStorageType.ArbitraryFileInProject;
    }

    @Nullable
    private ValidationResult getValidationResult() {
        if (!this.myValidationResultValid) {
            this.myLastValidationResult = null;
            RunnerAndConfigurationSettings snapshot = null;
            try {
                snapshot = this.createSnapshot(false);
                snapshot.setName(this.getNameText());
                snapshot.checkSettings(this.myExecutor);
                for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                    ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)snapshot.getConfiguration());
                    if (runner == null) continue;
                    SingleConfigurationConfigurable.checkConfiguration(runner, snapshot);
                }
            }
            catch (ConfigurationException e) {
                this.myLastValidationResult = this.createValidationResult(snapshot, e);
            }
            this.myValidationResultValid = true;
        }
        return this.myLastValidationResult;
    }

    private ValidationResult createValidationResult(RunnerAndConfigurationSettings snapshot, ConfigurationException e) {
        if (!e.shouldShowInDumbMode() && DumbService.isDumb((Project)this.myProject)) {
            return null;
        }
        return new ValidationResult(e.getLocalizedMessage(), e instanceof RuntimeConfigurationException ? e.getTitle() : ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), this.getQuickFix(snapshot, e));
    }

    @Nullable
    private Runnable getQuickFix(RunnerAndConfigurationSettings snapshot, ConfigurationException exception) {
        Runnable quickFix = exception.getQuickFix();
        if (quickFix != null && snapshot != null) {
            return () -> {
                quickFix.run();
                this.getEditor().resetFrom((Object)snapshot);
            };
        }
        return quickFix;
    }

    private static void checkConfiguration(@NotNull ProgramRunner<?> runner, @NotNull RunnerAndConfigurationSettings snapshot) throws RuntimeConfigurationException {
        if (runner == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(6);
        }
        if (snapshot == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(7);
        }
        RunnerSettings runnerSettings2 = snapshot.getRunnerSettings(runner);
        ConfigurationPerRunnerSettings configurationSettings = snapshot.getConfigurationSettings(runner);
        try {
            runner.checkConfiguration(runnerSettings2, configurationSettings);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public final void disposeUIResources() {
        super.disposeUIResources();
        this.myComponent = null;
    }

    public final String getNameText() {
        try {
            return this.myNameDocument.getText(0, this.myNameDocument.getLength());
        }
        catch (BadLocationException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    public final void addNameListener(DocumentListener listener2) {
        this.myNameDocument.addDocumentListener(listener2);
    }

    public final void addSharedListener(ActionListener listener2) {
        this.myComponent.myStoreAsFileCheckBox.addActionListener(listener2);
    }

    public final void setNameText(String name) {
        this.myChangingNameFromCode = true;
        try {
            try {
                if (!this.myNameDocument.getText(0, this.myNameDocument.getLength()).equals(name)) {
                    this.myNameDocument.replace(0, this.myNameDocument.getLength(), name, null);
                }
            }
            catch (BadLocationException e) {
                LOG.error((Throwable)e);
            }
        }
        finally {
            this.myChangingNameFromCode = false;
        }
    }

    public final boolean isValid() {
        return this.getValidationResult() == null;
    }

    public final JTextField getNameTextField() {
        return this.myComponent.myNameText;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpTopic() {
        return this.myHelpTopic;
    }

    @NotNull
    public Config getConfiguration() {
        RunConfiguration runConfiguration = ((RunnerAndConfigurationSettings)this.getSettings()).getConfiguration();
        if (runConfiguration == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(8);
        }
        return (Config)runConfiguration;
    }

    @NotNull
    public RunnerAndConfigurationSettings createSnapshot(boolean cloneBeforeRunTasks) throws ConfigurationException {
        RunnerAndConfigurationSettings snapshot = (RunnerAndConfigurationSettings)this.getEditor().getSnapshot();
        RunConfiguration runConfiguration = snapshot.getConfiguration();
        runConfiguration.setAllowRunningInParallel(this.myIsAllowRunningInParallel);
        if (runConfiguration instanceof TargetEnvironmentAwareRunProfile) {
            ((TargetEnvironmentAwareRunProfile)runConfiguration).setDefaultTargetName(this.myDefaultTargetName);
        }
        if (cloneBeforeRunTasks) {
            RunManagerImplKt.cloneBeforeRunTasks(runConfiguration);
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = snapshot;
        if (runnerAndConfigurationSettings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(9);
        }
        return runnerAndConfigurationSettings;
    }

    public String toString() {
        return this.myDisplayName;
    }

    public void setFolderName(@Nullable String folderName) {
        if (!Objects.equals(this.myFolderName, folderName)) {
            this.myFolderName = folderName;
            this.setModified(true);
        }
    }

    @Nullable
    public String getFolderName() {
        return this.myFolderName;
    }

    @NonNls
    @NotNull
    private static String getDotIdeaStoragePath(@NotNull Project project) {
        if (project == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(10);
        }
        String string = ProjectKt.isDirectoryBased(project) ? RunManagerImpl.getInstanceImpl(project).getDotIdeaRunConfigurationsPath$intellij_platform_execution_impl() : StringUtil.notNullize((String)project.getProjectFilePath());
        if (string == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(11);
        }
        return string;
    }

    private void setStorageTypeAndPathToTheBestPossibleState() {
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)this.getSettings();
        if (settings.isStoredInDotIdeaFolder()) {
            this.myRCStorageType = RCStorageType.DotIdeaFolder;
            this.myFolderPathIfStoredInArbitraryFile = null;
            return;
        }
        if (settings.isStoredInArbitraryFileInProject()) {
            this.myRCStorageType = RCStorageType.ArbitraryFileInProject;
            this.myFolderPathIfStoredInArbitraryFile = PathUtil.getParentPath((String)StringUtil.notNullize((String)settings.getPathIfStoredInArbitraryFileInProject()));
            return;
        }
        if (!ProjectKt.isDirectoryBased(this.myProject)) {
            this.myRCStorageType = RCStorageType.DotIdeaFolder;
            this.myFolderPathIfStoredInArbitraryFile = null;
            return;
        }
        RunConfigurationVcsSupport vcsSupport = (RunConfigurationVcsSupport)this.myProject.getService(RunConfigurationVcsSupport.class);
        if (!vcsSupport.hasActiveVcss(this.myProject)) {
            this.myRCStorageType = RCStorageType.DotIdeaFolder;
            this.myFolderPathIfStoredInArbitraryFile = null;
            return;
        }
        if (!this.isDotIdeaStorageVcsIgnored(vcsSupport)) {
            this.myRCStorageType = RCStorageType.DotIdeaFolder;
            this.myFolderPathIfStoredInArbitraryFile = null;
            return;
        }
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByPath(StringUtil.notNullize((String)this.myProject.getBasePath()));
        LOG.assertTrue(baseDir != null);
        if (!ProjectFileIndex.getInstance((Project)this.myProject).isInContent(baseDir)) {
            this.myRCStorageType = RCStorageType.DotIdeaFolder;
            this.myFolderPathIfStoredInArbitraryFile = null;
            return;
        }
        Collection<String> otherFolders = SingleConfigurationConfigurable.getFolderPathsWithinProjectWhereRunConfigurationsStored(this.myProject);
        if (otherFolders.size() == 1) {
            this.myRCStorageType = RCStorageType.ArbitraryFileInProject;
            this.myFolderPathIfStoredInArbitraryFile = otherFolders.iterator().next();
            return;
        }
        this.myRCStorageType = RCStorageType.ArbitraryFileInProject;
        this.myFolderPathIfStoredInArbitraryFile = baseDir.getPath() + "/.run";
    }

    private boolean isDotIdeaStorageVcsIgnored(RunConfigurationVcsSupport vcsSupport) {
        if (this.myDotIdeaStorageVcsIgnored == null) {
            this.myDotIdeaStorageVcsIgnored = vcsSupport.isDirectoryVcsIgnored(this.myProject, SingleConfigurationConfigurable.getDotIdeaStoragePath(this.myProject));
        }
        return this.myDotIdeaStorageVcsIgnored;
    }

    private static Collection<String> getFolderPathsWithinProjectWhereRunConfigurationsStored(@NotNull Project project) {
        if (project == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(12);
        }
        THashSet result2 = new THashSet();
        for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getAllSettings()) {
            String filePath = settings.getPathIfStoredInArbitraryFileInProject();
            if (!settings.isStoredInArbitraryFileInProject() || filePath == null) continue;
            result2.add(PathUtil.getParentPath((String)filePath));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/SingleConfigurationConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rcName";
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/SingleConfigurationConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "editSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameByRCName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSnapshot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDotIdeaStoragePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "editSettings";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileNameByRCName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorIfBadFolderPathForStoringInArbitraryFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDotIdeaStoragePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFolderPathsWithinProjectWhereRunConfigurationsStored";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyValidatableComponent {
        private JLabel myNameLabel;
        private JTextField myNameText;
        private JComponent myWholePanel;
        private JPanel myComponentPlace;
        private JBLabel myWarningLabel;
        private JButton myFixButton;
        private JSeparator mySeparator;
        private JBCheckBox myIsAllowRunningInParallelCheckBox;
        private JBCheckBox myStoreAsFileCheckBox;
        private ActionButton myStoreAsFileGearButton;
        private JPanel myValidationPanel;
        private JBScrollPane myJBScrollPane;
        private ComboBox myRunOnComboBox;
        private JLabel myManageTargetsLabel;
        private JPanel myRunOnPanel;
        private JPanel myRunOnPanelInner;
        private Runnable myQuickFix = null;
        private boolean myWindowResizedOnce = false;

        MyValidatableComponent() {
            this.$$$setupUI$$$();
            this.myNameLabel.setLabelFor(this.myNameText);
            this.myNameText.setDocument(SingleConfigurationConfigurable.this.myNameDocument);
            SingleConfigurationConfigurable.this.getEditor().addSettingsEditorListener(settingsEditor -> this.updateWarning());
            this.myWarningLabel.setCopyable(true);
            this.myWarningLabel.setAllowAutoWrapping(true);
            this.myWarningLabel.setIcon(AllIcons.General.BalloonError);
            this.myComponentPlace.setLayout(new GridBagLayout());
            this.myComponentPlace.add((Component)this.getEditorComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
            this.myComponentPlace.doLayout();
            this.myFixButton.setIcon(AllIcons.Actions.QuickfixBulb);
            this.updateWarning();
            this.myFixButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyValidatableComponent.this.myQuickFix == null) {
                        return;
                    }
                    MyValidatableComponent.this.myQuickFix.run();
                    SingleConfigurationConfigurable.this.myValidationResultValid = false;
                    MyValidatableComponent.this.updateWarning();
                }
            });
            this.myIsAllowRunningInParallelCheckBox.addActionListener(e -> {
                SingleConfigurationConfigurable.this.setModified(true);
                SingleConfigurationConfigurable.this.myIsAllowRunningInParallel = this.myIsAllowRunningInParallelCheckBox.isSelected();
            });
            this.myStoreAsFileCheckBox.addActionListener(e -> {
                if (this.myStoreAsFileCheckBox.isSelected()) {
                    SingleConfigurationConfigurable.this.setStorageTypeAndPathToTheBestPossibleState();
                } else {
                    SingleConfigurationConfigurable.this.myRCStorageType = RCStorageType.Workspace;
                    SingleConfigurationConfigurable.this.myFolderPathIfStoredInArbitraryFile = null;
                }
                SingleConfigurationConfigurable.this.setModified(true);
                this.myStoreAsFileGearButton.setEnabled(this.myStoreAsFileCheckBox.isSelected());
                if (this.myStoreAsFileCheckBox.isSelected()) {
                    this.manageStorageFileLocation();
                }
            });
            this.myRunOnPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            UI.PanelFactory.panel((JComponent)this.myRunOnPanelInner).withLabel(ExecutionBundle.message((String)"run.on", (Object[])new Object[0])).withComment(ExecutionBundle.message((String)"edit.run.configuration.run.configuration.run.on.comment", (Object[])new Object[0])).addToPanel(this.myRunOnPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0), false);
            JLabel runOnLabel = (JLabel)UIUtil.findComponentOfType((JComponent)this.myRunOnPanel, JLabel.class);
            if (runOnLabel != null) {
                runOnLabel.setLabelFor((Component)this.myRunOnComboBox);
                Dimension nameSize = this.myNameLabel.getPreferredSize();
                Dimension runOnSize = runOnLabel.getPreferredSize();
                double width = Math.max(nameSize.getWidth(), runOnSize.getWidth());
                this.myNameLabel.setPreferredSize(new Dimension((int)width, (int)nameSize.getHeight()));
                runOnLabel.setPreferredSize(new Dimension((int)width, (int)runOnSize.getHeight()));
            }
            this.myRunOnComboBox.addActionListener(e -> {
                String chosenTarget = ((RunOnTargetComboBox)this.myRunOnComboBox).getSelectedTargetName();
                if (!StringUtil.equals((CharSequence)SingleConfigurationConfigurable.this.myDefaultTargetName, (CharSequence)chosenTarget)) {
                    SingleConfigurationConfigurable.this.setModified(true);
                    SingleConfigurationConfigurable.this.myDefaultTargetName = chosenTarget;
                }
            });
        }

        private void doReset(RunnerAndConfigurationSettings settings) {
            RunConfiguration configuration = settings.getConfiguration();
            boolean isManagedRunConfiguration = configuration.getType().isManaged();
            SingleConfigurationConfigurable.this.myRCStorageType = settings.isStoredInArbitraryFileInProject() ? RCStorageType.ArbitraryFileInProject : (settings.isStoredInDotIdeaFolder() ? RCStorageType.DotIdeaFolder : RCStorageType.Workspace);
            SingleConfigurationConfigurable.this.myFolderPathIfStoredInArbitraryFile = PathUtil.getParentPath((String)StringUtil.notNullize((String)settings.getPathIfStoredInArbitraryFileInProject()));
            this.myStoreAsFileCheckBox.setVisible(!settings.isTemplate());
            this.myStoreAsFileCheckBox.setEnabled(isManagedRunConfiguration);
            this.myStoreAsFileCheckBox.setSelected(SingleConfigurationConfigurable.this.myRCStorageType == RCStorageType.DotIdeaFolder || SingleConfigurationConfigurable.this.myRCStorageType == RCStorageType.ArbitraryFileInProject);
            this.myStoreAsFileGearButton.setVisible(!settings.isTemplate() && isManagedRunConfiguration);
            this.myStoreAsFileGearButton.setEnabled(this.myStoreAsFileCheckBox.isSelected());
            boolean targetAware = configuration instanceof TargetEnvironmentAwareRunProfile && Experiments.getInstance().isFeatureEnabled("run.targets");
            this.myRunOnPanel.setVisible(targetAware);
            if (targetAware) {
                String defaultTargetName = ((TargetEnvironmentAwareRunProfile)configuration).getDefaultTargetName();
                LanguageRuntimeType defaultRuntime = ((TargetEnvironmentAwareRunProfile)configuration).getDefaultLanguageRuntimeType();
                ((RunOnTargetComboBox)this.myRunOnComboBox).setDefaultLanguageRuntimeTime(defaultRuntime);
                this.resetRunOnComboBox(defaultTargetName);
                SingleConfigurationConfigurable.this.myDefaultTargetName = defaultTargetName;
            }
            SingleConfigurationConfigurable.this.myIsAllowRunningInParallel = configuration.isAllowRunningInParallel();
            this.myIsAllowRunningInParallelCheckBox.setEnabled(isManagedRunConfiguration);
            this.myIsAllowRunningInParallelCheckBox.setSelected(SingleConfigurationConfigurable.this.myIsAllowRunningInParallel);
            this.myIsAllowRunningInParallelCheckBox.setVisible(SingleConfigurationConfigurable.this.getEditor() instanceof ConfigurationSettingsEditorWrapper && settings.getFactory().getSingletonPolicy().isPolicyConfigurable());
        }

        private void resetRunOnComboBox(@Nullable String targetNameToChoose) {
            ((RunOnTargetComboBox)this.myRunOnComboBox).initModel();
            ((RunOnTargetComboBox)this.myRunOnComboBox).addTargets(TargetEnvironmentsManager.getInstance().getTargets().resolvedConfigs());
            ((RunOnTargetComboBox)this.myRunOnComboBox).selectTarget(targetNameToChoose);
        }

        public final JComponent getWholePanel() {
            return this.myWholePanel;
        }

        public JComponent getEditorComponent() {
            return SingleConfigurationConfigurable.this.getEditor().getComponent();
        }

        @Nullable
        public ValidationResult getValidationResult() {
            return SingleConfigurationConfigurable.this.getValidationResult();
        }

        private void updateWarning() {
            ValidationResult configurationException = this.getValidationResult();
            if (configurationException != null) {
                this.mySeparator.setVisible(true);
                this.myWarningLabel.setVisible(true);
                this.myWarningLabel.setText(this.generateWarningLabelText(configurationException));
                Runnable quickFix = configurationException.getQuickFix();
                if (quickFix == null) {
                    this.myFixButton.setVisible(false);
                } else {
                    this.myFixButton.setVisible(true);
                    this.myQuickFix = quickFix;
                }
                this.myValidationPanel.setVisible(true);
                Window window = UIUtil.getWindow((Component)this.myWholePanel);
                if (!this.myWindowResizedOnce && window != null && window.isShowing()) {
                    Dimension size = window.getSize();
                    window.setSize(size.width, size.height + this.myValidationPanel.getPreferredSize().height);
                    this.myWindowResizedOnce = true;
                }
            } else {
                this.mySeparator.setVisible(false);
                this.myWarningLabel.setVisible(false);
                this.myFixButton.setVisible(false);
                this.myValidationPanel.setVisible(false);
            }
        }

        @NonNls
        private String generateWarningLabelText(ValidationResult configurationException) {
            return "<html><body><b>" + configurationException.getTitle() + ": </b>" + configurationException.getMessage() + "</body></html>";
        }

        private void createUIComponents() {
            this.myComponentPlace = new NonOpaquePanel();
            this.myStoreAsFileGearButton = this.createStoreAsFileGearButton();
            this.myRunOnComboBox = new RunOnTargetComboBox(SingleConfigurationConfigurable.this.myProject);
            this.myManageTargetsLabel = LinkLabel.create((String)ExecutionBundle.message((String)"edit.run.configuration.run.configuration.manage.targets.label", (Object[])new Object[0]), () -> {
                String selectedName = ((RunOnTargetComboBox)this.myRunOnComboBox).getSelectedTargetName();
                TargetEnvironmentsConfigurable configurable2 = new TargetEnvironmentsConfigurable(SingleConfigurationConfigurable.this.myProject, selectedName);
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)this.myWholePanel, (Configurable)configurable2)) {
                    this.resetRunOnComboBox(selectedName);
                }
            });
            this.myJBScrollPane = BaseRCSettingsConfigurable.wrapWithScrollPane(null);
        }

        @NotNull
        private ActionButton createStoreAsFileGearButton() {
            DumbAwareAction showStoragePathAction = new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    MyValidatableComponent.this.manageStorageFileLocation();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/SingleConfigurationConfigurable$MyValidatableComponent$2", "actionPerformed"));
                }
            };
            Presentation presentation2 = new Presentation(ExecutionBundle.message((String)"run.configuration.manage.file.location", (Object[])new Object[0]));
            presentation2.setIcon((Icon)GEAR_WITH_DROPDOWN_ICON);
            presentation2.setDisabledIcon((Icon)GEAR_WITH_DROPDOWN_DISABLED_ICON);
            return new ActionButton((AnAction)showStoragePathAction, presentation2, "toolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

                @Override
                public Icon getIcon() {
                    if (MyValidatableComponent.this.myStoreAsFileCheckBox.isSelected() && SingleConfigurationConfigurable.this.myRCStorageType == RCStorageType.ArbitraryFileInProject && SingleConfigurationConfigurable.getErrorIfBadFolderPathForStoringInArbitraryFile(SingleConfigurationConfigurable.this.myProject, SingleConfigurationConfigurable.this.myFolderPathIfStoredInArbitraryFile) != null) {
                        return GEAR_WITH_DROPDOWN_ERROR_ICON;
                    }
                    return super.getIcon();
                }
            };
        }

        private void manageStorageFileLocation() {
            final Disposable balloonDisposable = Disposer.newDisposable();
            Function pathToErrorMessage = path -> SingleConfigurationConfigurable.getErrorIfBadFolderPathForStoringInArbitraryFile(SingleConfigurationConfigurable.this.myProject, path);
            final RunConfigurationStorageUi storageUi = new RunConfigurationStorageUi(SingleConfigurationConfigurable.this.myProject, SingleConfigurationConfigurable.getDotIdeaStoragePath(SingleConfigurationConfigurable.this.myProject), (Function<String, String>)pathToErrorMessage, balloonDisposable);
            Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)storageUi.getMainPanel()).setDialogMode(true).setBorderInsets((Insets)JBUI.insets((int)20, (int)15, (int)10, (int)15)).setFillColor(UIUtil.getPanelBackground()).setHideOnAction(false).setHideOnLinkClick(false).setHideOnKeyOutside(false).setBlockClicksThroughBalloon(true).setRequestFocus(true).createBalloon();
            balloon.setAnimationEnabled(false);
            final String path2 = SingleConfigurationConfigurable.this.myRCStorageType == RCStorageType.DotIdeaFolder ? SingleConfigurationConfigurable.getDotIdeaStoragePath(SingleConfigurationConfigurable.this.myProject) : StringUtil.notNullize((String)SingleConfigurationConfigurable.this.myFolderPathIfStoredInArbitraryFile);
            LinkedHashSet<String> pathsToSuggest = new LinkedHashSet<String>();
            if (SingleConfigurationConfigurable.getErrorIfBadFolderPathForStoringInArbitraryFile(SingleConfigurationConfigurable.this.myProject, path2) == null) {
                pathsToSuggest.add(path2);
            }
            if (((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).isStoredInArbitraryFileInProject()) {
                pathsToSuggest.add(PathUtil.getParentPath((String)StringUtil.notNullize((String)((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).getPathIfStoredInArbitraryFileInProject())));
            }
            pathsToSuggest.add(SingleConfigurationConfigurable.getDotIdeaStoragePath(SingleConfigurationConfigurable.this.myProject));
            pathsToSuggest.addAll(SingleConfigurationConfigurable.getFolderPathsWithinProjectWhereRunConfigurationsStored(SingleConfigurationConfigurable.this.myProject));
            storageUi.reset(path2, pathsToSuggest, () -> balloon.hide());
            balloon.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Disposer.dispose((Disposable)balloonDisposable);
                    String newPath = storageUi.getPath();
                    if (!newPath.equals(path2)) {
                        MyValidatableComponent.this.applyChangedStoragePath(newPath);
                        SingleConfigurationConfigurable.this.setModified(true);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/SingleConfigurationConfigurable$MyValidatableComponent$4", "onClosed"));
                }
            });
            balloon.show(RelativePoint.getSouthOf((JComponent)this.myStoreAsFileCheckBox), Balloon.Position.below);
        }

        private void applyChangedStoragePath(String newPath) {
            if (newPath.equals(SingleConfigurationConfigurable.getDotIdeaStoragePath(SingleConfigurationConfigurable.this.myProject))) {
                SingleConfigurationConfigurable.this.myRCStorageType = RCStorageType.DotIdeaFolder;
                SingleConfigurationConfigurable.this.myFolderPathIfStoredInArbitraryFile = null;
            } else {
                SingleConfigurationConfigurable.this.myRCStorageType = RCStorageType.ArbitraryFileInProject;
                SingleConfigurationConfigurable.this.myFolderPathIfStoredInArbitraryFile = newPath;
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JSeparator jSeparator;
            JButton jButton;
            JBLabel jBLabel;
            JPanel jPanel2;
            JPanel jPanel3;
            JPanel jPanel4;
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JTextField jTextField;
            JLabel jLabel;
            this.createUIComponents();
            JPanel jPanel5 = new JPanel();
            this.myWholePanel = jPanel5;
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
            jPanel5.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 3, null, null, null));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 5, 3, 0), -1, -1, false, false));
            jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myNameLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("edit.run.configuration.run.configuration.name.label"));
            jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNameText = jTextField = new JTextField();
            jTextField.setColumns(15);
            jPanel7.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
            this.myIsAllowRunningInParallelCheckBox = jBCheckBox2 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("run.configuration.allow.running.parallel"));
            jPanel7.add((Component)jBCheckBox2, new GridConstraints(0, 3, 1, 1, 0, 2, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel7.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, new Dimension(20, -1), new Dimension(20, -1), null));
            Spacer spacer2 = new Spacer();
            jPanel7.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 0, 1, new Dimension(10, -1), new Dimension(10, -1), null));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
            jPanel7.add((Component)jPanel8, new GridConstraints(0, 5, 1, 2, 0, 3, 3, 3, null, null, null));
            this.myStoreAsFileCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("run.configuration.store.as.project.file"));
            jPanel8.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 2, 0, 0, null, null, null));
            ActionButton actionButton = this.myStoreAsFileGearButton;
            jPanel8.add((Component)actionButton, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
            JBScrollPane jBScrollPane = this.myJBScrollPane;
            jBScrollPane.setHorizontalScrollBarPolicy(31);
            jPanel5.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
            JPanel jPanel9 = this.myComponentPlace;
            jBScrollPane.setViewportView(jPanel9);
            this.myRunOnPanel = jPanel4 = new JPanel();
            jPanel4.setLayout(new GridBagLayout());
            jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myRunOnPanelInner = jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            jPanel4.add((Component)jPanel3, gridBagConstraints);
            ComboBox comboBox2 = this.myRunOnComboBox;
            jPanel3.add((Component)comboBox2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, new Dimension(250, -1), null));
            JLabel jLabel2 = this.myManageTargetsLabel;
            this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("edit.run.configuration.run.configuration.manage.targets.label"));
            jPanel3.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, new Dimension(115, 16), null));
            Spacer spacer3 = new Spacer();
            jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myValidationPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel5.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myWarningLabel = jBLabel = new JBLabel();
            jBLabel.setText("####################");
            jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, new Dimension(10, -1), new Dimension(10, -1), null));
            this.myFixButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("fix.run.configuration.problem.button"));
            jPanel2.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.mySeparator = jSeparator = new JSeparator();
            jPanel2.add((Component)jSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static enum RCStorageType {
        Workspace,
        DotIdeaFolder,
        ArbitraryFileInProject;

    }
}

