/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.WrapImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockWrapper {
    private static final Set<Indent.Type> RELATIVE_INDENT_TYPES = ContainerUtil.set((Object[])new Indent.Type[]{Indent.Type.NORMAL, Indent.Type.CONTINUATION, Indent.Type.CONTINUATION_WITHOUT_FIRST});
    @NotNull
    private final WhiteSpace myWhiteSpaceBefore;
    protected CompositeBlockWrapper myParent;
    protected int myStart;
    protected int myEnd;
    protected int myFlags;
    static int CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT = 1;
    static int INCOMPLETE = 2;
    private final Language myLanguage;
    protected IndentInfo myIndentFromParent;
    private IndentImpl myIndent;
    private AlignmentImpl myAlignment;
    private WrapImpl myWrap;
    private final ASTNode myNode;

    public AbstractBlockWrapper(Block block, @NotNull WhiteSpace whiteSpaceBefore, CompositeBlockWrapper parent, TextRange textRange) {
        if (whiteSpaceBefore == null) {
            AbstractBlockWrapper.$$$reportNull$$$0(0);
        }
        this.myIndentFromParent = null;
        this.myIndent = null;
        this.myWhiteSpaceBefore = whiteSpaceBefore;
        this.myParent = parent;
        this.myStart = textRange.getStartOffset();
        this.myEnd = textRange.getEndOffset();
        this.myFlags = CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT | (block.isIncomplete() ? INCOMPLETE : 0);
        this.myAlignment = (AlignmentImpl)block.getAlignment();
        this.myWrap = (WrapImpl)block.getWrap();
        this.myLanguage = AbstractBlockWrapper.deriveLanguage(block);
        this.myNode = block instanceof ASTBlock ? ((ASTBlock)block).getNode() : null;
    }

    @Nullable
    private static Language deriveLanguage(@NotNull Block block) {
        if (block == null) {
            AbstractBlockWrapper.$$$reportNull$$$0(1);
        }
        if (block instanceof BlockEx) {
            return ((BlockEx)block).getLanguage();
        }
        return null;
    }

    @NotNull
    public WhiteSpace getWhiteSpace() {
        WhiteSpace whiteSpace = this.myWhiteSpaceBefore;
        if (whiteSpace == null) {
            AbstractBlockWrapper.$$$reportNull$$$0(2);
        }
        return whiteSpace;
    }

    @Nullable
    public ASTNode getNode() {
        return this.myNode;
    }

    public ArrayList<WrapImpl> getWraps() {
        ArrayList<WrapImpl> result2 = new ArrayList<WrapImpl>(3);
        AbstractBlockWrapper current2 = this;
        while (current2 != null && current2.getStartOffset() == this.getStartOffset()) {
            WrapImpl wrap = current2.getOwnWrap();
            if (wrap != null && !result2.contains((Object)wrap)) {
                result2.add(0, wrap);
            }
            if (wrap != null && wrap.getIgnoreParentWraps()) break;
            current2 = current2.myParent;
        }
        return result2;
    }

    public int getStartOffset() {
        return this.myStart;
    }

    public int getEndOffset() {
        return this.myEnd;
    }

    public int getLength() {
        return this.myEnd - this.myStart;
    }

    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }

    protected void arrangeStartOffset(int startOffset) {
        if (this.getStartOffset() == startOffset) {
            return;
        }
        boolean isFirst = this.getParent() != null && this.getStartOffset() == this.getParent().getStartOffset();
        this.myStart = startOffset;
        if (isFirst) {
            this.getParent().arrangeStartOffset(startOffset);
        }
    }

    public IndentImpl getIndent() {
        return this.myIndent;
    }

    public CompositeBlockWrapper getParent() {
        return this.myParent;
    }

    @Nullable
    public WrapImpl getWrap() {
        ArrayList<WrapImpl> wraps = this.getWraps();
        if (wraps.size() == 0) {
            return null;
        }
        return wraps.get(0);
    }

    public WrapImpl getOwnWrap() {
        return this.myWrap;
    }

    public void reset() {
        WrapImpl wrap;
        this.myFlags |= CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT;
        AlignmentImpl alignment = this.myAlignment;
        if (alignment != null) {
            alignment.reset();
        }
        if ((wrap = this.myWrap) != null) {
            wrap.reset();
        }
    }

    public IndentData getChildOffset(AbstractBlockWrapper child2, CommonCodeStyleSettings.IndentOptions options2, int targetBlockStartOffset) {
        IndentData indent;
        IndentData childIndent;
        boolean childStartsNewLine = child2.getWhiteSpace().containsLineFeeds();
        Indent.Type childIndentType = child2.getIndent().getType();
        if (childStartsNewLine || !this.getWhiteSpace().containsLineFeeds() && RELATIVE_INDENT_TYPES.contains(childIndentType) && this.indentAlreadyUsedBefore(child2)) {
            childIndent = CoreFormatterUtil.getIndent(options2, child2, targetBlockStartOffset);
        } else if (child2.getIndent().isEnforceIndentToChildren() && !child2.getWhiteSpace().containsLineFeeds()) {
            AlignmentImpl alignment = child2.getAlignment();
            if (alignment != null) {
                AbstractBlockWrapper anchorBlock = this.getAnchorBlock(child2, targetBlockStartOffset, alignment);
                return anchorBlock.getNumberOfSymbolsBeforeBlock();
            }
            childIndent = CoreFormatterUtil.getIndent(options2, child2, this.getStartOffset());
        } else {
            childIndent = new IndentData(0);
        }
        if (childStartsNewLine) {
            if (child2.getIndent().isAbsolute()) {
                this.myFlags &= ~CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT;
                AbstractBlockWrapper current2 = this;
                while (current2 != null && current2.getStartOffset() == this.getStartOffset()) {
                    current2.myFlags &= ~CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT;
                    current2 = current2.myParent;
                }
                return childIndent;
            }
            if (child2.getIndent().isRelativeToDirectParent() && child2.getStartOffset() > this.getStartOffset()) {
                return childIndent.add(this.getNumberOfSymbolsBeforeBlock());
            }
        }
        if (child2.getStartOffset() == this.getStartOffset()) {
            boolean newValue2 = (this.myFlags & CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) != 0 && (child2.myFlags & CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) != 0 && childIndent.isEmpty();
            this.setCanUseFirstChildIndentAsBlockIndent(newValue2);
        }
        if (this.getStartOffset() == targetBlockStartOffset) {
            if (this.myParent == null) {
                return childIndent;
            }
            return childIndent.add(this.myParent.getChildOffset(this, options2, targetBlockStartOffset));
        }
        if (!this.getWhiteSpace().containsLineFeeds()) {
            indent = this.createAlignmentIndent(childIndent, child2);
            if (indent != null) {
                return indent;
            }
            return childIndent.add(this.myParent.getChildOffset(this, options2, targetBlockStartOffset));
        }
        if (this.myParent == null) {
            return childIndent.add(this.getWhiteSpace());
        }
        if (this.getIndent().isAbsolute()) {
            if (this.myParent.myParent != null) {
                return childIndent.add(this.myParent.myParent.getChildOffset(this.myParent, options2, targetBlockStartOffset));
            }
            return childIndent.add(this.getWhiteSpace());
        }
        if ((this.myFlags & CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) != 0) {
            indent = this.createAlignmentIndent(childIndent, child2);
            if (indent != null) {
                return indent;
            }
            return childIndent.add(this.getWhiteSpace());
        }
        return childIndent.add(this.myParent.getChildOffset(this, options2, targetBlockStartOffset));
    }

    @NotNull
    private AbstractBlockWrapper getAnchorBlock(AbstractBlockWrapper child2, int targetBlockStartOffset, AlignmentImpl alignment) {
        AbstractBlockWrapper anchorBlock = alignment.getOffsetRespBlockBefore(child2);
        if (anchorBlock == null && (anchorBlock = this) instanceof CompositeBlockWrapper) {
            List<AbstractBlockWrapper> children2 = ((CompositeBlockWrapper)anchorBlock).getChildren();
            for (AbstractBlockWrapper c : children2) {
                if (c.getStartOffset() == this.getStartOffset() || c.getStartOffset() >= targetBlockStartOffset) continue;
                anchorBlock = c;
                break;
            }
        }
        LeafBlockWrapper leafBlockWrapper = anchorBlock;
        if (leafBlockWrapper == null) {
            AbstractBlockWrapper.$$$reportNull$$$0(3);
        }
        return leafBlockWrapper;
    }

    protected abstract boolean indentAlreadyUsedBefore(AbstractBlockWrapper var1);

    public abstract IndentData getNumberOfSymbolsBeforeBlock();

    @Nullable
    protected abstract LeafBlockWrapper getPreviousBlock();

    protected final void setCanUseFirstChildIndentAsBlockIndent(boolean newValue2) {
        this.myFlags = newValue2 ? (this.myFlags |= CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) : (this.myFlags &= ~CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT);
    }

    public void arrangeParentTextRange() {
        if (this.myParent != null) {
            this.myParent.arrangeStartOffset(this.getStartOffset());
        }
    }

    public IndentData calculateChildOffset(CommonCodeStyleSettings.IndentOptions indentOption, ChildAttributes childAttributes, int index) {
        IndentImpl childIndent = (IndentImpl)childAttributes.getChildIndent();
        if (childIndent == null) {
            childIndent = (IndentImpl)Indent.getContinuationWithoutFirstIndent((boolean)indentOption.USE_RELATIVE_INDENTS);
        }
        IndentData indent = AbstractBlockWrapper.getIndent(indentOption, index, childIndent);
        if (childIndent.isRelativeToDirectParent()) {
            return new IndentData(indent.getIndentSpaces() + CoreFormatterUtil.getStartColumn(CoreFormatterUtil.getFirstLeaf(this)), indent.getSpaces());
        }
        if (this.myParent == null || (this.myFlags & CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) != 0 && this.getWhiteSpace().containsLineFeeds()) {
            return indent.add(this.getWhiteSpace());
        }
        IndentData offsetFromParent = this.myParent.getChildOffset(this, indentOption, -1);
        return indent.add(offsetFromParent);
    }

    @Nullable
    public AlignmentImpl getAlignmentAtStartOffset() {
        for (AbstractBlockWrapper block = this; block != null && block.getStartOffset() == this.getStartOffset(); block = block.getParent()) {
            if (block.getAlignment() == null) continue;
            return block.getAlignment();
        }
        return null;
    }

    @Nullable
    private IndentData createAlignmentIndent(IndentData indentFromParent, AbstractBlockWrapper child2) {
        if (!child2.getWhiteSpace().containsLineFeeds()) {
            return null;
        }
        AlignmentImpl alignment = this.getAlignmentAtStartOffset();
        if (alignment == null || alignment == child2.getAlignment()) {
            return null;
        }
        LeafBlockWrapper previous = child2.getPreviousBlock();
        LeafBlockWrapper anchorOffsetBlock = alignment.getOffsetRespBlockBefore(child2);
        if (anchorOffsetBlock != null && anchorOffsetBlock.getStartOffset() != this.getStartOffset()) {
            boolean onDifferentLines = false;
            for (LeafBlockWrapper b = anchorOffsetBlock.getNextBlock(); b != null && b.getStartOffset() < this.getStartOffset(); b = b.getNextBlock()) {
                if (!b.getWhiteSpace().containsLineFeeds()) continue;
                onDifferentLines = true;
                break;
            }
            if (!onDifferentLines) {
                return null;
            }
        }
        if (previous == null) {
            return indentFromParent;
        }
        IndentData symbolsBeforeCurrent = anchorOffsetBlock == null ? this.getNumberOfSymbolsBeforeBlock() : anchorOffsetBlock.getNumberOfSymbolsBeforeBlock();
        int indentSpaces = symbolsBeforeCurrent.getIndentSpaces() + indentFromParent.getSpaces() + indentFromParent.getIndentSpaces();
        return new IndentData(indentSpaces, symbolsBeforeCurrent.getSpaces());
    }

    private static IndentData getIndent(CommonCodeStyleSettings.IndentOptions options2, int index, IndentImpl indent) {
        if (indent.getType() == Indent.Type.CONTINUATION) {
            return new IndentData(options2.CONTINUATION_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.CONTINUATION_WITHOUT_FIRST) {
            if (index != 0) {
                return new IndentData(options2.CONTINUATION_INDENT_SIZE);
            }
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.LABEL) {
            return new IndentData(options2.LABEL_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.NONE) {
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.SPACES) {
            return new IndentData(indent.getSpaces(), 0);
        }
        return new IndentData(options2.INDENT_SIZE);
    }

    public void setIndentFromParent(IndentInfo indentFromParent) {
        this.myIndentFromParent = indentFromParent;
        if (this.myIndentFromParent != null) {
            CompositeBlockWrapper parent = this.myParent;
            if (this.myParent != null && this.myParent.getStartOffset() == this.myStart) {
                parent.setIndentFromParent(this.myIndentFromParent);
            }
        }
    }

    @Nullable
    protected AbstractBlockWrapper findFirstIndentedParent() {
        if (this.myParent == null) {
            return null;
        }
        if (this.myStart != this.myParent.getStartOffset() && this.myParent.getWhiteSpace().containsLineFeeds()) {
            return this.myParent;
        }
        return this.myParent.findFirstIndentedParent();
    }

    public void setIndent(@Nullable IndentImpl indent) {
        this.myIndent = indent;
    }

    public AlignmentImpl getAlignment() {
        return this.myAlignment;
    }

    public boolean isIncomplete() {
        return (this.myFlags & INCOMPLETE) != 0;
    }

    public void dispose() {
        this.myAlignment = null;
        this.myWrap = null;
        this.myIndent = null;
        this.myIndentFromParent = null;
        this.myParent = null;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.myStart + "-" + this.myEnd + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceBefore";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/AbstractBlockWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/AbstractBlockWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhiteSpace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchorBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deriveLanguage";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

