/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.gotoByName.LanguageRef;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeUICustomization;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassSearchEverywhereContributor
extends AbstractGotoSEContributor {
    private static final Pattern ourPatternToDetectAnonymousClasses = Pattern.compile("([.\\w]+)((\\$[\\d]+)*(\\$)?)");
    private static final Pattern ourPatternToDetectMembers = Pattern.compile("(.+)(#)(.*)");
    private final PersistentSearchEverywhereContributorFilter<LanguageRef> myFilter;

    public ClassSearchEverywhereContributor(@NotNull AnActionEvent event) {
        if (event == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        super(event);
        this.myFilter = ClassSearchEverywhereContributor.createLanguageFilter((Project)event.getRequiredData(CommonDataKeys.PROJECT));
    }

    @NotNull
    public String getGroupName() {
        String string = GotoClassPresentationUpdater.getTabTitlePluralized();
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFullGroupName() {
        String string = String.join((CharSequence)"/", GotoClassPresentationUpdater.getActionTitlePluralized());
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String includeNonProjectItemsText() {
        String string = IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.items", new Object[0]);
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getSortWeight() {
        return 100;
    }

    @NotNull
    protected FilteringGotoByModel<LanguageRef> createModel(@NotNull Project project) {
        if (project == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        GotoClassModel2 model = new GotoClassModel2(project);
        if (this.myFilter != null) {
            model.setFilterItems(this.myFilter.getSelectedElements());
        }
        GotoClassModel2 gotoClassModel2 = model;
        if (gotoClassModel2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        return gotoClassModel2;
    }

    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged) {
        if (onChanged == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        List<AnAction> list2 = this.doGetActions(this.includeNonProjectItemsText(), this.myFilter, onChanged);
        if (list2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        if (pattern.indexOf(35) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, ourPatternToDetectMembers);
        }
        if (pattern.indexOf(36) != -1) {
            pattern = ClassSearchEverywhereContributor.applyPatternFilter(pattern, ourPatternToDetectAnonymousClasses);
        }
        String string = super.filterControlSymbols(pattern);
        if (string == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        if (element2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(10);
        }
        if (searchPattern == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(11);
        }
        return super.getElementPriority(element2, searchPattern) + 5;
    }

    @Override
    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        String path = ClassSearchEverywhereContributor.pathToAnonymousClass(searchText);
        if (path != null) {
            psiElement = ClassSearchEverywhereContributor.getElement(psiElement, path);
        }
        return super.preparePsi(psiElement, modifiers, searchText);
    }

    @Override
    @Nullable
    protected Navigatable createExtendedNavigatable(final PsiElement psi, String searchText, final int modifiers) {
        Navigatable delegate;
        Navigatable res2 = super.createExtendedNavigatable(psi, searchText, modifiers);
        if (res2 != null) {
            return res2;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
        String memberName = ClassSearchEverywhereContributor.getMemberName(searchText);
        if (file2 != null && memberName != null && (delegate = ClassSearchEverywhereContributor.findMember(memberName, searchText, psi, file2)) != null) {
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    NavigationUtil.activateFileWithPsiElement(psi, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
                    delegate.navigate(true);
                }

                public boolean canNavigate() {
                    return delegate.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return delegate.canNavigateToSource();
                }
            };
        }
        return null;
    }

    private static String pathToAnonymousClass(String searchedText) {
        return ClassSearchEverywhereContributor.pathToAnonymousClass(ourPatternToDetectAnonymousClasses.matcher(searchedText));
    }

    @Nullable
    public static String pathToAnonymousClass(Matcher matcher) {
        String path;
        if (matcher.matches() && (path = matcher.group(2)) != null) {
            if ((path = path.trim()).endsWith("$") && path.length() >= 2) {
                path = path.substring(0, path.length() - 2);
            }
            if (!path.isEmpty()) {
                return path;
            }
        }
        return null;
    }

    private static String getMemberName(String searchedText) {
        int index = searchedText.lastIndexOf(35);
        if (index == -1) {
            return null;
        }
        String name = searchedText.substring(index + 1).trim();
        return StringUtil.isEmpty((String)name) ? null : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Navigatable findMember(String memberPattern, String fullPattern, PsiElement psiElement, VirtualFile file2) {
        PsiStructureViewFactory factory2 = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(psiElement.getLanguage());
        StructureViewBuilder builder2 = factory2 == null ? null : factory2.getStructureViewBuilder(psiElement.getContainingFile());
        FileEditor[] editors = FileEditorManager.getInstance((Project)psiElement.getProject()).getEditors(file2);
        if (builder2 == null || editors.length == 0) {
            return null;
        }
        StructureView view = builder2.createStructureView(editors[0], psiElement.getProject());
        try {
            StructureViewTreeElement element2 = ClassSearchEverywhereContributor.findElement(view.getTreeModel().getRoot(), psiElement, 4);
            if (element2 == null) {
                Navigatable navigatable = null;
                return navigatable;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)memberPattern).build();
            int max = Integer.MIN_VALUE;
            Object target2 = null;
            for (TreeElement treeElement : element2.getChildren()) {
                int degree;
                if (!(treeElement instanceof StructureViewTreeElement)) continue;
                Object value2 = ((StructureViewTreeElement)treeElement).getValue();
                if (value2 instanceof PsiElement && value2 instanceof Navigatable && fullPattern.equals(CopyReferenceAction.elementToFqn((PsiElement)value2))) {
                    Navigatable navigatable = (Navigatable)value2;
                    return navigatable;
                }
                String presentableText = treeElement.getPresentation().getPresentableText();
                if (presentableText == null || (degree = matcher.matchingDegree(presentableText)) <= max) continue;
                max = degree;
                target2 = ((StructureViewTreeElement)treeElement).getValue();
            }
            Navigatable navigatable = target2 instanceof Navigatable ? (Navigatable)target2 : null;
            return navigatable;
        }
        finally {
            Disposer.dispose((Disposable)view);
        }
    }

    @Nullable
    private static StructureViewTreeElement findElement(StructureViewTreeElement node, PsiElement element2, int hopes) {
        Object value2 = node.getValue();
        if (value2 instanceof PsiElement) {
            if (((PsiElement)value2).isEquivalentTo(element2)) {
                return node;
            }
            if (hopes != 0) {
                for (TreeElement child2 : node.getChildren()) {
                    StructureViewTreeElement e;
                    if (!(child2 instanceof StructureViewTreeElement) || (e = ClassSearchEverywhereContributor.findElement((StructureViewTreeElement)child2, element2, hopes - 1)) == null) continue;
                    return e;
                }
            }
        }
        return null;
    }

    @NotNull
    public static PsiElement getElement(@NotNull PsiElement element2, @NotNull String path) {
        if (element2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(12);
        }
        if (path == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(13);
        }
        String[] classes = path.split("\\$");
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String cls : classes) {
            if (cls.isEmpty()) continue;
            try {
                indexes.add(Integer.parseInt(cls) - 1);
            }
            catch (Exception e) {
                PsiElement psiElement = element2;
                if (psiElement == null) {
                    ClassSearchEverywhereContributor.$$$reportNull$$$0(14);
                }
                return psiElement;
            }
        }
        PsiElement current2 = element2;
        Iterator iterator2 = indexes.iterator();
        while (iterator2.hasNext()) {
            int index = (Integer)iterator2.next();
            PsiElement[] anonymousClasses = ClassSearchEverywhereContributor.getAnonymousClasses(current2);
            if (index >= 0 && index < anonymousClasses.length) {
                current2 = anonymousClasses[index];
                continue;
            }
            PsiElement psiElement = current2;
            if (psiElement == null) {
                ClassSearchEverywhereContributor.$$$reportNull$$$0(15);
            }
            return psiElement;
        }
        PsiElement psiElement = current2;
        if (psiElement == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(16);
        }
        return psiElement;
    }

    private static PsiElement @NotNull [] getAnonymousClasses(@NotNull PsiElement element2) {
        if (element2 == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(17);
        }
        for (AnonymousElementProvider provider : AnonymousElementProvider.EP_NAME.getExtensionList()) {
            PsiElement[] elements2 = provider.getAnonymousElements(element2);
            if (elements2.length <= 0) continue;
            if (elements2 == null) {
                ClassSearchEverywhereContributor.$$$reportNull$$$0(18);
            }
            return elements2;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(19);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    static PersistentSearchEverywhereContributorFilter<LanguageRef> createLanguageFilter(@NotNull Project project) {
        if (project == null) {
            ClassSearchEverywhereContributor.$$$reportNull$$$0(20);
        }
        List<LanguageRef> items = LanguageRef.forAllLanguages();
        GotoClassSymbolConfiguration persistentConfig = GotoClassSymbolConfiguration.getInstance(project);
        return new PersistentSearchEverywhereContributorFilter<LanguageRef>(items, persistentConfig, LanguageRef::getDisplayName, LanguageRef::getIcon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullGroupName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "includeNonProjectItemsText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterControlSymbols";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterControlSymbols";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousClasses";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            if (initEvent == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return new ClassSearchEverywhereContributor(initEvent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initEvent", "com/intellij/ide/actions/searcheverywhere/ClassSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

