/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.pico.DefaultPicoContainer;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisablePCEAction
extends DumbAwareToggleAction {
    private static final String STATUS_BAR_WIDGET_ID = "PCEDisabledStatus";

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            DisablePCEAction.$$$reportNull$$$0(0);
        }
        return ProgressManager.getInstance().getClass() != ProgressManagerImpl.class;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            DisablePCEAction.$$$reportNull$$$0(1);
        }
        DisablePCEAction.changePCEEnabledStatus(!state);
    }

    private static void changePCEEnabledStatus(boolean enabled) {
        ProgressManager newManager = DisablePCEAction.createDebugManager(enabled);
        DisablePCEAction.replaceServiceInstance((ComponentManager)ApplicationManager.getApplication(), ProgressManager.class, newManager);
        CachedSingletonsRegistry.cleanupCachedFields();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar == null) continue;
            if (statusBar.getWidget(STATUS_BAR_WIDGET_ID) == null) {
                if (enabled) continue;
                statusBar.addWidget((StatusBarWidget)new StatusWidget(), "before Position");
                statusBar.updateWidget(STATUS_BAR_WIDGET_ID);
                continue;
            }
            if (!enabled) continue;
            statusBar.removeWidget(STATUS_BAR_WIDGET_ID);
        }
    }

    @NotNull
    private static ProgressManager createDebugManager(boolean enabledPCE) {
        return enabledPCE ? new ProgressManagerImpl() : new ProgressManagerImpl(){

            @Override
            protected void doCheckCanceled() throws ProcessCanceledException {
                1.runCheckCanceledHooks(this.getProgressIndicator());
            }

            @Override
            public boolean isInNonCancelableSection() {
                return true;
            }
        };
    }

    private static <T> void replaceServiceInstance(ComponentManager componentManager, Class<T> interfaceClass, T instance) {
        DefaultPicoContainer container2 = (DefaultPicoContainer)componentManager.getPicoContainer();
        String key = interfaceClass.getName();
        Object old = container2.getComponentInstance((Object)key);
        container2.unregisterComponent((Object)key);
        Disposer.dispose((Disposable)((Disposable)old));
        container2.registerComponentInstance((Object)key, instance);
        Disposer.register((Disposable)componentManager, (Disposable)((Disposable)instance));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/internal/DisablePCEAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StatusWidget
    implements StatusBarWidget,
    StatusBarWidget.TextPresentation {
        private StatusWidget() {
        }

        @NotNull
        public String ID() {
            return DisablePCEAction.STATUS_BAR_WIDGET_ID;
        }

        @Nullable
        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this;
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                StatusWidget.$$$reportNull$$$0(0);
            }
        }

        public void dispose() {
        }

        @Nullable
        public String getTooltipText() {
            return "Click to re-enable ProcessCanceledException";
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer() {
            return event -> DisablePCEAction.changePCEEnabledStatus(true);
        }

        @NotNull
        public String getText() {
            return "WARNING: PCE is disabled!";
        }

        public float getAlignment() {
            return 0.5f;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/internal/DisablePCEAction$StatusWidget", "install"));
        }
    }
}

