/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.Nullable;

public abstract class ConvertIndentsActionBase
extends EditorAction {
    protected ConvertIndentsActionBase() {
        super(null);
        this.setupHandler((EditorActionHandler)new Handler());
    }

    protected abstract int performAction(Editor var1, TextRange var2);

    private class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            SelectionModel selectionModel = editor.getSelectionModel();
            int changedLines = 0;
            changedLines = selectionModel.hasSelection() ? ConvertIndentsActionBase.this.performAction(editor, new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd())) : (changedLines += ConvertIndentsActionBase.this.performAction(editor, new TextRange(0, editor.getDocument().getTextLength())));
            if (changedLines == 0) {
                HintManager.getInstance().showInformationHint(editor, IdeBundle.message((String)"hint.text.all.lines.already.have.requested.indentation", (Object[])new Object[0]));
            } else {
                HintManager.getInstance().showInformationHint(editor, IdeBundle.message((String)"hint.text.changed.indentation.in", (Object[])new Object[]{changedLines}));
            }
        }
    }
}

