/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JpsFileTargetContextUtils;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PsiFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public static PsiFileReferenceHelper getInstance() {
        PsiFileReferenceHelper psiFileReferenceHelper = Objects.requireNonNull((PsiFileReferenceHelper)FileReferenceHelper.EP_NAME.findExtension(PsiFileReferenceHelper.class));
        if (psiFileReferenceHelper == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(0);
        }
        return psiFileReferenceHelper;
    }

    @Override
    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference2) {
        List<? extends LocalQuickFix> list2 = FileReferenceQuickFixProvider.registerQuickFix(reference2);
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file2) {
        ProjectFileIndex index;
        VirtualFile contentRootForFile;
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(2);
        }
        if ((contentRootForFile = (index = ProjectRootManager.getInstance((Project)project).getFileIndex()).getSourceRootForFile(file2)) == null) {
            contentRootForFile = index.getContentRootForFile(file2);
        }
        if (contentRootForFile != null) {
            return PsiManager.getInstance((Project)project).findDirectory(contentRootForFile);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(3);
        }
        List<PsiFileSystemItem> list2 = PsiFileReferenceHelper.getContextsForModule(module, "", module.getModuleWithDependenciesScope());
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<FileTargetContext> getTargetContexts(@NotNull Project project, @NotNull VirtualFile file2, boolean isAbsoluteReference) {
        List<PsiFileSystemItem> contexts;
        if (project == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(6);
        }
        if (isAbsoluteReference) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Module module = index.getModuleForFile(file2);
            if (module == null) {
                List<FileTargetContext> list2 = Collections.emptyList();
                if (list2 == null) {
                    PsiFileReferenceHelper.$$$reportNull$$$0(7);
                }
                return list2;
            }
            contexts = PsiFileReferenceHelper.getContextsForModule(module, "", module.getModuleWithDependenciesScope());
        } else {
            contexts = this.getContexts(project, file2, true);
        }
        ArrayList<FileTargetContext> fileTargetContexts = new ArrayList<FileTargetContext>();
        for (PsiFileSystemItem context : contexts) {
            if (context instanceof VirtualPsiDirectory) {
                VirtualPsiDirectory virtual = (VirtualPsiDirectory)context;
                fileTargetContexts.add(new FileTargetContext((PsiFileSystemItem)virtual.getRoot(), virtual.getPathToCreate()));
                continue;
            }
            fileTargetContexts.add(new FileTargetContext(context));
        }
        Collection<FileTargetContext> collection = JpsFileTargetContextUtils.prepareTargetContexts(project, file2, fileTargetContexts);
        if (collection == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static String[] removeCommonStartPackages(String[] path, String packagePath) {
        String existingPackage;
        String part;
        int i2;
        List packages = StringUtil.split((String)packagePath, (String)".");
        SmartList result2 = new SmartList();
        for (i2 = 0; i2 < packages.size() && i2 < path.length && Objects.equals(part = path[i2], existingPackage = (String)packages.get(i2)); ++i2) {
        }
        while (i2 < path.length) {
            result2.add(path[i2]);
            ++i2;
        }
        return ArrayUtil.toStringArray((Collection)result2);
    }

    private static String @NotNull [] getRelativePath(VirtualFile file2, VirtualFile root) {
        ArrayList<String> names2 = new ArrayList<String>();
        for (VirtualFile parent = file2; parent != null && !parent.equals(root); parent = parent.getParent()) {
            names2.add(parent.getName());
        }
        if (names2.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                PsiFileReferenceHelper.$$$reportNull$$$0(9);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] path = new String[names2.size()];
        for (int i2 = 0; i2 < names2.size(); ++i2) {
            path[i2] = (String)names2.get(names2.size() - i2 - 1);
        }
        if (path == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(10);
        }
        return path;
    }

    @NotNull
    private static List<SourceFolder> getMissingTargetFolders(Module module, Collection<PsiFileSystemItem> contextsForModule) {
        ModuleRootManager model = ModuleRootManager.getInstance((Module)module);
        List list2 = (List)Arrays.stream(model.getContentEntries()).flatMap(contentEntry -> Arrays.stream(contentEntry.getSourceFolders())).filter(sourceFolder -> {
            if (sourceFolder.getFile() == null) {
                return false;
            }
            for (PsiFileSystemItem contextItem : contextsForModule) {
                if (!VfsUtilCore.isAncestor((VirtualFile)sourceFolder.getFile(), (VirtualFile)contextItem.getVirtualFile(), (boolean)false)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toCollection(SmartList::new));
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private List<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file2, boolean includeMissingPackages) {
        PsiFileSystemItem parent;
        PsiFileSystemItem item;
        if (project == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(13);
        }
        if ((item = this.getPsiFileSystemItem(project, file2)) != null && (parent = item.getParent()) != null) {
            Module module;
            String path;
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile parentFile = parent.getVirtualFile();
            assert (parentFile != null);
            VirtualFile root = index.getSourceRootForFile(parentFile);
            if (root != null && (path = VfsUtilCore.getRelativePath((VirtualFile)parentFile, (VirtualFile)root, (char)'.')) != null && (module = index.getModuleForFile(file2)) != null) {
                OrderEntry orderEntry = ModuleRootManager.getInstance((Module)module).getFileIndex().getOrderEntryForFile(file2);
                String rootPackagePrefix = PsiFileReferenceHelper.getSourceRootPackagePrefix(orderEntry, root);
                if (!rootPackagePrefix.isEmpty()) {
                    path = path + "." + rootPackagePrefix;
                }
                List<PsiFileSystemItem> contextsForModule = PsiFileReferenceHelper.getContextsForModule(module, path, module.getModuleWithDependenciesScope());
                if (!includeMissingPackages) {
                    return contextsForModule;
                }
                return PsiFileReferenceHelper.getAdditionalContexts(parentFile, root, module, contextsForModule);
            }
            return Collections.singletonList(parent);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<PsiFileSystemItem> getAdditionalContexts(@NotNull VirtualFile parentFile, @NotNull VirtualFile root, @NotNull Module module, @NotNull List<PsiFileSystemItem> contextsForModule) {
        List<SourceFolder> additionalSourceFolders;
        if (parentFile == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(14);
        }
        if (root == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(15);
        }
        if (module == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(16);
        }
        if (contextsForModule == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(17);
        }
        if ((additionalSourceFolders = PsiFileReferenceHelper.getMissingTargetFolders(module, contextsForModule)).isEmpty()) {
            List<PsiFileSystemItem> list2 = contextsForModule;
            if (list2 == null) {
                PsiFileReferenceHelper.$$$reportNull$$$0(18);
            }
            return list2;
        }
        ArrayList<PsiFileSystemItem> joinedContexts = new ArrayList<PsiFileSystemItem>(contextsForModule.size() + additionalSourceFolders.size());
        joinedContexts.addAll(contextsForModule);
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        String[] relativePath = PsiFileReferenceHelper.getRelativePath(parentFile, root);
        for (SourceFolder sourceFolder : additionalSourceFolders) {
            PsiDirectory directory;
            if (sourceFolder.getFile() == null || (directory = manager.findDirectory(sourceFolder.getFile())) == null) continue;
            String srcPackagePrefix = sourceFolder.getPackagePrefix();
            String[] pathToCreate = srcPackagePrefix.isEmpty() ? relativePath : PsiFileReferenceHelper.removeCommonStartPackages(relativePath, srcPackagePrefix);
            joinedContexts.add(new VirtualPsiDirectory(directory, pathToCreate));
        }
        ArrayList<PsiFileSystemItem> arrayList = joinedContexts;
        if (arrayList == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(20);
        }
        List<PsiFileSystemItem> list2 = this.getContexts(project, file2, false);
        if (list2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(21);
        }
        return list2;
    }

    private static String getSourceRootPackagePrefix(OrderEntry orderEntry, VirtualFile sourceRootOfFile) {
        if (orderEntry instanceof ModuleSourceOrderEntry) {
            for (ContentEntry e : ((ModuleSourceOrderEntry)orderEntry).getRootModel().getContentEntries()) {
                for (SourceFolder sf : e.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    String s;
                    if (!sourceRootOfFile.equals(sf.getFile()) || (s = sf.getPackagePrefix()).isEmpty()) continue;
                    return s;
                }
            }
        }
        return "";
    }

    @Override
    public boolean isMine(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(22);
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.isInSourceContent(file2);
    }

    @Override
    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(23);
        }
        String string = url.trim();
        if (string == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(24);
        }
        return string;
    }

    static List<PsiFileSystemItem> getContextsForModule(@NotNull Module module, @NotNull String packageName, @Nullable GlobalSearchScope scope) {
        if (module == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(25);
        }
        if (packageName == null) {
            PsiFileReferenceHelper.$$$reportNull$$$0(26);
        }
        List<PsiFileSystemItem> result2 = null;
        Query<VirtualFile> query = DirectoryIndex.getInstance(module.getProject()).getDirectoriesByPackageName(packageName, false);
        PsiManager manager = null;
        for (VirtualFile file2 : query) {
            PsiDirectory psiDirectory;
            if (scope != null && !scope.contains(file2)) continue;
            if (result2 == null) {
                result2 = new ArrayList<PsiFileSystemItem>();
                manager = PsiManager.getInstance((Project)module.getProject());
            }
            if ((psiDirectory = manager.findDirectory(file2)) == null) continue;
            result2.add((PsiFileSystemItem)psiDirectory);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper";
                break;
            }
            case 2: 
            case 6: 
            case 13: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextsForModule";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContexts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingTargetFolders";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalContexts";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContexts";
                break;
            }
            case 12: 
            case 13: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalContexts";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "trimUrl";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getContextsForModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VirtualPsiDirectory
    extends SyntheticFileSystemItem {
        private final PsiDirectory myRoot;
        private final String[] myPathToCreate;

        private VirtualPsiDirectory(PsiDirectory root, String[] pathToCreate) {
            super(root.getProject());
            this.myRoot = root;
            this.myPathToCreate = pathToCreate;
        }

        @Nullable
        public PsiFileSystemItem getParent() {
            return this.myRoot;
        }

        public VirtualFile getVirtualFile() {
            return null;
        }

        private PsiDirectory getRoot() {
            return this.myRoot;
        }

        private String[] getPathToCreate() {
            return this.myPathToCreate;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myPathToCreate.length == 0 ? this.myRoot.getName() : this.myPathToCreate[this.myPathToCreate.length - 1];
            if (string == null) {
                VirtualPsiDirectory.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
            if (processor2 == null) {
                VirtualPsiDirectory.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper$VirtualPsiDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper$VirtualPsiDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "processChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

