/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.HashBiMap;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.VirtualFileUrl;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityId;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl;
import com.intellij.workspaceModel.storage.impl.containers.ContainerExtensionsKt;
import com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B]\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t\u0012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001fJ&\u0010 \u001a\u00020\u001b\"\b\b\u0000\u0010!*\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$2\u0006\u0010%\u001a\u00020\u001dJ\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u0005J\u000e\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*J\u001e\u0010+\u001a\u00020\u001b\"\b\b\u0000\u0010!*\u00020\"2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H!0$J\u0006\u0010-\u001a\u00020\u0001J\u001e\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u0010%\u001a\u000201J\u000e\u00102\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R$\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "softLinks", "Lcom/intellij/util/containers/BidirectionalMultiMap;", "Lcom/intellij/workspaceModel/storage/PersistentEntityId;", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "virtualFileIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "entitySourceIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "persistentIdIndex", "externalMappings", "", "", "Lcom/intellij/workspaceModel/storage/impl/external/MutableExternalEntityMappingImpl;", "(Lcom/intellij/util/containers/BidirectionalMultiMap;Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;Ljava/util/Map;)V", "getEntitySourceIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "getExternalMappings$intellij_platform_workspaceModel_storage", "()Ljava/util/Map;", "getPersistentIdIndex$intellij_platform_workspaceModel_storage", "getSoftLinks$intellij_platform_workspaceModel_storage", "()Lcom/intellij/util/containers/BidirectionalMultiMap;", "getVirtualFileIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "applyExternalMappingChanges", "", "diff", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "replaceMap", "Lcom/google/common/collect/HashBiMap;", "entityAdded", "T", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "builder", "removeFromIndices", "entityId", "removeFromSoftLinksIndex", "softLinkable", "Lcom/intellij/workspaceModel/storage/impl/SoftLinkable;", "simpleUpdateSoftReferences", "copiedData", "toImmutable", "updateIndices", "oldEntityId", "newEntityId", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "updateSoftLinksIndex", "intellij.platform.workspaceModel.storage"})
public final class MutableStorageIndexes
extends StorageIndexes {
    @NotNull
    private final BidirectionalMultiMap<PersistentEntityId<?>, EntityId> softLinks;
    @NotNull
    private final VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex;
    @NotNull
    private final EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> entitySourceIndex;
    @NotNull
    private final EntityStorageInternalIndex.MutableEntityStorageInternalIndex<PersistentEntityId<?>> persistentIdIndex;
    @NotNull
    private final Map<String, MutableExternalEntityMappingImpl<?>> externalMappings;

    public final <T extends WorkspaceEntity> void entityAdded(@NotNull WorkspaceEntityData<T> entityData, @NotNull WorkspaceEntityStorageBuilderImpl builder2) {
        block2: {
            Intrinsics.checkParameterIsNotNull(entityData, (String)"entityData");
            Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
            EntityId pid = entityData.createPid$intellij_platform_workspaceModel_storage();
            if (entityData instanceof SoftLinkable) {
                for (PersistentEntityId<?> link : ((SoftLinkable)((Object)entityData)).getLinks()) {
                    this.getSoftLinks$intellij_platform_workspaceModel_storage().put(link, (Object)pid);
                }
            }
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(pid, entityData.getEntitySource());
            PersistentEntityId<?> persistentEntityId = EntitiesKt.persistentId(entityData, builder2);
            if (persistentEntityId == null) break block2;
            PersistentEntityId<?> persistentEntityId2 = persistentEntityId;
            boolean bl = false;
            boolean bl2 = false;
            PersistentEntityId<?> persistentId = persistentEntityId2;
            boolean bl3 = false;
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getPersistentIdIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(pid, persistentId);
        }
    }

    public final void updateSoftLinksIndex(@NotNull SoftLinkable softLinkable) {
        Intrinsics.checkParameterIsNotNull((Object)softLinkable, (String)"softLinkable");
        EntityId pid = ((WorkspaceEntityData)((Object)softLinkable)).createPid$intellij_platform_workspaceModel_storage();
        for (PersistentEntityId<?> link : softLinkable.getLinks()) {
            this.getSoftLinks$intellij_platform_workspaceModel_storage().put(link, (Object)pid);
        }
    }

    public final void removeFromSoftLinksIndex(@NotNull SoftLinkable softLinkable) {
        Intrinsics.checkParameterIsNotNull((Object)softLinkable, (String)"softLinkable");
        EntityId pid = ((WorkspaceEntityData)((Object)softLinkable)).createPid$intellij_platform_workspaceModel_storage();
        for (PersistentEntityId<?> link : softLinkable.getLinks()) {
            this.getSoftLinks$intellij_platform_workspaceModel_storage().remove(link, (Object)pid);
        }
    }

    public final void updateIndices(@NotNull EntityId oldEntityId, @NotNull EntityId newEntityId, @NotNull AbstractEntityStorage builder2) {
        block3: {
            Object it;
            boolean bl;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)oldEntityId, (String)"oldEntityId");
            Intrinsics.checkParameterIsNotNull((Object)newEntityId, (String)"newEntityId");
            Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
            Set<VirtualFileUrl> set = builder2.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().getVirtualFiles$intellij_platform_workspaceModel_storage(oldEntityId);
            if (set != null) {
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VirtualFileUrl it2 = (VirtualFileUrl)element$iv;
                    boolean bl2 = false;
                    this.getVirtualFileIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(newEntityId, CollectionsKt.listOf((Object)it2));
                }
            }
            EntitySource entitySource = builder2.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(oldEntityId);
            if (entitySource != null) {
                object = entitySource;
                bl = false;
                boolean bl3 = false;
                it = object;
                boolean bl4 = false;
                ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(newEntityId, it);
            }
            PersistentEntityId<?> persistentEntityId = builder2.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(oldEntityId);
            if (persistentEntityId == null) break block3;
            object = persistentEntityId;
            bl = false;
            boolean bl5 = false;
            it = object;
            boolean bl6 = false;
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getPersistentIdIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(newEntityId, it);
        }
    }

    public final void removeFromIndices(@NotNull EntityId entityId) {
        Intrinsics.checkParameterIsNotNull((Object)entityId, (String)"entityId");
        VirtualFileIndex.MutableVirtualFileIndex.index$intellij_platform_workspaceModel_storage$default(this.getVirtualFileIndex$intellij_platform_workspaceModel_storage(), entityId, null, 2, null);
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex.index$intellij_platform_workspaceModel_storage$default((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspaceModel_storage(), entityId, null, 2, null);
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex.index$intellij_platform_workspaceModel_storage$default((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getPersistentIdIndex$intellij_platform_workspaceModel_storage(), entityId, null, 2, null);
        Iterable $this$forEach$iv = this.getExternalMappings$intellij_platform_workspaceModel_storage().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableExternalEntityMappingImpl it = (MutableExternalEntityMappingImpl)element$iv;
            boolean bl = false;
            it.remove$intellij_platform_workspaceModel_storage(entityId);
        }
    }

    public final <T extends WorkspaceEntity> void simpleUpdateSoftReferences(@NotNull WorkspaceEntityData<T> copiedData) {
        Set<PersistentEntityId<?>> afterSoftLinks;
        HashSet beforeSoftLinks;
        Intrinsics.checkParameterIsNotNull(copiedData, (String)"copiedData");
        EntityId pid = copiedData.createPid$intellij_platform_workspaceModel_storage();
        if (copiedData instanceof SoftLinkable && Intrinsics.areEqual(beforeSoftLinks = new HashSet(this.getSoftLinks$intellij_platform_workspaceModel_storage().getKeys((Object)pid)), afterSoftLinks = ((SoftLinkable)((Object)copiedData)).getLinks()) ^ true) {
            PersistentEntityId it;
            Iterable $this$forEach$iv = beforeSoftLinks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PersistentEntityId)element$iv;
                boolean bl = false;
                this.getSoftLinks$intellij_platform_workspaceModel_storage().remove((Object)it, (Object)pid);
            }
            $this$forEach$iv = afterSoftLinks;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PersistentEntityId)element$iv;
                boolean bl = false;
                this.getSoftLinks$intellij_platform_workspaceModel_storage().put((Object)it, (Object)pid);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void applyExternalMappingChanges(@NotNull WorkspaceEntityStorageBuilderImpl diff, @NotNull HashBiMap<EntityId, EntityId> replaceMap) {
        String it;
        Intrinsics.checkParameterIsNotNull((Object)diff, (String)"diff");
        Intrinsics.checkParameterIsNotNull(replaceMap, (String)"replaceMap");
        Object $this$forEach$iv = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)this.getExternalMappings$intellij_platform_workspaceModel_storage().keySet()), (Function1)((Function1)new Function1<String, Boolean>(diff){
            final /* synthetic */ WorkspaceEntityStorageBuilderImpl $diff;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Map<String, MutableExternalEntityMappingImpl<?>> map2 = this.$diff.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage();
                boolean bl = false;
                Map<String, MutableExternalEntityMappingImpl<?>> map3 = map2;
                boolean bl2 = false;
                return map3.containsKey(it);
            }
            {
                this.$diff = workspaceEntityStorageBuilderImpl;
                super(1);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.getExternalMappings$intellij_platform_workspaceModel_storage().remove(it);
        }
        $this$forEach$iv = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)diff.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().keySet()), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ MutableStorageIndexes this$0;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.getExternalMappings$intellij_platform_workspaceModel_storage().keySet().contains(it);
            }
            {
                this.this$0 = mutableStorageIndexes;
                super(1);
            }
        }));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            Map<String, MutableExternalEntityMappingImpl<?>> map2 = this.getExternalMappings$intellij_platform_workspaceModel_storage();
            MutableExternalEntityMappingImpl<?> mutableExternalEntityMappingImpl = diff.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().get(it);
            if (mutableExternalEntityMappingImpl == null) {
                Intrinsics.throwNpe();
            }
            map2.put(it, MutableExternalEntityMappingImpl.Companion.from(mutableExternalEntityMappingImpl));
        }
        $this$forEach$iv = diff.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator3 = iterator2.entrySet().iterator();
        while (iterator3.hasNext()) {
            void identifier;
            Map.Entry element$iv;
            Map.Entry $dstr$identifier$index = element$iv = iterator3.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$identifier$index;
            boolean bl3 = false;
            String string = (String)entry.getKey();
            entry = $dstr$identifier$index;
            bl3 = false;
            MutableExternalEntityMappingImpl index = (MutableExternalEntityMappingImpl)entry.getValue();
            MutableExternalEntityMappingImpl<?> mutableExternalEntityMappingImpl = this.getExternalMappings$intellij_platform_workspaceModel_storage().get(identifier);
            if (mutableExternalEntityMappingImpl == null) continue;
            mutableExternalEntityMappingImpl.applyChanges(index, replaceMap);
        }
    }

    @NotNull
    public final StorageIndexes toImmutable() {
        BidirectionalMultiMap<PersistentEntityId<?>, EntityId> copiedLinks = ContainerExtensionsKt.copy(this.getSoftLinks$intellij_platform_workspaceModel_storage());
        VirtualFileIndex newVirtualFileIndex = this.getVirtualFileIndex$intellij_platform_workspaceModel_storage().toImmutable();
        EntityStorageInternalIndex<EntitySource> newEntitySourceIndex = ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspaceModel_storage()).toImmutable();
        EntityStorageInternalIndex<PersistentEntityId<?>> newPersistentIdIndex = ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getPersistentIdIndex$intellij_platform_workspaceModel_storage()).toImmutable();
        Map<String, ExternalEntityMappingImpl<?>> newExternalMappings = MutableExternalEntityMappingImpl.Companion.toImmutable(this.getExternalMappings$intellij_platform_workspaceModel_storage());
        return new StorageIndexes(copiedLinks, newVirtualFileIndex, newEntitySourceIndex, newPersistentIdIndex, newExternalMappings);
    }

    @Override
    @NotNull
    public BidirectionalMultiMap<PersistentEntityId<?>, EntityId> getSoftLinks$intellij_platform_workspaceModel_storage() {
        return this.softLinks;
    }

    @Override
    @NotNull
    public VirtualFileIndex.MutableVirtualFileIndex getVirtualFileIndex$intellij_platform_workspaceModel_storage() {
        return this.virtualFileIndex;
    }

    @NotNull
    public EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> getEntitySourceIndex$intellij_platform_workspaceModel_storage() {
        return this.entitySourceIndex;
    }

    @NotNull
    public EntityStorageInternalIndex.MutableEntityStorageInternalIndex<PersistentEntityId<?>> getPersistentIdIndex$intellij_platform_workspaceModel_storage() {
        return this.persistentIdIndex;
    }

    @NotNull
    public Map<String, MutableExternalEntityMappingImpl<?>> getExternalMappings$intellij_platform_workspaceModel_storage() {
        return this.externalMappings;
    }

    public MutableStorageIndexes(@NotNull BidirectionalMultiMap<PersistentEntityId<?>, EntityId> softLinks, @NotNull VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull EntityStorageInternalIndex.MutableEntityStorageInternalIndex<PersistentEntityId<?>> persistentIdIndex, @NotNull Map<String, MutableExternalEntityMappingImpl<?>> externalMappings) {
        Intrinsics.checkParameterIsNotNull(softLinks, (String)"softLinks");
        Intrinsics.checkParameterIsNotNull((Object)virtualFileIndex, (String)"virtualFileIndex");
        Intrinsics.checkParameterIsNotNull(entitySourceIndex, (String)"entitySourceIndex");
        Intrinsics.checkParameterIsNotNull(persistentIdIndex, (String)"persistentIdIndex");
        Intrinsics.checkParameterIsNotNull(externalMappings, (String)"externalMappings");
        super(softLinks, virtualFileIndex, (EntityStorageInternalIndex<EntitySource>)entitySourceIndex, (EntityStorageInternalIndex)persistentIdIndex, externalMappings);
        this.softLinks = softLinks;
        this.virtualFileIndex = virtualFileIndex;
        this.entitySourceIndex = entitySourceIndex;
        this.persistentIdIndex = persistentIdIndex;
        this.externalMappings = externalMappings;
    }
}

