/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

abstract class DebuggerTreeWithHistoryContainer<D> {
    private static final Logger LOG = Logger.getInstance(DebuggerTreeWithHistoryContainer.class);
    private static final int HISTORY_SIZE = 11;
    private final List<D> myHistory;
    private int myCurrentIndex;
    protected final DebuggerTreeCreator<D> myTreeCreator;
    @NotNull
    protected final Project myProject;

    protected DebuggerTreeWithHistoryContainer(@NotNull D initialItem, @NotNull DebuggerTreeCreator<D> creator, @NotNull Project project) {
        if (initialItem == null) {
            DebuggerTreeWithHistoryContainer.$$$reportNull$$$0(0);
        }
        if (creator == null) {
            DebuggerTreeWithHistoryContainer.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DebuggerTreeWithHistoryContainer.$$$reportNull$$$0(2);
        }
        this.myHistory = new ArrayList<D>();
        this.myCurrentIndex = -1;
        this.myTreeCreator = creator;
        this.myProject = project;
        this.myHistory.add(initialItem);
    }

    protected BorderLayoutPanel createMainPanel(Tree tree) {
        return this.fillMainPanel(JBUI.Panels.simplePanel(), tree);
    }

    protected BorderLayoutPanel fillMainPanel(BorderLayoutPanel mainPanel, Tree tree) {
        return mainPanel.addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)tree)).addToTop((Component)this.createToolbar((JPanel)mainPanel, tree));
    }

    private void updateTree() {
        D item = this.myHistory.get(this.myCurrentIndex);
        this.updateTree(item);
    }

    protected void updateTree(@NotNull D selectedItem) {
        if (selectedItem == null) {
            DebuggerTreeWithHistoryContainer.$$$reportNull$$$0(3);
        }
        this.updateContainer(this.myTreeCreator.createTree(selectedItem), this.myTreeCreator.getTitle(selectedItem));
    }

    protected abstract void updateContainer(Tree var1, String var2);

    protected void addToHistory(D item) {
        if (this.myCurrentIndex < 11) {
            this.myCurrentIndex = this.myCurrentIndex != -1 ? ++this.myCurrentIndex : 1;
            this.myHistory.add(this.myCurrentIndex, item);
        }
    }

    private JComponent createToolbar(JPanel parent, Tree tree) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new SetAsRootAction(tree));
        GoBackwardAction back = new GoBackwardAction();
        back.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(37, 8)), parent);
        group.add((AnAction)back);
        GoForwardAction forward = new GoForwardAction();
        forward.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(39, 8)), parent);
        group.add((AnAction)forward);
        return ActionManager.getInstance().createActionToolbar("DebuggerTreeWithHistory", (ActionGroup)group, true).getComponent();
    }

    protected static void registerTreeDisposable(Disposable disposable2, Tree tree) {
        if (tree instanceof Disposable) {
            Disposer.register((Disposable)disposable2, (Disposable)((Disposable)tree));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedItem";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SetAsRootAction
    extends AnAction {
        private final Tree myTree;

        SetAsRootAction(Tree tree) {
            super(XDebuggerBundle.message((String)"xdebugger.popup.value.tree.set.root.action.tooltip", (Object[])new Object[0]), XDebuggerBundle.message((String)"xdebugger.popup.value.tree.set.root.action.tooltip", (Object[])new Object[0]), AllIcons.Modules.UnmarkWebroot);
            this.myTree = tree;
        }

        public void update(@NotNull AnActionEvent e) {
            TreePath path;
            if (e == null) {
                SetAsRootAction.$$$reportNull$$$0(0);
            }
            boolean enabled = (path = this.myTree.getSelectionPath()) != null && path.getPathCount() > (this.myTree.isRootVisible() ? 1 : 2);
            Object component2 = this.myTree.getLastSelectedPathComponent();
            if (enabled && component2 instanceof XValueNodeImpl) {
                enabled = !((XValueNodeImpl)component2).isLeaf();
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreePath path;
            if (e == null) {
                SetAsRootAction.$$$reportNull$$$0(1);
            }
            if ((path = this.myTree.getSelectionPath()) != null) {
                Object node = path.getLastPathComponent();
                DebuggerTreeWithHistoryContainer.this.myTreeCreator.createDescriptorByNode(node, new ResultConsumer<D>(){

                    public void onSuccess(D value2) {
                        if (value2 != null) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                DebuggerTreeWithHistoryContainer.this.addToHistory(value2);
                                DebuggerTreeWithHistoryContainer.this.updateTree(value2);
                            });
                        }
                    }

                    public void onFailure(@NotNull Throwable t) {
                        if (t == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LOG.debug(t);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$SetAsRootAction$1", "onFailure"));
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$SetAsRootAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GoBackwardAction
    extends AnAction {
        GoBackwardAction() {
            super(CodeInsightBundle.messagePointer((String)"quick.definition.back", (Object[])new Object[0]), AllIcons.Actions.Back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GoBackwardAction.$$$reportNull$$$0(0);
            }
            if (DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex > 0) {
                DebuggerTreeWithHistoryContainer.this.myCurrentIndex--;
                DebuggerTreeWithHistoryContainer.this.updateTree();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoBackwardAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex > 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$GoBackwardAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GoForwardAction
    extends AnAction {
        GoForwardAction() {
            super(CodeInsightBundle.messagePointer((String)"quick.definition.forward", (Object[])new Object[0]), AllIcons.Actions.Forward);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GoForwardAction.$$$reportNull$$$0(0);
            }
            if (DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex < DebuggerTreeWithHistoryContainer.this.myHistory.size() - 1) {
                DebuggerTreeWithHistoryContainer.this.myCurrentIndex++;
                DebuggerTreeWithHistoryContainer.this.updateTree();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoForwardAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex < DebuggerTreeWithHistoryContainer.this.myHistory.size() - 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$GoForwardAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

