/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.PrimitiveValueImpl;
import com.sun.jdi.ByteValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;

public class ByteValueImpl
extends PrimitiveValueImpl
implements ByteValue {
    private final byte value;

    ByteValueImpl(VirtualMachine aVm, byte aValue) {
        super(aVm);
        this.value = aValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ByteValue) {
            return this.value == ((ByteValue)obj).value() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public int compareTo(ByteValue obj) {
        byte other = obj.value();
        return this.value() - other;
    }

    @Override
    public Type type() {
        return this.vm.theByteType();
    }

    @Override
    public byte value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    byte typeValueKey() {
        return 66;
    }
}

