/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;

public class GroovyUnnecessaryContinueInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref is unnecessary as the last statement in a loop #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyUnnecessaryContinueInspection.$$$reportNull$$$0(0);
        }
        return new UnnecessaryContinueFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection", "buildFix"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
            if (continueStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitContinueStatement(continueStatement);
            if (continueStatement.getContainingFile().getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                return;
            }
            GrStatement continuedStatement = continueStatement.findTargetStatement();
            if (continuedStatement == null) {
                return;
            }
            if (!(continuedStatement instanceof GrLoopStatement)) {
                return;
            }
            GrStatement body = ((GrLoopStatement)continuedStatement).getBody();
            if (body == null) {
                return;
            }
            if (body instanceof GrBlockStatement && ControlFlowUtils.blockCompletesWithStatement((GrBlockStatement)body, continueStatement) || !(body instanceof GrBlockStatement) && ControlFlowUtils.statementCompletesWithStatement(body, continueStatement)) {
                this.registerStatementError(continueStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "continueStatement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection$Visitor", "visitContinueStatement"));
        }
    }

    private static class UnnecessaryContinueFix
    extends GroovyFix {
        private UnnecessaryContinueFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Remove unnecessary continue";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                UnnecessaryContinueFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                UnnecessaryContinueFix.$$$reportNull$$$0(1);
            }
            PsiElement continueKeywordElement = descriptor.getPsiElement();
            GrContinueStatement continueStatement = (GrContinueStatement)continueKeywordElement.getParent();
            assert (continueStatement != null);
            continueStatement.removeStatement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection$UnnecessaryContinueFix";
            objectArray[2] = "doFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

