/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.unused.defaultParameter;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrUnusedDefaultParameterInspection
extends LocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            GrUnusedDefaultParameterInspection.$$$reportNull$$$0(0);
        }
        return new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            @Override
            public void visitExpression(@NotNull GrExpression expression) {
                PsiElement expressionParent;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((expressionParent = expression.getParent()) instanceof GrParameter)) {
                    return;
                }
                GrParameter parameter = (GrParameter)expressionParent;
                if (parameter.getInitializerGroovy() != expression) {
                    return;
                }
                PsiElement parameterParent = parameter.getParent();
                if (!(parameterParent instanceof GrParameterList)) {
                    return;
                }
                PsiElement parameterListParent = parameterParent.getParent();
                if (!(parameterListParent instanceof GrMethod)) {
                    return;
                }
                GrMethod method = (GrMethod)parameterListParent;
                if (PsiUtil.OPERATOR_METHOD_NAMES.contains(method.getName())) {
                    return;
                }
                if (GrUnusedDefaultParameterInspection.isInitializerUnused(parameter, method)) {
                    holder.registerProblem((PsiElement)expression, GroovyInspectionBundle.message("unused.default.parameter.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)expression, GroovyInspectionBundle.message("unused.default.parameter.fix", new Object[0]))});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/unused/defaultParameter/GrUnusedDefaultParameterInspection$1", "visitExpression"));
            }
        });
    }

    private static boolean isInitializerUnused(@NotNull GrParameter parameter, @NotNull GrMethod method) {
        if (parameter == null) {
            GrUnusedDefaultParameterInspection.$$$reportNull$$$0(1);
        }
        if (method == null) {
            GrUnusedDefaultParameterInspection.$$$reportNull$$$0(2);
        }
        int optionalParameterNumber = 0;
        for (GrParameter someParameter : method.getParameters()) {
            if (someParameter.isOptional()) {
                ++optionalParameterNumber;
            }
            if (someParameter == parameter) break;
        }
        GrReflectedMethod[] reflectedMethods = method.getReflectedMethods();
        for (int i = reflectedMethods.length - optionalParameterNumber; i < reflectedMethods.length; ++i) {
            GrReflectedMethod reflectedMethod = reflectedMethods[i];
            if (FindSuperElementsHelper.findSuperElements((PsiElement)reflectedMethod).length > 0) {
                return false;
            }
            if (MethodReferencesSearch.search((PsiMethod)reflectedMethod).findFirst() == null) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/unused/defaultParameter/GrUnusedDefaultParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInitializerUnused";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

