/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.compiler.options.JavaCompilersTab;
import com.intellij.compiler.server.BuildManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfigurable;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;

public class GroovyCompilerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private JPanel myMainPanel;
    private JPanel myExcludesPanel;
    private JBCheckBox myInvokeDynamicSupportCB;
    private TextFieldWithBrowseButton myConfigScriptPath;
    private JPanel myPathPanel;
    private final ExcludedEntriesConfigurable myExcludes;
    private final GroovyCompilerConfiguration myConfig;

    public GroovyCompilerConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myConfig = GroovyCompilerConfiguration.getInstance(project);
        this.myExcludes = this.createExcludedConfigurable(project);
        this.myExcludesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)GroovyBundle.message("settings.compiler.exclude.from.stub.generation", new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
    }

    public ExcludedEntriesConfigurable getExcludes() {
        return this.myExcludes;
    }

    private ExcludedEntriesConfigurable createExcludedConfigurable(@NotNull Project project) {
        if (project == null) {
            GroovyCompilerConfigurable.$$$reportNull$$$0(0);
        }
        ExcludesConfiguration configuration = this.myConfig.getExcludeFromStubGeneration();
        final ProjectFileIndex index = project.isDefault() ? null : ProjectRootManager.getInstance((Project)project).getFileIndex();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (index == null || !index.isExcluded(file));
            }
        };
        descriptor.setRoots(ContainerUtil.concat((Iterable)ContainerUtil.map((Object[])ModuleManager.getInstance((Project)project).getModules(), module -> ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.SOURCES))));
        return new ExcludedEntriesConfigurable(project, descriptor, configuration);
    }

    @NotNull
    public String getId() {
        return "Groovy compiler";
    }

    public String getDisplayName() {
        return GroovyBundle.message("configurable.GroovyCompilerConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.groovy";
    }

    public JComponent createComponent() {
        this.myExcludesPanel.add(this.myExcludes.createComponent());
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !Objects.equals(this.myConfig.getConfigScript(), this.getExternalizableConfigScript()) || this.myInvokeDynamicSupportCB.isSelected() != this.myConfig.isInvokeDynamic() || this.myExcludes.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myExcludes.apply();
        this.myConfig.setInvokeDynamic(this.myInvokeDynamicSupportCB.isSelected());
        this.myConfig.setConfigScript(this.getExternalizableConfigScript());
        BuildManager.getInstance().clearState(this.myProject);
    }

    public void reset() {
        this.myConfigScriptPath.setText(FileUtil.toSystemDependentName((String)this.myConfig.getConfigScript()));
        this.myInvokeDynamicSupportCB.setSelected(this.myConfig.isInvokeDynamic());
        this.myExcludes.reset();
    }

    public void disposeUIResources() {
        this.myExcludes.disposeUIResources();
    }

    @NotNull
    private String getExternalizableConfigScript() {
        String string = FileUtil.toSystemIndependentName((String)this.myConfigScriptPath.getText());
        if (string == null) {
            GroovyCompilerConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void createUIComponents() {
        this.myPathPanel = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultWeightX(1.0).setDefaultAnchor(21).setDefaultFill(2);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        this.myConfigScriptPath = new TextFieldWithBrowseButton();
        this.myConfigScriptPath.addBrowseFolderListener(null, GroovyBundle.message("settings.compiler.select.path.to.groovy.compiler.configscript", new Object[0]), null, descriptor);
        this.myPathPanel.add((Component)GroovyCompilerConfigurable.createTopLabel(), gb.nextLine());
        this.myPathPanel.add((Component)UI.PanelFactory.panel((JComponent)this.myConfigScriptPath).withLabel(GroovyBundle.message("settings.compiler.path.to.configscript", new Object[0])).createPanel(), gb.nextLine().insetTop(13));
        String cbText = GroovyBundle.message("settings.compiler.invoke.dynamic.support", new Object[0]);
        this.myInvokeDynamicSupportCB = new JBCheckBox(UIUtil.removeMnemonic((String)cbText));
        this.myInvokeDynamicSupportCB.setDisplayedMnemonicIndex(UIUtil.getDisplayMnemonicIndex((String)cbText));
        this.myPathPanel.add((Component)this.myInvokeDynamicSupportCB, gb.nextLine().insetTop(8));
    }

    private static JComponent createTopLabel() {
        JEditorPane tipComponent = new JEditorPane();
        tipComponent.setContentType("text/html");
        tipComponent.setEditable(false);
        tipComponent.setEditorKit(UIUtil.getHTMLEditorKit());
        EditorKit kit = tipComponent.getEditorKit();
        if (kit instanceof HTMLEditorKit) {
            StyleSheet css = ((HTMLEditorKit)kit).getStyleSheet();
            css.addRule("a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkColor()) + ";}");
            css.addRule("a:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkVisitedColor()) + ";}");
            css.addRule("a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkHoverColor()) + ";}");
            css.addRule("a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkPressedColor()) + ";}");
        }
        if (tipComponent.getCaret() instanceof DefaultCaret) {
            ((DefaultCaret)tipComponent.getCaret()).setUpdatePolicy(1);
        }
        tipComponent.setCaretPosition(0);
        tipComponent.setText(GroovyBundle.message("settings.compiler.alternative", new Object[0]));
        tipComponent.addHyperlinkListener(e -> {
            Configurable javacConfigurable;
            Settings allSettings;
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)tipComponent))) != null && (javacConfigurable = allSettings.find(JavaCompilersTab.class)) != null) {
                allSettings.select(javacConfigurable);
            }
        });
        tipComponent.setBorder(null);
        tipComponent.setOpaque(false);
        return tipComponent;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = this.myPathPanel;
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExcludesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/compiler/GroovyCompilerConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/compiler/GroovyCompilerConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalizableConfigScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedConfigurable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

