/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;
import org.jetbrains.plugins.groovy.config.GroovyLibraryProperties;
import org.jetbrains.plugins.groovy.gant.GantUtils;

public class GantLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    private static final LibraryKind GANT_KIND = LibraryKind.create((String)"gant");

    public GantLibraryPresentationProvider() {
        super(GANT_KIND);
    }

    @Override
    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return GantUtils.isGantLibrary(libraryFiles);
    }

    @Override
    @Nls
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        return GantUtils.getGantVersion(GantUtils.getGantLibraryHome(libraryFiles));
    }

    @Override
    @NotNull
    public Icon getIcon(GroovyLibraryProperties properties) {
        Icon icon = JetgroovyIcons.Groovy.Gant_sdk;
        if (icon == null) {
            GantLibraryPresentationProvider.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            GantLibraryPresentationProvider.$$$reportNull$$$0(1);
        }
        return GantUtils.isGantSdkHome(file);
    }

    @Override
    @NotNull
    public String getSDKVersion(String path) {
        String string = GantUtils.getGantVersion(path);
        if (string == null) {
            GantLibraryPresentationProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        return "Gant";
    }

    @Override
    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File lib;
        File[] jars;
        File srcRoot = new File(path + "/src/main");
        if (srcRoot.exists()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)srcRoot), OrderRootType.SOURCES);
        }
        File[] fileArray = jars = (lib = new File(path + "/lib")).exists() ? lib.listFiles() : new File[]{};
        if (jars != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/gant/GantLibraryPresentationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/gant/GantLibraryPresentationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSDKVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSDKHome";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

