/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gpp;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;

public class GppClosureParameterTypeProvider
extends AbstractClosureParameterEnhancer {
    @Override
    protected PsiType getClosureParameterType(@NotNull GrFunctionalExpression expression, int index) {
        Pair<PsiMethod, PsiSubstitutor> pair;
        PsiElement parent2;
        if (expression == null) {
            GppClosureParameterTypeProvider.$$$reportNull$$$0(0);
        }
        if ((parent2 = expression.getParent()) instanceof GrNamedArgument && (pair = GppClosureParameterTypeProvider.getOverriddenMethod((GrNamedArgument)parent2)) != null) {
            PsiParameter[] parameters2 = ((PsiMethod)pair.first).getParameterList().getParameters();
            if (parameters2.length > index) {
                return ((PsiSubstitutor)pair.second).substitute(parameters2[index].getType());
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static Pair<PsiMethod, PsiSubstitutor> getOverriddenMethod(GrNamedArgument namedArgument) {
        return (Pair)ContainerUtil.getFirstItem(GppClosureParameterTypeProvider.getOverriddenMethodVariants(namedArgument), null);
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getOverriddenMethodVariants(GrNamedArgument namedArgument) {
        GrArgumentLabel label = namedArgument.getLabel();
        if (label == null) {
            List<Pair<PsiMethod, PsiSubstitutor>> list = Collections.emptyList();
            if (list == null) {
                GppClosureParameterTypeProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        String methodName = label.getName();
        if (methodName == null) {
            List<Pair<PsiMethod, PsiSubstitutor>> list = Collections.emptyList();
            if (list == null) {
                GppClosureParameterTypeProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiElement map2 = namedArgument.getParent();
        if (map2 instanceof GrListOrMap && ((GrListOrMap)map2).isMap()) {
            for (PsiType expected : GroovyExpectedTypesProvider.getDefaultExpectedTypes((GrExpression)map2)) {
                if (!(expected instanceof PsiClassType)) continue;
                List<Pair<PsiMethod, PsiSubstitutor>> pairs = GppClosureParameterTypeProvider.getMethodsToOverrideImplementInInheritor((PsiClassType)expected, false);
                List list = ContainerUtil.findAll(pairs, pair -> methodName.equals(((PsiMethod)pair.first).getName()));
                if (list == null) {
                    GppClosureParameterTypeProvider.$$$reportNull$$$0(3);
                }
                return list;
            }
        }
        List<Pair<PsiMethod, PsiSubstitutor>> list = Collections.emptyList();
        if (list == null) {
            GppClosureParameterTypeProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static PsiType[] getParameterTypes(Pair<PsiMethod, PsiSubstitutor> pair) {
        return (PsiType[])ContainerUtil.map2Array((Object[])((PsiMethod)pair.first).getParameterList().getParameters(), PsiType.class, psiParameter -> ((PsiSubstitutor)pair.second).substitute(psiParameter.getType()));
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getMethodsToOverrideImplementInInheritor(PsiClassType classType, boolean toImplement) {
        PsiClassType.ClassResolveResult resolveResult2 = classType.resolveGenerics();
        PsiClass psiClass = resolveResult2.getElement();
        if (psiClass == null) {
            List<Pair<PsiMethod, PsiSubstitutor>> list = Collections.emptyList();
            if (list == null) {
                GppClosureParameterTypeProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> over = GppClosureParameterTypeProvider.getMethodsToOverrideImplement(psiClass, false);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> impl = GppClosureParameterTypeProvider.getMethodsToOverrideImplement(psiClass, true);
        for (PsiMethod method : psiClass.getMethods()) {
            (method.hasModifierProperty("abstract") ? impl : over).add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)method, (Object)PsiSubstitutor.EMPTY));
        }
        Iterator iterator2 = impl.iterator();
        while (iterator2.hasNext()) {
            Pair pair = (Pair)iterator2.next();
            if (!GppClosureParameterTypeProvider.hasTraitImplementation((PsiMethod)pair.first)) continue;
            iterator2.remove();
            over.add((Pair<PsiMethod, PsiSubstitutor>)pair);
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result2 = toImplement ? impl : over;
        int resultSize = result2.size();
        for (int i = 0; i < resultSize; ++i) {
            Pair pair = (Pair)result2.get(i);
            result2.set(i, (Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)pair.first), (Object)resolveResult2.getSubstitutor().putAll((PsiSubstitutor)pair.second)));
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = result2;
        if (arrayList == null) {
            GppClosureParameterTypeProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static ArrayList<Pair<PsiMethod, PsiSubstitutor>> getMethodsToOverrideImplement(PsiClass psiClass, boolean toImplement) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result2 = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (CandidateInfo info : OverrideImplementExploreUtil.getMethodsToOverrideImplement((PsiClass)psiClass, (boolean)toImplement)) {
            result2.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)info.getElement()), (Object)info.getSubstitutor()));
        }
        return result2;
    }

    private static boolean hasTraitImplementation(PsiMethod method) {
        return method.getModifierList().hasAnnotation("org.mbte.groovypp.runtime.HasDefaultImplementation");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/gpp/GppClosureParameterTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/gpp/GppClosureParameterTypeProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenMethodVariants";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsToOverrideImplementInInheritor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClosureParameterType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

