/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.style.InferMethodParametersTypesIntention;
import org.jetbrains.plugins.groovy.intentions.style.inference.DefaultInferenceContext;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceOptions;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriverUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/InferMethodParametersTypesIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "()V", "collectParameterSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "virtualMethod", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "getFamilyName", "", "getText", "isStopElement", "", "element", "Lcom/intellij/psi/PsiElement;", "processIntention", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "substituteMethodSignature", "sourceMethod", "sinkMethod", "intellij.groovy"})
public final class InferMethodParametersTypesIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GrMethod method = (GrMethod)element;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
        SignatureInferenceOptions options2 = new SignatureInferenceOptions((SearchScope)globalSearchScope, false, DefaultInferenceContext.INSTANCE, (Lazy<? extends List<? extends PsiReference>>)LazyKt.lazy((Function0)processIntention.options.1.INSTANCE));
        GrMethod virtualMethod = InferenceProcessKt.runInferenceProcess(method, options2);
        this.substituteMethodSignature(virtualMethod, method);
    }

    /*
     * WARNING - void declaration
     */
    private final void substituteMethodSignature(GrMethod sourceMethod, GrMethod sinkMethod) {
        block24: {
            Object object;
            block26: {
                block25: {
                    PsiAnnotation[] it;
                    if (!sinkMethod.isConstructor() && !sinkMethod.getModifierList().hasModifierProperty("def")) {
                        sinkMethod.getModifierList().setModifierProperty("def", true);
                    }
                    if (sourceMethod.hasTypeParameters()) {
                        if (sinkMethod.hasTypeParameters()) {
                            PsiTypeParameterList psiTypeParameterList = sinkMethod.getTypeParameterList();
                            if (psiTypeParameterList == null) {
                                Intrinsics.throwNpe();
                            }
                            PsiTypeParameterList psiTypeParameterList2 = sourceMethod.getTypeParameterList();
                            if (psiTypeParameterList2 == null) {
                                Intrinsics.throwNpe();
                            }
                            psiTypeParameterList.replace((PsiElement)psiTypeParameterList2);
                        } else if (sinkMethod.isConstructor()) {
                            PsiSubstitutor parameterSubstitutor = this.collectParameterSubstitutor(sourceMethod);
                            GrParameter[] grParameterArray = sourceMethod.getParameters();
                            Intrinsics.checkExpressionValueIsNotNull((Object)grParameterArray, (String)"sourceMethod.parameters");
                            GrParameter[] $this$forEach$iv = grParameterArray;
                            boolean $i$f$forEach = false;
                            GrParameter[] grParameterArray2 = $this$forEach$iv;
                            int n = grParameterArray2.length;
                            for (int i = 0; i < n; ++i) {
                                PsiAnnotation[] element$iv;
                                it = element$iv = grParameterArray2[i];
                                boolean bl = false;
                                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                                PsiType psiType = it.getType();
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"it.type");
                                it.setType(InferenceProcessUtilKt.recursiveSubstitute$default(parameterSubstitutor, psiType, 0, 2, null));
                            }
                        } else {
                            PsiTypeParameterList psiTypeParameterList = sourceMethod.getTypeParameterList();
                            if (psiTypeParameterList == null) {
                                Intrinsics.throwNpe();
                            }
                            sinkMethod.addAfter((PsiElement)psiTypeParameterList, sinkMethod.getFirstChild());
                        }
                    }
                    Object[] objectArray = sinkMethod.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"sinkMethod.parameters");
                    Object[] objectArray2 = sourceMethod.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"sourceMethod.parameters");
                    for (PsiSubstitutor parameterSubstitutor : ArraysKt.zip((Object[])objectArray, (Object[])objectArray2)) {
                        PsiAnnotation[] $this$forEach$iv;
                        PsiAnnotation[] $this$mapTo$iv$iv;
                        PsiAnnotation[] $this$map$iv;
                        void actual;
                        GrParameter inferred;
                        GrParameter $i$f$forEach = (GrParameter)parameterSubstitutor.component1();
                        GrParameter grParameter = inferred = (GrParameter)parameterSubstitutor.component2();
                        Intrinsics.checkExpressionValueIsNotNull((Object)grParameter, (String)"inferred");
                        actual.setType(grParameter.getType());
                        void v8 = actual;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"actual");
                        v8.getModifierList().setModifierProperty("def", false);
                        if (actual.isVarArgs()) {
                            PsiElement psiElement = actual.getEllipsisDots();
                            if (psiElement == null) {
                                Intrinsics.throwNpe();
                            }
                            psiElement.delete();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)actual.getAnnotations(), (String)"actual.annotations");
                        boolean $i$f$map = false;
                        it = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        void var13_27 = $this$mapTo$iv$iv;
                        int n = ((void)var13_27).length;
                        for (int i = 0; i < n; ++i) {
                            void it2;
                            void item$iv$iv;
                            void var17_32 = item$iv$iv = var13_27[i];
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            void v10 = it2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                            String string = v10.getText();
                            collection.add(string);
                        }
                        List currentAnnotations = (List)destination$iv$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)inferred.getAnnotations(), (String)"inferred.annotations");
                        boolean $i$f$forEach2 = false;
                        $this$mapTo$iv$iv = $this$forEach$iv;
                        int n2 = $this$mapTo$iv$iv.length;
                        for (int i = 0; i < n2; ++i) {
                            PsiAnnotation anno;
                            String string;
                            String string2;
                            PsiAnnotation element$iv;
                            PsiAnnotation it3 = element$iv = $this$mapTo$iv$iv[i];
                            boolean bl = false;
                            PsiAnnotation psiAnnotation = it3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"it");
                            if (currentAnnotations.contains(psiAnnotation.getText())) continue;
                            GrModifierList grModifierList = actual.getModifierList();
                            Intrinsics.checkExpressionValueIsNotNull((Object)it3.getText(), (String)"it.text");
                            int n3 = 1;
                            GrModifierList grModifierList2 = grModifierList;
                            boolean bl2 = false;
                            String string3 = string2;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                            Intrinsics.checkExpressionValueIsNotNull((Object)grModifierList2.addAnnotation(string), (String)"actual.modifierList.addA\u2026ion(it.text.substring(1))");
                            PsiAnnotation psiAnnotation2 = anno;
                            if (psiAnnotation2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation");
                            }
                            PsiElement psiElement = ((GrAnnotation)psiAnnotation2).getOriginalElement();
                            if (psiElement == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement");
                            }
                            GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)psiElement);
                            PsiAnnotationMemberValue psiAnnotationMemberValue = anno.findAttributeValue("value");
                            Object object2 = psiAnnotationMemberValue != null ? psiAnnotationMemberValue.getReference() : null;
                            if (!(object2 instanceof GrQualifiedReference)) {
                                object2 = null;
                            }
                            GrQualifiedReference grQualifiedReference = (GrQualifiedReference)object2;
                            if (grQualifiedReference == null) {
                                continue;
                            }
                            GrReferenceAdjuster.shortenReference(grQualifiedReference);
                        }
                    }
                    PsiTypeParameter[] psiTypeParameterArray = sinkMethod.getTypeParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterArray, (String)"sinkMethod.typeParameters");
                    PsiTypeParameter[] $this$forEach$iv = psiTypeParameterArray;
                    boolean $i$f$forEach = false;
                    PsiTypeParameter[] psiTypeParameterArray2 = $this$forEach$iv;
                    int n = psiTypeParameterArray2.length;
                    for (int currentAnnotations = 0; currentAnnotations < n; ++currentAnnotations) {
                        PsiTypeParameter element$iv;
                        PsiTypeParameter it4 = element$iv = psiTypeParameterArray2[currentAnnotations];
                        boolean bl = false;
                        PsiTypeParameter psiTypeParameter = it4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameter, (String)"it");
                        GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)psiTypeParameter.getOriginalElement());
                    }
                    if (sinkMethod.isConstructor() || sinkMethod.getReturnTypeElement() != null) break block24;
                    object = sinkMethod.getInferredReturnType();
                    if (object == null) break block25;
                    PsiType psiType = object;
                    boolean bl = false;
                    n = 0;
                    PsiType it5 = psiType;
                    boolean bl3 = false;
                    object = Intrinsics.areEqual((Object)it5, (Object)PsiType.NULL) ^ true ? psiType : null;
                    if (object != null) break block26;
                }
                object = (PsiType)InferenceDriverUtilKt.getJavaLangObject(sinkMethod);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sinkMethod.inferredRetur\u2026avaLangObject(sinkMethod)");
            PsiType returnType2 = object;
            GrReferenceAdjuster.shortenAllReferencesIn(sinkMethod.setReturnType(returnType2));
        }
        sinkMethod.getModifierList().setModifierProperty("def", false);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiSubstitutor collectParameterSubstitutor(GrMethod virtualMethod) {
        void $this$toTypedArray$iv;
        PsiClassType psiClassType;
        Collection collection;
        void $this$mapTo$iv$iv;
        PsiTypeParameter[] psiTypeParameterArray = virtualMethod.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterArray, (String)"virtualMethod.typeParameters");
        Object $this$map$iv = psiTypeParameterArray;
        boolean $i$f$map = false;
        PsiTypeParameter[] psiTypeParameterArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((PsiTypeParameter[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var8_7 = $this$mapTo$iv$iv;
        int n = ((void)var8_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_11 = item$iv$iv = var8_7[i];
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Object[] objectArray = v1.getExtendsListTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.extendsListTypes");
            PsiClassType psiClassType2 = (PsiClassType)ArraysKt.firstOrNull((Object[])objectArray);
            if (psiClassType2 == null) {
                psiClassType2 = InferenceDriverUtilKt.getJavaLangObject(virtualMethod);
            }
            psiClassType = psiClassType2;
            collection.add(psiClassType);
        }
        List parameterTypes = (List)destination$iv$iv;
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        PsiClassType psiClassType3 = virtualMethod.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType3, (String)"virtualMethod.typeParameters");
        $this$map$iv = parameterTypes;
        psiClassType = psiClassType3;
        collection = psiSubstitutor;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        PsiClassType[] psiClassTypeArray = thisCollection$iv.toArray(new PsiClassType[0]);
        if (psiClassTypeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        PsiClassType[] psiClassTypeArray2 = psiClassTypeArray;
        return InferenceKt.putAll((PsiSubstitutor)collection, (PsiTypeParameter[])psiClassType, (PsiType[])psiClassTypeArray2);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return getElementPredicate.1.INSTANCE;
    }

    @Override
    protected boolean isStopElement(@Nullable PsiElement element) {
        return element instanceof GrOpenBlock || element instanceof GrMethod || super.isStopElement(element);
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyIntentionsBundle.message("infer.method.parameters.types", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyIntentionsBundle.m\u2026method.parameters.types\")");
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message("infer.method.parameters.types.for.method.declaration", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyIntentionsBundle.m\u2026.for.method.declaration\")");
        return string;
    }
}

