/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrRangeType
extends GrLiteralClassType {
    @Nullable
    private final PsiType myLeft;
    @Nullable
    private final PsiType myRight;
    private final PsiType myIterationType;
    private final String myQualifiedName;
    private final PsiType[] myParameters;

    public GrRangeType(@NotNull LanguageLevel languageLevel, GlobalSearchScope scope, JavaPsiFacade facade, @Nullable PsiType left, @Nullable PsiType right) {
        if (languageLevel == null) {
            GrRangeType.$$$reportNull$$$0(0);
        }
        super(languageLevel, scope, facade);
        this.myLeft = left;
        this.myRight = right;
        this.myIterationType = TypesUtil.boxPrimitiveType(TypesUtil.getLeastUpperBoundNullable(this.myLeft, this.myRight, this.getPsiManager()), this.getPsiManager(), scope);
        this.myQualifiedName = PsiType.INT.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(this.myIterationType)) ? "groovy.lang.IntRange" : "groovy.lang.Range";
        this.myParameters = this.inferParameters();
    }

    public GrRangeType(GlobalSearchScope scope, JavaPsiFacade facade, @Nullable PsiType left, @Nullable PsiType right) {
        this(LanguageLevel.JDK_1_5, scope, facade, left, right);
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        String string = this.myQualifiedName;
        if (string == null) {
            GrRangeType.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiType @NotNull [] getParameters() {
        if (this.myParameters == null) {
            GrRangeType.$$$reportNull$$$0(2);
        }
        return this.myParameters;
    }

    private PsiType[] inferParameters() {
        if (this.myIterationType == null) {
            return EMPTY_ARRAY;
        }
        PsiClass resolved = this.resolve();
        if (resolved == null || resolved.getTypeParameters().length == 0) {
            return EMPTY_ARRAY;
        }
        return new PsiType[]{this.myIterationType};
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            GrRangeType.$$$reportNull$$$0(3);
        }
        return new GrRangeType(languageLevel, this.myScope, this.myFacade, this.myLeft, this.myRight);
    }

    @NotNull
    public String getInternalCanonicalText() {
        String string = "[" + (this.myLeft == null ? "null" : this.myLeft.getInternalCanonicalText()) + ".." + (this.myRight == null ? "null" : this.myRight.getInternalCanonicalText()) + "]";
        if (string == null) {
            GrRangeType.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isValid() {
        return !(this.myLeft != null && !this.myLeft.isValid() || this.myRight != null && !this.myRight.isValid());
    }

    @Nullable
    public PsiType getIterationType() {
        return this.myIterationType;
    }

    @Nullable
    public PsiType getLeft() {
        return this.myLeft;
    }

    @Nullable
    public PsiType getRight() {
        return this.myRight;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrRangeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrRangeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

