/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.util.GroovySelectModuleStep;
import org.jetbrains.plugins.groovy.util.LogicKt;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;
import org.jetbrains.plugins.groovy.util.RightTextCellRenderer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\n\u001a8\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\nH\u0002\u001a(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\b\u001a\"\u0010\u0017\u001a\u00020\u00162\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012\u001a\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\b\u001a+\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\n2\u0014\b\u0004\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\nH\u0082\b\u001a>\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"GROOVY_LAST_MODULE", "", "createSelectModulePopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "modules", "", "Lcom/intellij/openapi/module/Module;", "version", "Lkotlin/Function1;", "consumer", "", "createSelectModulePopupStep", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "filterGroovyCompatibleModules", "", "condition", "Lcom/intellij/openapi/util/Condition;", "formatModuleVersion", "module", "hasAcceptableModuleType", "", "hasGroovyCompatibleModules", "hasJavaSdk", "isGroovyCompatibleModule", "selectModule", "Lcom/intellij/util/Function;", "Lcom/intellij/util/Consumer;", "intellij.groovy"})
@JvmName(name="ModuleChooserUtil")
public final class ModuleChooserUtil {
    private static final String GROOVY_LAST_MODULE = "Groovy.Last.Module.Chosen";

    public static final void selectModule(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<Module, String> version, @NotNull Consumer<Module> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
        Intrinsics.checkParameterIsNotNull(version, (String)"version");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        Module module = (Module)CollectionsKt.singleOrNull(modules);
        if (module != null) {
            Module module2 = module;
            boolean bl = false;
            boolean bl2 = false;
            Module it = module2;
            boolean bl3 = false;
            consumer.consume((Object)it);
            return;
        }
        ModuleChooserUtil.createSelectModulePopup(project, modules, (Function1<? super Module, String>)((Function1)new Function1<Module, String>(version){

            public final String invoke(Module p1) {
                return (String)((Function)this.receiver).fun((Object)p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Function.class);
            }

            public final String getName() {
                return "fun";
            }

            public final String getSignature() {
                return "fun(Ljava/lang/Object;)Ljava/lang/Object;";
            }
        }), (Function1<? super Module, Unit>)((Function1)new Function1<Module, Unit>(consumer){

            public final void invoke(Module p1) {
                ((Consumer)this.receiver).consume((Object)p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Consumer.class);
            }

            public final String getName() {
                return "consume";
            }

            public final String getSignature() {
                return "consume(Ljava/lang/Object;)V";
            }
        })).showCenteredInCurrentWindow(project);
    }

    @NotNull
    public static final ListPopup createSelectModulePopup(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function1<? super Module, String> version, @NotNull Function1<? super Module, Unit> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
        Intrinsics.checkParameterIsNotNull(version, (String)"version");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        Iterable iterable = modules;
        ModulesAlphaComparator modulesAlphaComparator = ModulesAlphaComparator.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)modulesAlphaComparator, (String)"ModulesAlphaComparator.INSTANCE");
        ListPopupStep<Module> step2 = ModuleChooserUtil.createSelectModulePopupStep(project, CollectionsKt.sortedWith((Iterable)iterable, (Comparator)((Comparator)modulesAlphaComparator)), consumer);
        return (ListPopup)new ListPopupImpl(version, project, step2, project, step2){
            final /* synthetic */ Function1 $version;
            final /* synthetic */ Project $project;
            final /* synthetic */ ListPopupStep $step;

            @NotNull
            protected RightTextCellRenderer<Module> getListElementRenderer() {
                ListCellRenderer listCellRenderer = super.getListElementRenderer();
                Intrinsics.checkExpressionValueIsNotNull((Object)listCellRenderer, (String)"super.getListElementRenderer()");
                return new RightTextCellRenderer<Module>(listCellRenderer, this.$version);
            }
            {
                this.$version = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$step = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final ListPopupStep<Module> createSelectModulePopupStep(Project project, List<? extends Module> modules, Function1<? super Module, Unit> consumer) {
        GroovySelectModuleStep step2;
        block3: {
            int n;
            GroovySelectModuleStep groovySelectModuleStep;
            block2: {
                void $this$indexOfFirst$iv;
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
                step2 = new GroovySelectModuleStep(modules, (Function1<? super Module, Unit>)((Function1)new Function1<Module, Unit>(propertiesComponent, consumer){
                    final /* synthetic */ PropertiesComponent $propertiesComponent;
                    final /* synthetic */ Function1 $consumer;

                    public final void invoke(@NotNull Module it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$propertiesComponent.setValue("Groovy.Last.Module.Chosen", it.getName());
                        this.$consumer.invoke((Object)it);
                    }
                    {
                        this.$propertiesComponent = propertiesComponent;
                        this.$consumer = function1;
                        super(1);
                    }
                }));
                String string = propertiesComponent.getValue(GROOVY_LAST_MODULE);
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String lastModuleName = string2;
                boolean bl3 = false;
                List<? extends Module> list = modules;
                groovySelectModuleStep = step2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    Module it = (Module)item$iv;
                    boolean bl4 = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)lastModuleName)) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int n2 = n;
            groovySelectModuleStep.setDefaultOptionIndex(n2);
        }
        return (ListPopupStep)step2;
    }

    @NotNull
    public static final String formatModuleVersion(@NotNull Module module, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return module.getName() + " (" + version + ')';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> filterGroovyCompatibleModules(@NotNull Collection<? extends Module> modules, @NotNull Condition<Module> condition) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        Iterable iterable = modules;
        Function1<Module, Boolean> condition$iv = LogicKt.toPredicate(condition);
        boolean $i$f$isGroovyCompatibleModule = false;
        Function1 $this$and$iv$iv = isGroovyCompatibleModule.1.INSTANCE;
        boolean $i$f$and = false;
        Function1 predicate$iv = new Function1<T, Boolean>($this$and$iv$iv, condition$iv){
            final /* synthetic */ Function1 $this_and;
            final /* synthetic */ Function1 $another;

            public final boolean invoke(T it) {
                return (Boolean)this.$this_and.invoke(it) != false && (Boolean)this.$another.invoke(it) != false;
            }
            {
                this.$this_and = function1;
                this.$another = function12;
                super(1);
            }
        };
        boolean $i$f$filter = false;
        $this$and$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean hasGroovyCompatibleModules(@NotNull Collection<? extends Module> modules, @NotNull Condition<Module> condition) {
        boolean bl;
        block3: {
            void $this$any$iv;
            Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
            Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
            Iterable iterable = modules;
            Function1<Module, Boolean> condition$iv = LogicKt.toPredicate(condition);
            boolean $i$f$isGroovyCompatibleModule = false;
            Function1 $this$and$iv$iv = isGroovyCompatibleModule.1.INSTANCE;
            boolean $i$f$and = false;
            Function1 predicate$iv = new /* invalid duplicate definition of identical inner class */;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    if (!((Boolean)predicate$iv.invoke(element$iv)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Function1<Module, Boolean> isGroovyCompatibleModule(Function1<? super Module, Boolean> condition) {
        int $i$f$isGroovyCompatibleModule = 0;
        Function1 $this$and$iv = isGroovyCompatibleModule.1.INSTANCE;
        boolean $i$f$and = false;
        return new /* invalid duplicate definition of identical inner class */;
    }

    public static final boolean hasJavaSdk(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        Sdk sdk = moduleRootManager.getSdk();
        return (sdk != null ? sdk.getSdkType() : null) instanceof JavaSdkType;
    }

    public static final boolean hasAcceptableModuleType(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return GroovyFacetUtil.isAcceptableModuleType(ModuleType.get((Module)module));
    }
}

