/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.impldep.org.eclipse.jgit.annotations.Nullable;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.ReftableBatchRefUpdate;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.ReftableStack;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.BatchRefUpdate;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.NullProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.ReceiveCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.util.RefList;
import org.gradle.internal.impldep.org.eclipse.jgit.util.RefMap;

public class DfsReftableDatabase
extends DfsRefDatabase {
    private final ReentrantLock lock = new ReentrantLock(true);
    private DfsReader ctx;
    private ReftableStack tableStack;
    private MergedReftable mergedTables;

    protected DfsReftableDatabase(DfsRepository repo) {
        super(repo);
    }

    @Override
    public boolean hasVersioning() {
        return true;
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    @Override
    public BatchRefUpdate newBatchUpdate() {
        DfsObjDatabase odb = this.getRepository().getObjectDatabase();
        return new ReftableBatchRefUpdate(this, odb);
    }

    public ReftableConfig getReftableConfig() {
        return new ReftableConfig(this.getRepository().getConfig());
    }

    protected ReentrantLock getLock() {
        return this.lock;
    }

    protected boolean compactDuringCommit() {
        return true;
    }

    protected Reftable reader() throws IOException {
        this.lock.lock();
        try {
            if (this.mergedTables == null) {
                this.mergedTables = new MergedReftable(this.stack().readers());
            }
            MergedReftable mergedReftable = this.mergedTables;
            return mergedReftable;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ReftableStack stack() throws IOException {
        this.lock.lock();
        try {
            if (this.tableStack == null) {
                DfsObjDatabase odb = this.getRepository().getObjectDatabase();
                if (this.ctx == null) {
                    this.ctx = odb.newReader();
                }
                this.tableStack = ReftableStack.open(this.ctx, Arrays.asList(odb.getReftables()));
            }
            ReftableStack reftableStack = this.tableStack;
            return reftableStack;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isNameConflicting(String refName) throws IOException {
        this.lock.lock();
        try {
            Reftable table = this.reader();
            int lastSlash = refName.lastIndexOf(47);
            while (lastSlash > 0) {
                if (table.hasRef(refName.substring(0, lastSlash))) {
                    return true;
                }
                lastSlash = refName.lastIndexOf(47, lastSlash - 1);
            }
            boolean bl = table.hasRefsWithPrefix(String.valueOf(refName) + '/');
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Ref exactRef(String name) throws IOException {
        this.lock.lock();
        try {
            Reftable table = this.reader();
            Ref ref = table.exactRef(name);
            if (ref != null && ref.isSymbolic()) {
                Ref ref2 = table.resolve(ref);
                return ref2;
            }
            Ref ref3 = ref;
            return ref3;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        RefList.Builder<Ref> all = new RefList.Builder<Ref>();
        this.lock.lock();
        try {
            Reftable table = this.reader();
            Throwable throwable = null;
            Object var5_6 = null;
            try (RefCursor rc = "".equals(prefix) ? table.allRefs() : (prefix.endsWith("/") ? table.seekRefsWithPrefix(prefix) : table.seekRef(prefix));){
                while (rc.next()) {
                    Ref ref = table.resolve(rc.getRef());
                    if (ref == null || ref.getObjectId() == null) continue;
                    all.add(ref);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
        RefList none = RefList.emptyList();
        return new RefMap(prefix, all.toRefList(), none, none);
    }

    @Override
    public List<Ref> getRefsByPrefix(String prefix) throws IOException {
        ArrayList<Ref> all = new ArrayList<Ref>();
        this.lock.lock();
        try {
            Reftable table = this.reader();
            Throwable throwable = null;
            Object var5_6 = null;
            try (RefCursor rc = "".equals(prefix) ? table.allRefs() : table.seekRefsWithPrefix(prefix);){
                while (rc.next()) {
                    Ref ref = table.resolve(rc.getRef());
                    if (ref == null || ref.getObjectId() == null) continue;
                    all.add(ref);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
        return Collections.unmodifiableList(all);
    }

    @Override
    public Set<Ref> getTipsWithSha1(ObjectId id) throws IOException {
        if (!this.getReftableConfig().isIndexObjects()) {
            return super.getTipsWithSha1(id);
        }
        this.lock.lock();
        try {
            RefCursor cursor = this.reader().byObjectId(id);
            HashSet<Ref> refs = new HashSet<Ref>();
            while (cursor.next()) {
                refs.add(cursor.getRef());
            }
            HashSet<Ref> hashSet = refs;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Ref peel(Ref ref) throws IOException {
        Ref oldLeaf = ref.getLeaf();
        if (oldLeaf.isPeeled() || oldLeaf.getObjectId() == null) {
            return ref;
        }
        return DfsReftableDatabase.recreate(ref, this.doPeel(oldLeaf), this.hasVersioning());
    }

    @Override
    boolean exists() throws IOException {
        DfsObjDatabase odb = this.getRepository().getObjectDatabase();
        return odb.getReftables().length > 0;
    }

    @Override
    void clearCache() {
        this.lock.lock();
        try {
            if (this.tableStack != null) {
                this.tableStack.close();
                this.tableStack = null;
            }
            if (this.ctx != null) {
                this.ctx.close();
                this.ctx = null;
            }
            this.mergedTables = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected boolean compareAndPut(Ref oldRef, @Nullable Ref newRef) throws IOException {
        ReceiveCommand cmd = DfsReftableDatabase.toCommand(oldRef, newRef);
        Throwable throwable = null;
        Object var5_6 = null;
        try (RevWalk rw = new RevWalk(this.getRepository());){
            rw.setRetainBody(false);
            this.newBatchUpdate().setAllowNonFastForwards(true).addCommand(cmd).execute(rw, NullProgressMonitor.INSTANCE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        switch (cmd.getResult()) {
            case OK: {
                return true;
            }
            case REJECTED_OTHER_REASON: {
                throw new IOException(cmd.getMessage());
            }
        }
        return false;
    }

    private static ReceiveCommand toCommand(Ref oldRef, Ref newRef) {
        ObjectId oldId = DfsReftableDatabase.toId(oldRef);
        ObjectId newId = DfsReftableDatabase.toId(newRef);
        String name = DfsReftableDatabase.toName(oldRef, newRef);
        if (oldRef != null && oldRef.isSymbolic()) {
            if (newRef != null) {
                if (newRef.isSymbolic()) {
                    return ReceiveCommand.link(oldRef.getTarget().getName(), newRef.getTarget().getName(), name);
                }
                return ReceiveCommand.unlink(oldRef.getTarget().getName(), newId, name);
            }
            return ReceiveCommand.unlink(oldRef.getTarget().getName(), ObjectId.zeroId(), name);
        }
        if (newRef != null && newRef.isSymbolic()) {
            if (oldRef != null) {
                if (oldRef.isSymbolic()) {
                    return ReceiveCommand.link(oldRef.getTarget().getName(), newRef.getTarget().getName(), name);
                }
                return ReceiveCommand.link(oldId, newRef.getTarget().getName(), name);
            }
            return ReceiveCommand.link(ObjectId.zeroId(), newRef.getTarget().getName(), name);
        }
        return new ReceiveCommand(oldId, newId, name);
    }

    private static ObjectId toId(Ref ref) {
        ObjectId id;
        if (ref != null && (id = ref.getObjectId()) != null) {
            return id;
        }
        return ObjectId.zeroId();
    }

    private static String toName(Ref oldRef, Ref newRef) {
        return oldRef != null ? oldRef.getName() : newRef.getName();
    }

    @Override
    protected boolean compareAndRemove(Ref oldRef) throws IOException {
        return this.compareAndPut(oldRef, null);
    }

    @Override
    protected DfsRefDatabase.RefCache scanAllRefs() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void stored(Ref ref) {
    }

    @Override
    void removed(String refName) {
    }

    @Override
    protected void cachePeeledState(Ref oldLeaf, Ref newLeaf) {
    }
}

