/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import java.io.IOException;
import org.gradle.internal.impldep.org.simpleframework.http.core.ChunkedProducer;
import org.gradle.internal.impldep.org.simpleframework.http.core.CloseProducer;
import org.gradle.internal.impldep.org.simpleframework.http.core.Conversation;
import org.gradle.internal.impldep.org.simpleframework.http.core.EmptyProducer;
import org.gradle.internal.impldep.org.simpleframework.http.core.FixedProducer;
import org.gradle.internal.impldep.org.simpleframework.http.core.Monitor;
import org.gradle.internal.impldep.org.simpleframework.http.core.Producer;
import org.gradle.internal.impldep.org.simpleframework.http.core.Sender;

class ProducerFactory {
    private final Conversation support;
    private final Monitor monitor;
    private final Sender sender;

    public ProducerFactory(Conversation support, Sender sender, Monitor monitor) {
        this.support = support;
        this.sender = sender;
        this.monitor = monitor;
    }

    public Producer getInstance() throws IOException {
        boolean keepAlive = this.support.isKeepAlive();
        boolean chunkable = this.support.isChunkedEncoded();
        if (!keepAlive) {
            return new CloseProducer(this.sender, this.monitor);
        }
        return this.getInstance(chunkable);
    }

    private Producer getInstance(boolean chunkable) throws IOException {
        int length = this.support.getContentLength();
        if (!this.support.isHead()) {
            if (length > 0) {
                return new FixedProducer(this.sender, this.monitor, length);
            }
            if (chunkable) {
                return new ChunkedProducer(this.sender, this.monitor);
            }
        }
        return new EmptyProducer(this.sender, this.monitor);
    }
}

