/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SmartEnterProcessor {
    public abstract boolean process(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    public boolean processAfterCompletion(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            SmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            SmartEnterProcessor.$$$reportNull$$$0(1);
        }
        return this.process(psiFile.getProject(), editor, psiFile);
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        TextRange range = atCaret.getTextRange();
        PsiFile file = atCaret.getContainingFile();
        PsiFile baseFile = file.getViewProvider().getPsi(file.getViewProvider().getBaseLanguage());
        CodeStyleManager.getInstance(atCaret.getProject()).reformatText(baseFile, range.getStartOffset(), range.getEndOffset());
    }

    protected RangeMarker createRangeMarker(PsiElement elt) {
        PsiFile psiFile = elt.getContainingFile();
        PsiDocumentManager instance = PsiDocumentManager.getInstance(elt.getProject());
        Document document = instance.getDocument(psiFile);
        return document.createRangeMarker(elt.getTextRange());
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        int offset;
        int caret = editor.getCaretModel().getOffset();
        Document doc = editor.getDocument();
        CharSequence chars = doc.getCharsSequence();
        int n = offset = caret == 0 ? 0 : CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caret - 1), (String)" \t");
        if (doc.getLineNumber(offset) < doc.getLineNumber(caret)) {
            offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)caret, (String)" \t");
        }
        return psiFile.findElementAt(offset);
    }

    protected static boolean isUncommited(@NotNull Project project) {
        if (project == null) {
            SmartEnterProcessor.$$$reportNull$$$0(2);
        }
        return PsiDocumentManager.getInstance(project).hasUncommitedDocuments();
    }

    public void commit(@NotNull Editor editor) {
        if (editor == null) {
            SmartEnterProcessor.$$$reportNull$$$0(3);
        }
        SmartEnterProcessor.commitDocument(editor);
    }

    public static void commitDocument(@NotNull Editor editor) {
        if (editor == null) {
            SmartEnterProcessor.$$$reportNull$$$0(4);
        }
        Project project = editor.getProject();
        PsiDocumentManager.getInstance(project).commitDocument(editor.getDocument());
        PsiDocumentManager.getInstance(project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/SmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAfterCompletion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncommited";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "commitDocument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

