/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandlerFactory;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.TableCell;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.SortableColumnModel;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.function.Predicate;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultRowSorter;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTable
extends JTable
implements ComponentWithEmptyText,
ComponentWithExpandableItems<TableCell> {
    public static final int PREFERRED_SCROLLABLE_VIEWPORT_HEIGHT_IN_ROWS = 7;
    public static final int COLUMN_RESIZE_AREA_WIDTH = 3;
    private static final int DEFAULT_MIN_COLUMN_WIDTH = 15;
    private final StatusText myEmptyText;
    private final ExpandableItemsHandler<TableCell> myExpandableItemsHandler;
    private boolean myEnableAntialiasing;
    private int myVisibleRowCount = 4;
    private int myRowHeight = -1;
    private boolean myRowHeightIsExplicitlySet;
    private boolean myRowHeightIsComputing;
    private boolean myUiUpdating = true;
    private Integer myMinRowHeight;
    private boolean myStriped;
    protected AsyncProcessIcon myBusyIcon;
    private boolean myBusy;
    private int myMaxItemsForSizeCalculation = Integer.MAX_VALUE;
    private TableCell rollOverCell;
    private final Color disabledForeground = JBColor.namedColor((String)"Table.disabledForeground", (Color)JBColor.gray);

    public JBTable() {
        this(new DefaultTableModel());
    }

    public JBTable(TableModel model) {
        this(model, null);
    }

    public JBTable(TableModel model, TableColumnModel columnModel) {
        super(model, columnModel);
        if (ScreenReader.isActive()) {
            this.resetDefaultFocusTraversalKeys();
        }
        this.setSurrendersFocusOnKeystroke(true);
        this.myEmptyText = new StatusText(this){

            @Override
            protected boolean isStatusVisible() {
                return JBTable.this.isEmpty();
            }
        };
        this.myExpandableItemsHandler = ExpandableItemsHandlerFactory.install(this);
        this.setFillsViewportHeight(true);
        this.addMouseListener(new MyMouseListener());
        if (UIUtil.isUnderWin10LookAndFeel()) {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Component rc;
                    TableCellRenderer cellRenderer;
                    Point point = e.getPoint();
                    int column = JBTable.this.columnAtPoint(point);
                    int row = JBTable.this.rowAtPoint(point);
                    JBTable.this.resetRollOverCell();
                    if (row >= 0 && row < JBTable.this.getRowCount() && column >= 0 && column < JBTable.this.getColumnCount() && (cellRenderer = JBTable.this.getCellRenderer(row, column)) != null && (rc = cellRenderer.getTableCellRendererComponent(JBTable.this, JBTable.this.getValueAt(row, column), JBTable.this.isCellSelected(row, column), JBTable.this.hasFocus(), row, column)) instanceof JCheckBox && (JBTable.this.rollOverCell == null || !JBTable.this.rollOverCell.at(row, column))) {
                        Rectangle cellRect = JBTable.this.getCellRect(row, column, false);
                        JBTable.this.rollOverCell = new TableCell(row, column);
                        ((JCheckBox)rc).putClientProperty("JCheckBox.rollOver.rectangle", cellRect);
                        if (JBTable.this.getModel() instanceof AbstractTableModel) {
                            ((AbstractTableModel)JBTable.this.getModel()).fireTableCellUpdated(row, column);
                        }
                    }
                }
            });
        }
        final TableModelListener modelListener = new TableModelListener(){

            @Override
            public void tableChanged(@NotNull TableModelEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                JBTable.this.onTableChanged(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/table/JBTable$3", "tableChanged"));
            }
        };
        if (this.getModel() != null) {
            this.getModel().addTableModelListener(modelListener);
        }
        this.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt == null) {
                    4.$$$reportNull$$$0(0);
                }
                UIUtil.repaintViewport((JComponent)JBTable.this);
                if (evt.getOldValue() instanceof TableModel) {
                    ((TableModel)evt.getOldValue()).removeTableModelListener(modelListener);
                }
                if (evt.getNewValue() instanceof TableModel) {
                    ((TableModel)evt.getNewValue()).addTableModelListener(modelListener);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/ui/table/JBTable$4", "propertyChange"));
            }
        });
        this.myUiUpdating = false;
        new MyCellEditorRemover();
    }

    protected void onTableChanged(@NotNull TableModelEvent e) {
        if (e == null) {
            JBTable.$$$reportNull$$$0(0);
        }
        if (!this.myRowHeightIsExplicitlySet) {
            this.myRowHeight = -1;
        }
        if (e.getType() == -1 && this.isEmpty() || e.getType() == 1 && !this.isEmpty() || e.getType() == 0) {
            UIUtil.repaintViewport((JComponent)this);
        }
    }

    public int getVisibleRowCount() {
        return this.myVisibleRowCount;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        int oldValue = this.myVisibleRowCount;
        this.myVisibleRowCount = Math.max(0, visibleRowCount);
        this.firePropertyChange("visibleRowCount", oldValue, visibleRowCount);
    }

    @Override
    public int getRowHeight() {
        int height = super.getRowHeight();
        if (this.myRowHeightIsComputing) {
            return height;
        }
        if (this.myRowHeight < 0) {
            try {
                this.myRowHeightIsComputing = true;
                this.myRowHeight = this.calculateRowHeight();
            }
            finally {
                this.myRowHeightIsComputing = false;
            }
        }
        if (this.myMinRowHeight == null) {
            this.myMinRowHeight = this.getFontMetrics(UIManager.getFont("Label.font")).getHeight();
        }
        return Math.max(this.myRowHeight, Math.max(this.myMinRowHeight, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int calculateRowHeight() {
        int result = -1;
        for (int row = 0; row < Math.min(this.getRowCount(), this.myMaxItemsForSizeCalculation); ++row) {
            for (int column = 0; column < Math.min(this.getColumnCount(), this.myMaxItemsForSizeCalculation); ++column) {
                Object value;
                Component component;
                TableCellRenderer renderer = this.getCellRenderer(row, column);
                if (renderer == null || (component = renderer.getTableCellRendererComponent(this, value = this.getValueAt(row, column), true, true, row, column)) == null) continue;
                Dimension size = component.getPreferredSize();
                result = Math.max(size.height, result);
                if (!(component instanceof JLabel) || !StringUtil.isEmpty((String)((JLabel)component).getText())) continue;
                String oldText = ((JLabel)component).getText();
                try {
                    ((JLabel)component).setText("Jj");
                    size = component.getPreferredSize();
                    result = Math.max(size.height, result);
                    continue;
                }
                finally {
                    ((JLabel)component).setText(oldText);
                }
            }
        }
        return result;
    }

    public void setShowColumns(boolean value) {
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setVisible(value);
        tableHeader.setPreferredSize(value ? null : new Dimension());
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (!this.myUiUpdating) {
            this.myRowHeight = rowHeight;
            this.myRowHeightIsExplicitlySet = true;
        }
        super.setRowHeight(rowHeight);
    }

    @Override
    public void updateUI() {
        this.myUiUpdating = true;
        try {
            super.updateUI();
            this.myMinRowHeight = null;
        }
        finally {
            this.myUiUpdating = false;
        }
    }

    @Override
    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        return new JBTableHeader();
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setPreferredScrollableViewportSize(null);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size;
        int fixedWidth;
        Dimension base = super.getPreferredScrollableViewportSize();
        int visibleRows = this.myVisibleRowCount;
        if (visibleRows <= 0) {
            return base;
        }
        if (base != null && base.height > 0) {
            return base;
        }
        boolean addExtraSpace = Registry.is((String)"ide.preferred.scrollable.viewport.extra.space");
        TableModel model = this.getModel();
        int modelRows = model == null ? 0 : model.getRowCount();
        boolean forceVisibleRowCount = Boolean.TRUE.equals(UIUtil.getClientProperty((Object)this, JBViewport.FORCE_VISIBLE_ROW_COUNT_KEY));
        if (!forceVisibleRowCount) {
            visibleRows = Math.min(modelRows, visibleRows);
        }
        int n = fixedWidth = base != null && base.width > 0 ? base.width : JBUI.scale((int)100);
        if (modelRows == 0) {
            int fixedHeight = Registry.intValue((String)"ide.preferred.scrollable.viewport.fixed.height");
            if (fixedHeight <= 0) {
                fixedHeight = UIManager.getInt("Table.rowHeight");
            }
            if (fixedHeight <= 0) {
                fixedHeight = JBUIScale.scale((int)16);
            }
            size = new Dimension(fixedWidth, fixedHeight * visibleRows);
            if (addExtraSpace) {
                size.height += fixedHeight / 2;
            }
        } else {
            Rectangle rect = this.getCellRect(Math.min(visibleRows, modelRows) - 1, 0, true);
            size = new Dimension(fixedWidth, rect.y + rect.height);
            if (modelRows < visibleRows) {
                size.height += (visibleRows - modelRows) * rect.height;
            } else if (modelRows > visibleRows && addExtraSpace) {
                size.height += rect.height / 2;
            }
        }
        return size;
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    @Override
    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            JBTable.$$$reportNull$$$0(1);
        }
        super.setModel(model);
        if (model instanceof SortableColumnModel) {
            SortableColumnModel sortableModel = (SortableColumnModel)((Object)model);
            if (sortableModel.isSortable()) {
                TableRowSorter<TableModel> rowSorter = this.createRowSorter(model);
                rowSorter.setSortsOnUpdates(this.isSortOnUpdates());
                this.setRowSorter(rowSorter);
                RowSorter.SortKey sortKey = sortableModel.getDefaultSortKey();
                if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < model.getColumnCount() && sortableModel.getColumnInfos()[sortKey.getColumn()].isSortable()) {
                    rowSorter.setSortKeys(Collections.singletonList(sortKey));
                }
            } else {
                RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
                if (rowSorter instanceof DefaultColumnInfoBasedRowSorter) {
                    this.setRowSorter(null);
                }
            }
        }
    }

    protected boolean isSortOnUpdates() {
        return true;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            JBTable.$$$reportNull$$$0(2);
        }
        if (this.myEnableAntialiasing) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
        }
        super.paintComponent(g);
        this.getEmptyText().paint(this, g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.myEnableAntialiasing) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
        }
        super.paintChildren(g);
    }

    public void setEnableAntialiasing(boolean flag) {
        this.myEnableAntialiasing = flag;
    }

    public static DefaultCellEditor createBooleanEditor() {
        return new DefaultCellEditor(new JCheckBox()){
            {
                ((JCheckBox)this.getComponent()).setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                component.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return component;
            }
        };
    }

    public void resetDefaultFocusTraversalKeys() {
        KeyboardFocusManager m = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        for (Integer each : Arrays.asList(0, 1, 2, 3)) {
            this.setFocusTraversalKeys(each, m.getDefaultFocusTraversalKeys(each));
        }
    }

    public void setupEasyFocusTraversing() {
        this.wrapAction("TAB", table -> {
            if (table.getRowCount() == 0 || table.getSelectionModel().getLeadSelectionIndex() == table.getRowCount() - 1 && table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == table.getColumnCount() - 1) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                return true;
            }
            return false;
        });
        this.wrapAction("shift TAB", table -> {
            if (table.getRowCount() == 0 || table.getSelectionModel().getLeadSelectionIndex() == 0 && table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == 0) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                return true;
            }
            return false;
        });
    }

    private void wrapAction(String shortcut, final Predicate<JTable> predicate) {
        Object actionKey = this.getInputMap(1).get(KeyStroke.getKeyStroke(shortcut));
        final Action action = this.getActionMap().get(actionKey);
        this.getActionMap().put(actionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!predicate.test(JBTable.this)) {
                    action.actionPerformed(e);
                }
            }
        });
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myEmptyText;
        if (statusText == null) {
            JBTable.$$$reportNull$$$0(3);
        }
        return statusText;
    }

    @Override
    @NotNull
    public ExpandableItemsHandler<TableCell> getExpandableItemsHandler() {
        ExpandableItemsHandler<TableCell> expandableItemsHandler = this.myExpandableItemsHandler;
        if (expandableItemsHandler == null) {
            JBTable.$$$reportNull$$$0(4);
        }
        return expandableItemsHandler;
    }

    @Override
    public void setExpandableItemsEnabled(boolean enabled) {
        this.myExpandableItemsHandler.setEnabled(enabled);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this) && this.myBusyIcon != null) {
            this.remove(this.myBusyIcon);
            Disposer.dispose((Disposable)this.myBusyIcon);
            this.myBusyIcon = null;
        }
    }

    @Override
    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        if (visibleRect == null) {
            JBTable.$$$reportNull$$$0(5);
        }
        if (orientation == 1) {
            return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), " ");
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            JBTable.$$$reportNull$$$0(6);
        }
        super.paint(g);
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    public Color getForeground() {
        return this.isEnabled() ? super.getForeground() : this.disabledForeground;
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        if (this.myBusy && this.myBusyIcon == null) {
            this.myBusyIcon = this.createBusyIcon();
            this.myBusyIcon.setOpaque(false);
            this.myBusyIcon.setPaintPassiveIcon(false);
            this.add(this.myBusyIcon);
        }
        if (this.myBusyIcon != null) {
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
                SwingUtilities.invokeLater(() -> {
                    if (this.myBusyIcon != null) {
                        this.repaint();
                    }
                });
            }
            if (this.myBusyIcon != null) {
                this.myBusyIcon.updateLocation(this);
            }
        }
    }

    @NotNull
    protected AsyncProcessIcon createBusyIcon() {
        return new AsyncProcessIcon(this.toString());
    }

    public boolean isStriped() {
        return this.myStriped;
    }

    public void setStriped(boolean striped) {
        this.myStriped = striped;
        if (striped) {
            this.getColumnModel().setColumnMargin(0);
            this.setIntercellSpacing(new Dimension(this.getIntercellSpacing().width, 0));
            this.setShowGrid(false);
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        TableCellEditor editor;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (e instanceof KeyEvent) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)((KeyEvent)e))) {
                return false;
            }
            SpeedSearchSupply supply = SpeedSearchSupply.getSupply(this);
            if (supply != null && supply.isPopupActive()) {
                return false;
            }
        }
        if ((editor = this.getCellEditor(row, column)) != null && editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(editor, row, column);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(row, column, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            if (this.surrendersFocusOnKeyStroke()) {
                IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent(this);
                focusManager.setTypeaheadEnabled(false);
                focusManager.requestFocus(this.editorComp, true).doWhenProcessed(() -> focusManager.setTypeaheadEnabled(true));
            }
            this.setCellEditor(editor);
            this.setEditingRow(row);
            this.setEditingColumn(column);
            editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean getSurrendersFocusOnKeystroke() {
        return false;
    }

    public boolean surrendersFocusOnKeyStroke() {
        return super.getSurrendersFocusOnKeystroke();
    }

    private static boolean isTableDecorationSupported() {
        return UIUtil.isUnderNativeMacLookAndFeel() || StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF();
    }

    @Override
    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        if (renderer == null) {
            JBTable.$$$reportNull$$$0(7);
        }
        Component result = super.prepareRenderer(renderer, row, column);
        if (JBTable.isTableDecorationSupported() && this.isStriped() && result instanceof JComponent) {
            Color bg = row % 2 == 1 ? this.getBackground() : UIUtil.getDecoratedRowColor();
            JComponent c = (JComponent)result;
            boolean cellSelected = this.isCellSelected(row, column);
            if (!cellSelected) {
                c.setOpaque(true);
                c.setBackground(bg);
                for (Component child : c.getComponents()) {
                    child.setBackground(bg);
                }
            }
        }
        if (this.myExpandableItemsHandler.getExpandedItems().contains(new TableCell(row, column))) {
            result = ExpandedItemRendererComponentWrapper.wrap(result);
        }
        if (renderer instanceof JCheckBox) {
            ((JCheckBox)((Object)renderer)).getModel().setRollover(this.rollOverCell != null && this.rollOverCell.at(row, column));
        }
        Component component = result;
        if (component == null) {
            JBTable.$$$reportNull$$$0(8);
        }
        return component;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        MouseEvent e2 = e;
        if (SystemInfo.isMac) {
            e2 = MacUIUtil.fixMacContextMenuIssue((MouseEvent)e);
        }
        super.processMouseEvent(e2);
        if (e != e2 && e2.isConsumed()) {
            e.consume();
        }
    }

    protected TableRowSorter<TableModel> createRowSorter(TableModel model) {
        return new DefaultColumnInfoBasedRowSorter(model);
    }

    public int getExpandedColumnWidth(int columnToExpand) {
        int expandedWidth = this.getPreferredHeaderWidth(columnToExpand);
        for (int row = 0; row < this.getRowCount(); ++row) {
            TableCellRenderer cellRenderer = this.getCellRenderer(row, columnToExpand);
            if (cellRenderer == null) continue;
            Component c = this.prepareRenderer(cellRenderer, row, columnToExpand);
            expandedWidth = Math.max(expandedWidth, c.getPreferredSize().width);
        }
        return expandedWidth;
    }

    private int getPreferredHeaderWidth(int columnIdx) {
        TableColumn column = this.getColumnModel().getColumn(columnIdx);
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            JTableHeader header = this.getTableHeader();
            if (header == null) {
                return 15;
            }
            renderer = header.getDefaultRenderer();
        }
        Object headerValue = column.getHeaderValue();
        Component headerCellRenderer = renderer.getTableCellRendererComponent(this, headerValue, false, false, -1, columnIdx);
        return headerCellRenderer.getPreferredSize().width;
    }

    public void setMaxItemsForSizeCalculation(int maxItemsForSizeCalculation) {
        this.myMaxItemsForSizeCalculation = maxItemsForSizeCalculation;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJBTable();
        }
        return this.accessibleContext;
    }

    private void resetRollOverCell() {
        if (UIUtil.isUnderWin10LookAndFeel() && this.getModel() instanceof AbstractTableModel && this.rollOverCell != null) {
            boolean selected;
            Object value;
            Component rc;
            TableCellRenderer cellRenderer = this.getCellRenderer(this.rollOverCell.row, this.rollOverCell.column);
            if (cellRenderer != null && (rc = cellRenderer.getTableCellRendererComponent(this, value = this.getValueAt(this.rollOverCell.row, this.rollOverCell.column), selected = this.isCellSelected(this.rollOverCell.row, this.rollOverCell.column), this.hasFocus(), this.rollOverCell.row, this.rollOverCell.column)) instanceof JCheckBox) {
                ((JCheckBox)rc).putClientProperty("JCheckBox.rollOver.rectangle", null);
            }
            if (this.getModel() instanceof AbstractTableModel) {
                ((AbstractTableModel)this.getModel()).fireTableCellUpdated(this.rollOverCell.row, this.rollOverCell.column);
            }
            this.rollOverCell = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/table/JBTable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/table/JBTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandableItemsHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onTableChanged";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "paintComponent";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getScrollableUnitIncrement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleJBTable
    extends JTable.AccessibleJTable {
        protected AccessibleJBTable() {
            super(JBTable.this);
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            int column = this.getAccessibleColumnAtIndex(i);
            int row = this.getAccessibleRowAtIndex(i);
            return new AccessibleJBTableCell((JTable)JBTable.this, row, column, this.getAccessibleIndexAt(row, column));
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            int column = JBTable.this.columnAtPoint(p);
            int row = JBTable.this.rowAtPoint(p);
            if (column != -1 && row != -1) {
                return this.getAccessibleChild(this.getAccessibleIndexAt(row, column));
            }
            return null;
        }

        protected class AccessibleJBTableCell
        extends JTable.AccessibleJTable.AccessibleJTableCell {
            private final int myRow;
            private final int myColumn;

            public AccessibleJBTableCell(JTable table, int row, int columns, int index) {
                super(AccessibleJBTable.this, table, row, columns, index);
                this.myRow = row;
                this.myColumn = columns;
            }

            @Override
            protected Component getCurrentComponent() {
                return JBTable.this.getCellRenderer(this.myRow, this.myColumn).getTableCellRendererComponent(JBTable.this, JBTable.this.getValueAt(this.myRow, this.myColumn), false, false, this.myRow, this.myColumn);
            }

            @Override
            protected AccessibleContext getCurrentAccessibleContext() {
                Component c = this.getCurrentComponent();
                if (c instanceof Accessible) {
                    return c.getAccessibleContext();
                }
                return null;
            }
        }
    }

    private static class MyBasicTableHeaderUI
    extends BasicTableHeaderUI
    implements MouseInputListener {
        private int myStartXCoordinate;
        private int myStartYCoordinate;

        MyBasicTableHeaderUI(@NotNull InvisibleResizableHeader tableHeader) {
            if (tableHeader == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(0);
            }
            this.myStartXCoordinate = 0;
            this.myStartYCoordinate = 0;
            this.header = tableHeader;
            this.mouseInputListener = this.createMouseInputListener();
        }

        @NotNull
        private MouseEvent convertMouseEvent(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(1);
            }
            return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), 0, e.getXOnScreen(), this.header.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(3);
            }
            if (this.isOnBorder(e) || !this.canMoveOrResizeColumn(e)) {
                return;
            }
            this.myStartXCoordinate = e.getX();
            this.myStartYCoordinate = e.getY();
            this.mouseInputListener.mousePressed(this.convertMouseEvent(e));
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(4);
            }
            this.mouseInputListener.mouseReleased(this.convertMouseEvent(e));
            if (this.header.getCursor() == Cursor.getPredefinedCursor(13)) {
                this.header.setCursor(null);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(5);
            }
            this.mouseInputListener.mouseEntered(this.convertMouseEvent(e));
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(6);
            }
            this.mouseInputListener.mouseExited(this.convertMouseEvent(e));
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(7);
            }
            if (!this.isDraggingEnabled(e)) {
                return;
            }
            this.mouseInputListener.mouseDragged(this.convertMouseEvent(e));
            if (this.header.getDraggedColumn() != null) {
                int draggedColumn;
                int targetColumn;
                if (this.header.getCursor() == Cursor.getPredefinedCursor(0)) {
                    this.header.setCursor(Cursor.getPredefinedCursor(13));
                }
                if ((targetColumn = (draggedColumn = this.header.getTable().convertColumnIndexToView(this.header.getDraggedColumn().getModelIndex())) + (this.header.getDraggedDistance() < 0 ? -1 : 1)) < 0 || targetColumn >= this.header.getTable().getColumnCount()) {
                    return;
                }
                if (!this.canMoveOrResizeColumn(this.header.getTable().convertColumnIndexToModel(targetColumn))) {
                    this.mouseReleased(e);
                }
            }
        }

        private boolean isDraggingEnabled(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(8);
            }
            if (this.isOnBorder(e) || !SwingUtilities.isLeftMouseButton(e) || !this.canMoveOrResizeColumn(e)) {
                return false;
            }
            if (this.header.getCursor() == Cursor.getPredefinedCursor(13) || this.header.getCursor() == Cursor.getPredefinedCursor(11)) {
                return true;
            }
            int deltaX = Math.abs(e.getX() - this.myStartXCoordinate);
            int deltaY = Math.abs(e.getY() - this.myStartYCoordinate);
            Point point = new Point(MathUtil.clamp((int)e.getX(), (int)0, (int)(this.header.getTable().getWidth() - 1)), e.getY());
            boolean sameColumn = this.header.getDraggedColumn() == null ? true : this.header.getTable().getColumnModel().getColumn(this.header.getTable().columnAtPoint(point)) == this.header.getDraggedColumn();
            return deltaX >= 3 * deltaY && sameColumn;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(9);
            }
            if (this.isOnBorder(e) || this.header.getTable().getRowCount() == 0) {
                return;
            }
            this.mouseInputListener.mouseMoved(this.convertMouseEvent(e));
        }

        private boolean isOnBorder(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(10);
            }
            return Math.abs(this.header.getTable().getWidth() - e.getPoint().x) <= JBUIScale.scale((int)3);
        }

        private boolean canMoveOrResizeColumn(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(11);
            }
            JTable table = this.header.getTable();
            return this.canMoveOrResizeColumn(table.getColumnModel().getColumnIndexAtX(e.getX()));
        }

        private boolean canMoveOrResizeColumn(int index) {
            return ((InvisibleResizableHeader)this.header).canMoveOrResizeColumn(index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableHeader";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/table/JBTable$MyBasicTableHeaderUI";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convertMouseEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseDragged";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDraggingEnabled";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnBorder";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canMoveOrResizeColumn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EmptyTableCellRenderer
    extends CellRendererPanel
    implements TableCellRenderer {
        private EmptyTableCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            EmptyTableCellRenderer emptyTableCellRenderer = this;
            if (emptyTableCellRenderer == null) {
                EmptyTableCellRenderer.$$$reportNull$$$0(0);
            }
            return emptyTableCellRenderer;
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(0, 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/table/JBTable$EmptyTableCellRenderer", "getTableCellRendererComponent"));
        }
    }

    protected class InvisibleResizableHeader
    extends JBTableHeader {
        @NotNull
        private final MyBasicTableHeaderUI myHeaderUI;
        @Nullable
        private Cursor myCursor;

        public InvisibleResizableHeader() {
            this.myCursor = null;
            this.myHeaderUI = new MyBasicTableHeaderUI(this);
            this.setDefaultRenderer(new EmptyTableCellRenderer());
            this.setReorderingAllowed(true);
        }

        @Override
        public void setTable(JTable table) {
            JTable oldTable = this.getTable();
            if (oldTable != null) {
                oldTable.removeMouseListener(this.myHeaderUI);
                oldTable.removeMouseMotionListener(this.myHeaderUI);
            }
            super.setTable(table);
            if (table != null) {
                table.addMouseListener(this.myHeaderUI);
                table.addMouseMotionListener(this.myHeaderUI);
            }
        }

        @Override
        public void setCursor(@Nullable Cursor cursor) {
            JTable table = this.getTable();
            if (table != null) {
                table.setCursor(UIUtil.cursorIfNotDefault((Cursor)cursor));
                this.myCursor = cursor;
            } else {
                super.setCursor(cursor);
            }
        }

        @Override
        public Cursor getCursor() {
            if (this.myCursor == null) {
                JTable table = this.getTable();
                if (table == null) {
                    return super.getCursor();
                }
                return table.getCursor();
            }
            return this.myCursor;
        }

        @Override
        @NotNull
        public Rectangle getHeaderRect(int column) {
            Rectangle headerRect = super.getHeaderRect(column);
            return new Rectangle(headerRect.x, headerRect.y, headerRect.width, 1);
        }

        protected boolean canMoveOrResizeColumn(int modelIndex) {
            return this.table.getRowCount() != 0;
        }
    }

    protected class JBTableHeader
    extends JTableHeader {
        private final Color disabledForeground;

        public JBTableHeader() {
            super(JBTable.this.columnModel);
            this.disabledForeground = JBColor.namedColor((String)"TableHeader.disabledForeground", (Color)JBColor.gray);
            JBTable.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(@NotNull PropertyChangeEvent evt) {
                    if (evt == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ("enabled".equals(evt.getPropertyName())) {
                        JBTableHeader.this.repaint();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/ui/table/JBTable$JBTableHeader$1", "propertyChange"));
                }
            });
            final DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.getDefaultRenderer();
            TableCellRenderer newRenderer = new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component delegate = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (!(delegate instanceof JLabel)) {
                        return delegate;
                    }
                    JLabel cmp = (JLabel)delegate;
                    cmp.setHorizontalAlignment(2);
                    Border border = cmp.getBorder();
                    JBEmptyBorder indent = JBUI.Borders.emptyLeft((int)8);
                    border = JBUI.Borders.merge((Border)border, (Border)indent, (boolean)true);
                    cmp.setBorder(border);
                    return cmp;
                }
            };
            this.setDefaultRenderer(newRenderer);
        }

        @Override
        public void paint(@NotNull Graphics g) {
            if (g == null) {
                JBTableHeader.$$$reportNull$$$0(0);
            }
            if (JBTable.this.myEnableAntialiasing) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
            }
            super.paint(g);
        }

        @Override
        public Color getForeground() {
            return JBTable.this.isEnabled() ? super.getForeground() : this.disabledForeground;
        }

        @Override
        public String getToolTipText(@NotNull MouseEvent event) {
            ColumnInfo[] columnInfos;
            if (event == null) {
                JBTableHeader.$$$reportNull$$$0(1);
            }
            if ((columnInfos = this.getColumnInfos()) != null) {
                String tooltipText;
                int i = this.columnAtPoint(event.getPoint());
                int infoIndex = i >= 0 ? JBTable.this.convertColumnIndexToModel(i) : -1;
                String string = tooltipText = infoIndex >= 0 && infoIndex < columnInfos.length ? columnInfos[infoIndex].getTooltipText() : null;
                if (tooltipText != null) {
                    return tooltipText;
                }
            }
            return super.getToolTipText(event);
        }

        private ColumnInfo @Nullable [] getColumnInfos() {
            TreeTableModel treeTableModel;
            TableModel model = JBTable.this.getModel();
            if (model instanceof SortableColumnModel) {
                return ((SortableColumnModel)((Object)model)).getColumnInfos();
            }
            if (this.getTable() instanceof TreeTable && (treeTableModel = ((TreeTable)this.getTable()).getTableModel()) instanceof SortableColumnModel) {
                return ((SortableColumnModel)((Object)treeTableModel)).getColumnInfos();
            }
            return null;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            int columnToPack;
            if (e.getID() == 500 && e.getButton() == 1 && (columnToPack = this.getColumnToPack(e.getPoint())) != -1 && this.canResize(columnToPack)) {
                if (e.getClickCount() % 2 == 0) {
                    this.packColumn(columnToPack);
                }
                return;
            }
            super.processMouseEvent(e);
        }

        protected void packColumn(int columnToPack) {
            TableColumn column = this.getColumnModel().getColumn(columnToPack);
            int currentWidth = column.getWidth();
            int expandedWidth = JBTable.this.getExpandedColumnWidth(columnToPack);
            int newWidth = this.getColumnModel().getColumnMargin() + (currentWidth >= expandedWidth ? JBTable.this.getPreferredHeaderWidth(columnToPack) : expandedWidth);
            this.setResizingColumn(column);
            column.setWidth(newWidth);
            Dimension tableSize = JBTable.this.getSize();
            tableSize.width += newWidth - column.getWidth();
            JBTable.this.setSize(tableSize);
            ApplicationManager.getApplication().invokeLater(() -> this.setResizingColumn(null));
        }

        private int getColumnToPack(Point p) {
            boolean atLeftBound;
            int viewColumnIdx = JBTable.this.columnAtPoint(p);
            if (viewColumnIdx == -1) {
                return -1;
            }
            Rectangle headerRect = this.getHeaderRect(viewColumnIdx);
            boolean bl = atLeftBound = p.x - headerRect.x < 3;
            if (atLeftBound) {
                return viewColumnIdx == 0 ? viewColumnIdx : viewColumnIdx - 1;
            }
            boolean atRightBound = headerRect.x + headerRect.width - p.x < 3;
            return atRightBound ? viewColumnIdx : -1;
        }

        private boolean canResize(int columnIdx) {
            TableColumnModel columnModel = this.getColumnModel();
            return this.resizingAllowed && columnModel.getColumn(columnIdx).getResizable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/table/JBTable$JBTableHeader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getToolTipText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DefaultColumnInfoBasedRowSorter
    extends TableRowSorter<TableModel> {
        public DefaultColumnInfoBasedRowSorter(TableModel model) {
            super(model);
            this.setModelWrapper(new TableRowSorterModelWrapper(model));
            this.setMaxSortKeys(1);
        }

        @Override
        public Comparator<?> getComparator(int column) {
            TableModel model = (TableModel)this.getModel();
            if (model instanceof SortableColumnModel) {
                Comparator comparator;
                ColumnInfo[] columnInfos = ((SortableColumnModel)((Object)model)).getColumnInfos();
                if (column >= 0 && column < columnInfos.length && (comparator = columnInfos[column].getComparator()) != null) {
                    return comparator;
                }
            }
            return super.getComparator(column);
        }

        @Override
        protected boolean useToString(int column) {
            return false;
        }

        @Override
        public boolean isSortable(int column) {
            TableModel model = (TableModel)this.getModel();
            if (model instanceof SortableColumnModel) {
                ColumnInfo[] columnInfos = ((SortableColumnModel)((Object)model)).getColumnInfos();
                if (column >= 0 && column < columnInfos.length) {
                    return columnInfos[column].isSortable() && columnInfos[column].getComparator() != null;
                }
            }
            return false;
        }

        private class TableRowSorterModelWrapper
        extends DefaultRowSorter.ModelWrapper<TableModel, Integer> {
            private final TableModel myModel;

            private TableRowSorterModelWrapper(TableModel model) {
                if (model == null) {
                    TableRowSorterModelWrapper.$$$reportNull$$$0(0);
                }
                this.myModel = model;
            }

            @Override
            public TableModel getModel() {
                return this.myModel;
            }

            @Override
            public int getColumnCount() {
                return this.myModel.getColumnCount();
            }

            @Override
            public int getRowCount() {
                return this.myModel.getRowCount();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (this.myModel instanceof SortableColumnModel) {
                    return ((SortableColumnModel)((Object)this.myModel)).getRowValue(row);
                }
                return this.myModel.getValueAt(row, column);
            }

            @Override
            @NotNull
            public String getStringValueAt(int row, int column) {
                TableStringConverter converter = DefaultColumnInfoBasedRowSorter.this.getStringConverter();
                if (converter != null) {
                    String value = converter.toString(this.myModel, row, column);
                    if (value != null) {
                        String string = value;
                        if (string == null) {
                            TableRowSorterModelWrapper.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    return "";
                }
                Object o = this.getValueAt(row, column);
                if (o == null) {
                    return "";
                }
                String string = o.toString();
                if (string == null) {
                    return "";
                }
                String string2 = string;
                if (string2 == null) {
                    TableRowSorterModelWrapper.$$$reportNull$$$0(2);
                }
                return string2;
            }

            @Override
            public Integer getIdentifier(int index) {
                return index;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/table/JBTable$DefaultColumnInfoBasedRowSorter$TableRowSorterModelWrapper";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/table/JBTable$DefaultColumnInfoBasedRowSorter$TableRowSorterModelWrapper";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getStringValueAt";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            int row;
            int[] selectedRows;
            if (e == null) {
                MyMouseListener.$$$reportNull$$$0(0);
            }
            if (SwingUtilities.isRightMouseButton(e) && (selectedRows = JBTable.this.getSelectedRows()).length < 2 && (row = JBTable.this.rowAtPoint(e.getPoint())) != -1) {
                JBTable.this.getSelectionModel().setSelectionInterval(row, row);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getClickCount() == 0) {
                JBTable.this.resetRollOverCell();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/table/JBTable$MyMouseListener", "mousePressed"));
        }
    }

    private final class MyCellEditorRemover
    implements PropertyChangeListener,
    Activatable {
        private boolean myIsActive = false;

        MyCellEditorRemover() {
            JBTable.this.addPropertyChangeListener("tableCellEditor", this);
            new UiNotifyConnector(JBTable.this, this);
        }

        public void activate() {
            if (!this.myIsActive) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", this);
            }
            this.myIsActive = true;
        }

        public void deactivate() {
            if (this.myIsActive) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.myIsActive = false;
        }

        @Override
        public void hideNotify() {
            this.removeCellEditor();
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent e) {
            if (e == null) {
                MyCellEditorRemover.$$$reportNull$$$0(0);
            }
            if ("tableCellEditor".equals(e.getPropertyName())) {
                this.tableCellEditorChanged(e.getOldValue(), e.getNewValue());
            } else if ("permanentFocusOwner".equals(e.getPropertyName())) {
                this.permanentFocusOwnerChanged();
            }
        }

        private void tableCellEditorChanged(Object from, Object to) {
            boolean editingStopped;
            boolean editingStarted = from == null && to != null;
            boolean bl = editingStopped = from != null && to == null;
            if (editingStarted) {
                this.activate();
            } else if (editingStopped) {
                this.deactivate();
            }
        }

        private void permanentFocusOwnerChanged() {
            if (!JBTable.this.isEditing()) {
                return;
            }
            final IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent(JBTable.this);
            focusManager.doWhenFocusSettlesDown(new ExpirableRunnable(){

                @Override
                public boolean isExpired() {
                    return !JBTable.this.isEditing();
                }

                @Override
                public void run() {
                    Component c = focusManager.getFocusOwner();
                    if (UIUtil.isMeaninglessFocusOwner((Component)c)) {
                        return;
                    }
                    while (c != null) {
                        if (c instanceof JPopupMenu) {
                            c = ((JPopupMenu)c).getInvoker();
                        }
                        if (c == JBTable.this) {
                            return;
                        }
                        if (c instanceof Window) {
                            if (c != SwingUtilities.getWindowAncestor(JBTable.this)) break;
                            MyCellEditorRemover.this.removeCellEditor();
                            break;
                        }
                        c = c.getParent();
                    }
                }
            }, ModalityState.current());
        }

        private void removeCellEditor() {
            TableCellEditor cellEditor = JBTable.this.getCellEditor();
            if (cellEditor != null && !cellEditor.stopCellEditing()) {
                cellEditor.cancelCellEditing();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/table/JBTable$MyCellEditorRemover", "propertyChange"));
        }
    }
}

