/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentFactory;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCommandLineState
extends CommandLineState
implements JavaCommandLine,
TargetEnvironmentAwareRunProfileState {
    private static final Logger LOG = Logger.getInstance(JavaCommandLineState.class);
    private JavaParameters myParams;
    private TargetedCommandLineBuilder myCommandLine;

    protected JavaCommandLineState(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            JavaCommandLineState.$$$reportNull$$$0(0);
        }
        super(environment);
    }

    @Override
    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myParams == null) {
            this.myParams = (JavaParameters)((Object)ReadAction.compute(this::createJavaParameters));
        }
        return this.myParams;
    }

    public void clear() {
        this.myParams = null;
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler oSProcessHandler = JavaCommandLineStateUtil.startProcess(this.createCommandLine(), this.ansiColoringEnabled());
        if (oSProcessHandler == null) {
            JavaCommandLineState.$$$reportNull$$$0(1);
        }
        return oSProcessHandler;
    }

    protected boolean ansiColoringEnabled() {
        return true;
    }

    protected abstract JavaParameters createJavaParameters() throws ExecutionException;

    public synchronized void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (request == null) {
            JavaCommandLineState.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            JavaCommandLineState.$$$reportNull$$$0(3);
        }
        progressIndicator.setText(ExecutionBundle.message((String)"progress.text.prepare.target.requirements", (Object[])new Object[0]));
        this.myCommandLine = this.createTargetedCommandLine(request, configuration);
    }

    @NotNull
    protected synchronized TargetedCommandLineBuilder getTargetedCommandLine() {
        TargetedCommandLineBuilder targetedCommandLineBuilder;
        if (this.myCommandLine != null) {
            TargetedCommandLineBuilder targetedCommandLineBuilder2 = this.myCommandLine;
            if (targetedCommandLineBuilder2 == null) {
                JavaCommandLineState.$$$reportNull$$$0(4);
            }
            return targetedCommandLineBuilder2;
        }
        if (Experiments.getInstance().isFeatureEnabled("run.targets") && !(this.getEnvironment().getTargetEnvironmentFactory() instanceof LocalTargetEnvironmentFactory)) {
            LOG.error("Command line hasn't been built yet. Probably you need to run environment#getPreparedTargetEnvironment first, or it return the environment from the previous run session");
        }
        try {
            this.getEnvironment().prepareTargetEnvironment((RunProfileState)this, (ProgressIndicator)new EmptyProgressIndicator());
            targetedCommandLineBuilder = this.myCommandLine;
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
        if (targetedCommandLineBuilder == null) {
            JavaCommandLineState.$$$reportNull$$$0(5);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration) throws ExecutionException {
        JavaParameters javaParameters;
        if (request == null) {
            JavaCommandLineState.$$$reportNull$$$0(6);
        }
        if (!(javaParameters = this.getJavaParameters()).isDynamicClasspath()) {
            javaParameters.setUseDynamicClasspath(this.getEnvironment().getProject());
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = javaParameters.toCommandLine(request, configuration);
        if (targetedCommandLineBuilder == null) {
            JavaCommandLineState.$$$reportNull$$$0(7);
        }
        return targetedCommandLineBuilder;
    }

    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        LocalTargetEnvironmentFactory factory = new LocalTargetEnvironmentFactory();
        boolean redirectErrorStream = Registry.is((String)"run.processes.with.redirectedErrorStream", (boolean)false);
        TargetEnvironmentRequest request = factory.createRequest();
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.createTargetedCommandLine(request, factory.getTargetConfiguration());
        return factory.prepareRemoteEnvironment(request, (ProgressIndicator)new EmptyProgressIndicator()).createGeneralCommandLine(targetedCommandLineBuilder.build()).withRedirectErrorStream(redirectErrorStream);
    }

    public boolean shouldAddJavaProgramRunnerActions() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/JavaCommandLineState";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/JavaCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetedCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetEnvironmentRequest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

