/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentUtil {
    public static DeploymentUtil getInstance() {
        return (DeploymentUtil)ServiceManager.getService(DeploymentUtil.class);
    }

    public static String trimForwardSlashes(@NotNull String path) {
        if (path == null) {
            DeploymentUtil.$$$reportNull$$$0(0);
        }
        while (path.length() != 0 && (path.charAt(0) == '/' || path.charAt(0) == File.separatorChar)) {
            path = path.substring(1);
        }
        return path;
    }

    public static String concatPaths(String ... paths) {
        StringBuilder builder = new StringBuilder();
        for (String path : paths) {
            if (path.length() == 0) continue;
            int len = builder.length();
            if (len > 0 && builder.charAt(len - 1) != '/' && builder.charAt(len - 1) != File.separatorChar) {
                builder.append('/');
            }
            builder.append(len != 0 ? DeploymentUtil.trimForwardSlashes(path) : path);
        }
        return builder.toString();
    }

    public static String appendToPath(@NotNull String basePath, @NotNull String relativePath) {
        boolean startsWithSlash;
        if (basePath == null) {
            DeploymentUtil.$$$reportNull$$$0(1);
        }
        if (relativePath == null) {
            DeploymentUtil.$$$reportNull$$$0(2);
        }
        boolean endsWithSlash = StringUtil.endsWithChar((CharSequence)basePath, (char)'/') || StringUtil.endsWithChar((CharSequence)basePath, (char)'\\');
        boolean bl = startsWithSlash = StringUtil.startsWithChar((CharSequence)relativePath, (char)'/') || StringUtil.startsWithChar((CharSequence)relativePath, (char)'\\');
        String tail = endsWithSlash && startsWithSlash ? DeploymentUtil.trimForwardSlashes(relativePath) : (!endsWithSlash && !startsWithSlash && basePath.length() > 0 && relativePath.length() > 0 ? "/" + relativePath : relativePath);
        return basePath + tail;
    }

    @Nullable
    public abstract String getConfigFileErrorMessage(ConfigFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/deployment/DeploymentUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "trimForwardSlashes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendToPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

