/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiConstructorUtil {
    @Nullable
    public static PsiMethodCallExpression findThisOrSuperCallInConstructor(@NotNull PsiMethod constructor2) {
        PsiElement bodyElement;
        if (constructor2 == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(0);
        }
        if (!constructor2.isConstructor()) {
            return null;
        }
        PsiCodeBlock body = constructor2.getBody();
        if (body == null) {
            return null;
        }
        for (bodyElement = body.getFirstBodyElement(); bodyElement != null && !(bodyElement instanceof PsiStatement); bodyElement = bodyElement.getNextSibling()) {
        }
        if (!(bodyElement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)bodyElement).getExpression(), PsiMethodCallExpression.class);
        if (JavaPsiConstructorUtil.isConstructorCall(call)) {
            return call;
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isChainedConstructorCall(@Nullable PsiElement call) {
        if (!(call instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiElement child = ((PsiMethodCallExpression)call).getMethodExpression().getReferenceNameElement();
        return child instanceof PsiKeyword && child.textMatches((CharSequence)"this");
    }

    @Contract(value="null -> false")
    public static boolean isSuperConstructorCall(@Nullable PsiElement call) {
        if (!(call instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiElement child = ((PsiMethodCallExpression)call).getMethodExpression().getReferenceNameElement();
        return child instanceof PsiKeyword && child.textMatches((CharSequence)"super");
    }

    @Contract(value="null -> false")
    public static boolean isConstructorCall(@Nullable PsiElement call) {
        if (!(call instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiElement child = ((PsiMethodCallExpression)call).getMethodExpression().getReferenceNameElement();
        return child instanceof PsiKeyword && (child.textMatches((CharSequence)"super") || child.textMatches((CharSequence)"this"));
    }

    public static PsiMethod findConstructorInSuper(@NotNull PsiMethod constructor2) {
        if (constructor2 == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(1);
        }
        return JavaPsiConstructorUtil.findConstructorInSuper(constructor2, new HashSet());
    }

    private static PsiMethod findConstructorInSuper(@NotNull PsiMethod constructor2, @NotNull Set<? super PsiMethod> visited) {
        if (constructor2 == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(2);
        }
        if (visited == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(3);
        }
        if (!visited.add(constructor2)) {
            return null;
        }
        PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor(constructor2);
        if (JavaPsiConstructorUtil.isSuperConstructorCall(call)) {
            PsiMethod superConstructor = call.resolveMethod();
            if (superConstructor != null) {
                return superConstructor;
            }
        } else if (JavaPsiConstructorUtil.isChainedConstructorCall(call)) {
            PsiMethod chainedConstructor = call.resolveMethod();
            if (chainedConstructor != null) {
                return JavaPsiConstructorUtil.findConstructorInSuper(chainedConstructor, visited);
            }
            return null;
        }
        return JavaPsiConstructorUtil.findConstructorInSuperWithParameterTypes(constructor2, PsiType.EMPTY_ARRAY);
    }

    @Nullable
    public static PsiMethod findConstructorInSuperWithParameterTypes(@NotNull PsiMethod constructor2, PsiType @NotNull [] parameterTypes) {
        PsiClass superClass;
        PsiClass containingClass;
        if (constructor2 == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(4);
        }
        if (parameterTypes == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(5);
        }
        if ((containingClass = constructor2.getContainingClass()) != null && (superClass = containingClass.getSuperClass()) != null && superClass.getName() != null) {
            MethodSignature defConstructor = MethodSignatureUtil.createMethodSignature(superClass.getName(), parameterTypes, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, true);
            return MethodSignatureUtil.findMethodBySignature(superClass, defConstructor, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/JavaPsiConstructorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findThisOrSuperCallInConstructor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findConstructorInSuper";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findConstructorInSuperWithParameterTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

