/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.chunking.Chunker;
import org.languagetool.config.UserConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.patterns.Unifier;
import org.languagetool.rules.patterns.UnifierConfiguration;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.xx.DemoDisambiguator;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SimpleSentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.databroker.ResourceDataBroker;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 c2\u00020\u0001:\u0001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010O\u001a\u00020M2\u0006\u0010P\u001a\u00020\u0000J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0\rH\u0016J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\tH\u0016J6\u0010V\u001a\b\u0012\u0004\u0012\u00020W0\r2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[2\b\u0010\\\u001a\u0004\u0018\u00010\u00002\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00000\rH&J\u001a\u0010^\u001a\u0004\u0018\u00010_2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[H\u0016J\b\u0010`\u001a\u00020MH\u0002J\b\u0010a\u001a\u00020TH\u0016J\b\u0010b\u001a\u00020\tH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0012\u0010+\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0016\u0010.\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0006R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u000fR\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0012\u00106\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010-R\u0011\u00108\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010-R\u0016\u0010:\u001a\u0004\u0018\u00010;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0018R\u0014\u0010D\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u001cR\u0016\u0010F\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010-R\u0014\u0010H\u001a\u00020I8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010K\u00a8\u0006d"}, d2={"Lorg/languagetool/language/Language;", "", "()V", "chunker", "Lorg/languagetool/chunking/Chunker;", "getChunker", "()Lorg/languagetool/chunking/Chunker;", "countries", "", "", "getCountries", "()[Ljava/lang/String;", "defaultDisabledRulesForVariant", "", "getDefaultDisabledRulesForVariant", "()Ljava/util/List;", "defaultEnabledRulesForVariant", "getDefaultEnabledRulesForVariant", "defaultLanguageVariant", "getDefaultLanguageVariant", "()Lorg/languagetool/language/Language;", "disambiguationUnifier", "Lorg/languagetool/rules/patterns/Unifier;", "getDisambiguationUnifier", "()Lorg/languagetool/rules/patterns/Unifier;", "disambiguationUnifierConfiguration", "Lorg/languagetool/rules/patterns/UnifierConfiguration;", "getDisambiguationUnifierConfiguration", "()Lorg/languagetool/rules/patterns/UnifierConfiguration;", "disambiguator", "Lorg/languagetool/tagging/disambiguation/Disambiguator;", "getDisambiguator", "()Lorg/languagetool/tagging/disambiguation/Disambiguator;", "ignoredCharactersRegex", "Ljava/util/regex/Pattern;", "getIgnoredCharactersRegex", "()Ljava/util/regex/Pattern;", "locale", "Ljava/util/Locale;", "getLocale", "()Ljava/util/Locale;", "localeWithCountryAndVariant", "getLocaleWithCountryAndVariant", "name", "getName", "()Ljava/lang/String;", "postDisambiguationChunker", "getPostDisambiguationChunker", "ruleFileNames", "getRuleFileNames", "sentenceTokenizer", "Lorg/languagetool/tokenizers/SentenceTokenizer;", "getSentenceTokenizer", "()Lorg/languagetool/tokenizers/SentenceTokenizer;", "shortCode", "getShortCode", "shortCodeWithCountryAndVariant", "getShortCodeWithCountryAndVariant", "synthesizer", "Lorg/languagetool/synthesis/Synthesizer;", "getSynthesizer", "()Lorg/languagetool/synthesis/Synthesizer;", "tagger", "Lorg/languagetool/tagging/Tagger;", "getTagger", "()Lorg/languagetool/tagging/Tagger;", "unifier", "getUnifier", "unifierConfiguration", "getUnifierConfiguration", "variant", "getVariant", "wordTokenizer", "Lorg/languagetool/tokenizers/Tokenizer;", "getWordTokenizer", "()Lorg/languagetool/tokenizers/Tokenizer;", "equals", "", "other", "equalsConsiderVariantsIfSpecified", "otherLanguage", "getPatternRules", "Lorg/languagetool/rules/patterns/AbstractPatternRule;", "getPriorityForId", "", "id", "getRelevantRules", "Lorg/languagetool/rules/Rule;", "messages", "Ljava/util/ResourceBundle;", "userConfig", "Lorg/languagetool/config/UserConfig;", "motherTongue", "altLanguages", "getSpellchecker", "Lorg/languagetool/rules/spelling/SpellingCheckRule;", "hasCountry", "hashCode", "toString", "Companion", "languagetool-core"})
public abstract class Language {
    @NotNull
    private final UnifierConfiguration unifierConfiguration = new UnifierConfiguration();
    @NotNull
    private final UnifierConfiguration disambiguationUnifierConfiguration = new UnifierConfiguration();
    @NotNull
    private final Pattern ignoredCharactersRegex;
    private static final DemoDisambiguator DEMO_DISAMBIGUATOR;
    private static final DemoTagger DEMO_TAGGER;
    private static final SimpleSentenceTokenizer SENTENCE_TOKENIZER;
    private static final WordTokenizer WORD_TOKENIZER;
    public static final Companion Companion;

    @NotNull
    public abstract String getShortCode();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String[] getCountries();

    @NotNull
    public UnifierConfiguration getUnifierConfiguration() {
        return this.unifierConfiguration;
    }

    @NotNull
    public UnifierConfiguration getDisambiguationUnifierConfiguration() {
        return this.disambiguationUnifierConfiguration;
    }

    @NotNull
    public Pattern getIgnoredCharactersRegex() {
        return this.ignoredCharactersRegex;
    }

    @Nullable
    public String getVariant() {
        return null;
    }

    @NotNull
    public List<String> getDefaultEnabledRulesForVariant() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<String> getDefaultDisabledRulesForVariant() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public Locale getLocale() {
        return new Locale(this.getShortCode());
    }

    @NotNull
    public Locale getLocaleWithCountryAndVariant() {
        Locale locale;
        String[] stringArray = this.getCountries();
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        if (!(stringArray2.length == 0)) {
            if (this.getVariant() != null) {
                String string = this.getShortCode();
                String string2 = this.getCountries()[0];
                String string3 = this.getVariant();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                locale = new Locale(string, string2, string3);
            } else {
                locale = new Locale(this.getShortCode(), this.getCountries()[0]);
            }
        } else {
            locale = this.getLocale();
        }
        return locale;
    }

    @NotNull
    public List<String> getRuleFileNames() {
        String fileName;
        ArrayList<String> ruleFiles = new ArrayList<String>();
        ResourceDataBroker broker = JLanguageTool.Companion.getDataBroker();
        ruleFiles.add(broker.getRulesDir() + '/' + this.getShortCode() + "/grammar.xml");
        if (this.getShortCodeWithCountryAndVariant().length() > 2 && broker.ruleFileExists(fileName = this.getShortCode() + '/' + this.getShortCodeWithCountryAndVariant() + "/grammar.xml")) {
            ruleFiles.add(broker.getRulesDir() + '/' + fileName);
        }
        return ruleFiles;
    }

    @Nullable
    public Language getDefaultLanguageVariant() {
        return null;
    }

    @NotNull
    public Disambiguator getDisambiguator() {
        return DEMO_DISAMBIGUATOR;
    }

    @NotNull
    public Tagger getTagger() {
        return DEMO_TAGGER;
    }

    @NotNull
    public SentenceTokenizer getSentenceTokenizer() {
        return SENTENCE_TOKENIZER;
    }

    @NotNull
    public Tokenizer getWordTokenizer() {
        return WORD_TOKENIZER;
    }

    @Nullable
    public Chunker getChunker() {
        return null;
    }

    @Nullable
    public Chunker getPostDisambiguationChunker() {
        return null;
    }

    @Nullable
    public Synthesizer getSynthesizer() {
        return null;
    }

    @NotNull
    public Unifier getUnifier() {
        Unifier unifier = this.getUnifierConfiguration().createUnifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)unifier, (String)"unifierConfiguration.createUnifier()");
        return unifier;
    }

    @NotNull
    public Unifier getDisambiguationUnifier() {
        Unifier unifier = this.getDisambiguationUnifierConfiguration().createUnifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)unifier, (String)"disambiguationUnifierConfiguration.createUnifier()");
        return unifier;
    }

    @NotNull
    public final String getShortCodeWithCountryAndVariant() {
        String name = this.getShortCode();
        if (this.getCountries().length == 1 && !StringsKt.contains$default((CharSequence)name, (CharSequence)"-x-", (boolean)false, (int)2, null)) {
            name = name + "-" + this.getCountries()[0];
            if (this.getVariant() != null) {
                StringBuilder stringBuilder = new StringBuilder().append(name).append("-");
                String string = this.getVariant();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                name = stringBuilder.append(string).toString();
            }
        }
        return name;
    }

    @NotNull
    public abstract List<Rule> getRelevantRules(@NotNull ResourceBundle var1, @NotNull UserConfig var2, @Nullable Language var3, @NotNull List<? extends Language> var4) throws IOException;

    @Nullable
    public SpellingCheckRule getSpellchecker(@NotNull ResourceBundle messages, @NotNull UserConfig userConfig) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)userConfig, (String)"userConfig");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized List<AbstractPatternRule> getPatternRules() throws IOException {
        ArrayList rules = new ArrayList();
        PatternRuleLoader ruleLoader = new PatternRuleLoader();
        List patternRules = CollectionsKt.emptyList();
        for (String fileName : this.getRuleFileNames()) {
            try {
                InputStream inputStream = JLanguageTool.Companion.getDataBroker().getAsStream(fileName);
                if (inputStream == null) {
                    inputStream = new FileInputStream(fileName);
                }
                Closeable closeable = inputStream;
                boolean bl = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl2 = false;
                    rules.addAll(ruleLoader.getRules(it, fileName));
                    Intrinsics.checkExpressionValueIsNotNull(Collections.unmodifiableList(rules), (String)"Collections.unmodifiableList(rules)");
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {}
        }
        return patternRules;
    }

    public final boolean equalsConsiderVariantsIfSpecified(@NotNull Language otherLanguage) {
        Intrinsics.checkParameterIsNotNull((Object)otherLanguage, (String)"otherLanguage");
        return Intrinsics.areEqual((Object)this.getShortCode(), (Object)otherLanguage.getShortCode()) ? !this.hasCountry() || !otherLanguage.hasCountry() || Intrinsics.areEqual((Object)this.getShortCodeWithCountryAndVariant(), (Object)otherLanguage.getShortCodeWithCountryAndVariant()) : false;
    }

    private final boolean hasCountry() {
        return this.getCountries().length == 1;
    }

    public int getPriorityForId(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return 0;
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getShortCodeWithCountryAndVariant(), (Object)((Language)other).getShortCodeWithCountryAndVariant());
    }

    public int hashCode() {
        return this.getShortCodeWithCountryAndVariant().hashCode();
    }

    public Language() {
        Pattern pattern = Pattern.compile("[\u00ad]");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"[\\u00AD]\")");
        this.ignoredCharactersRegex = pattern;
    }

    static {
        Companion = new Companion(null);
        DEMO_DISAMBIGUATOR = new DemoDisambiguator();
        DEMO_TAGGER = new DemoTagger();
        SENTENCE_TOKENIZER = new SimpleSentenceTokenizer();
        WORD_TOKENIZER = new WordTokenizer();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/languagetool/language/Language$Companion;", "", "()V", "DEMO_DISAMBIGUATOR", "Lorg/languagetool/tagging/disambiguation/xx/DemoDisambiguator;", "DEMO_TAGGER", "Lorg/languagetool/tagging/xx/DemoTagger;", "SENTENCE_TOKENIZER", "Lorg/languagetool/tokenizers/SimpleSentenceTokenizer;", "WORD_TOKENIZER", "Lorg/languagetool/tokenizers/WordTokenizer;", "languagetool-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

