/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.language.Language;
import org.languagetool.language.Languages;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.patterns.FalseFriendPatternRule;
import org.languagetool.rules.patterns.XMLRuleHandler;
import org.languagetool.tools.resource.ResourceBundleTools;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class FalseFriendRuleHandler
extends XMLRuleHandler {
    private static final String TRANSLATION = "translation";
    private final ResourceBundle englishMessages;
    private final ResourceBundle messages;
    private final MessageFormat formatter;
    private final Language textLanguage;
    private final Language motherTongue;
    private final Map<String, List<String>> suggestionMap = new HashMap<String, List<String>>();
    private final List<String> suggestions = new ArrayList<String>();
    private final List<StringBuilder> translations = new ArrayList<StringBuilder>();
    private boolean defaultOff;
    private Language language;
    private Language translationLanguage;
    private Language currentTranslationLanguage;
    private StringBuilder translation = new StringBuilder();
    private boolean inTranslation;
    private String falseFriendHint;

    FalseFriendRuleHandler(Language textLanguage, Language motherTongue, String falseFriendHint) {
        this.englishMessages = ResourceBundleTools.INSTANCE.getMessageBundle(Languages.INSTANCE.getLanguageForShortCode("en"));
        this.messages = ResourceBundleTools.INSTANCE.getMessageBundle(motherTongue);
        this.formatter = new MessageFormat("");
        this.formatter.setLocale(motherTongue.getLocale());
        this.textLanguage = textLanguage;
        this.motherTongue = motherTongue;
        this.falseFriendHint = falseFriendHint;
    }

    public Map<String, List<String>> getSuggestionMap() {
        return this.suggestionMap;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("rule")) {
            this.translations.clear();
            this.id = attrs.getValue("id");
            if (!this.inRuleGroup || !this.defaultOff) {
                this.defaultOff = "off".equals(attrs.getValue("default"));
            }
            if (this.inRuleGroup && this.id == null) {
                this.id = this.ruleGroupId;
            }
            this.correctExamples = new ArrayList();
            this.incorrectExamples = new ArrayList();
        } else if (qName.equals("pattern")) {
            this.inPattern = true;
            String languageStr = attrs.getValue("lang");
            if (Languages.INSTANCE.isLanguageSupported(languageStr)) {
                this.language = Languages.INSTANCE.getLanguageForShortCode(languageStr);
            }
        } else if (qName.equals("token")) {
            this.setToken(attrs);
        } else if (qName.equals(TRANSLATION)) {
            this.inTranslation = true;
            String languageStr = attrs.getValue("lang");
            if (Languages.INSTANCE.isLanguageSupported(languageStr)) {
                Language tmpLang;
                this.currentTranslationLanguage = tmpLang = Languages.INSTANCE.getLanguageForShortCode(languageStr);
                if (tmpLang.equalsConsiderVariantsIfSpecified(this.motherTongue)) {
                    this.translationLanguage = tmpLang;
                }
            }
        } else if (qName.equals("example")) {
            this.correctExample = new StringBuilder();
            this.incorrectExample = new StringBuilder();
            if (attrs.getValue("type").equals("incorrect")) {
                this.inIncorrectExample = true;
            } else if (attrs.getValue("type").equals("correct")) {
                this.inCorrectExample = true;
            } else if (attrs.getValue("type").equals("triggers_error")) {
                throw new RuntimeException("'triggers_error' is not supported for false friend XML");
            }
        } else if (qName.equals("message")) {
            this.inMessage = true;
            this.message = new StringBuilder();
        } else if (qName.equals("rulegroup")) {
            this.ruleGroupId = attrs.getValue("id");
            this.inRuleGroup = true;
            this.defaultOff = "off".equals(attrs.getValue("default"));
        }
        this.defaultOff = true;
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        switch (qName) {
            case "rule": {
                if (this.language.equalsConsiderVariantsIfSpecified(this.textLanguage) && this.translationLanguage != null && this.translationLanguage.equalsConsiderVariantsIfSpecified(this.motherTongue) && !this.language.getShortCode().equals(this.motherTongue.getShortCode()) && !this.translations.isEmpty()) {
                    this.formatter.applyPattern(this.falseFriendHint);
                    String tokensAsString = StringUtils.join((Iterable)this.patternTokens, (String)" ").replace('|', '/');
                    Object[] messageArguments = new Object[]{tokensAsString, this.englishMessages.getString(this.textLanguage.getShortCode()), this.formatTranslations(this.translations), this.englishMessages.getString(this.motherTongue.getShortCode())};
                    String description = this.formatter.format(messageArguments);
                    FalseFriendPatternRule rule = new FalseFriendPatternRule(this.id, this.language, this.patternTokens, this.messages.getString("false_friend_desc") + " " + tokensAsString, description, this.messages.getString("false_friend"));
                    rule.setCorrectExamples(this.correctExamples);
                    rule.setIncorrectExamples(this.incorrectExamples);
                    rule.setCategory(Categories.FALSE_FRIENDS.getCategory(this.messages, this.language));
                    if (this.defaultOff) {
                        rule.setDefaultOff();
                    }
                    this.rules.add(rule);
                }
                if (this.patternTokens == null) break;
                this.patternTokens.clear();
                break;
            }
            case "token": {
                this.finalizeTokens();
                break;
            }
            case "pattern": {
                this.inPattern = false;
                break;
            }
            case "translation": {
                if (this.currentTranslationLanguage != null && this.currentTranslationLanguage.equalsConsiderVariantsIfSpecified(this.motherTongue)) {
                    this.translations.add(this.translation);
                }
                if (this.currentTranslationLanguage != null && this.currentTranslationLanguage.equalsConsiderVariantsIfSpecified(this.textLanguage) && this.language.equalsConsiderVariantsIfSpecified(this.motherTongue)) {
                    this.suggestions.add(this.translation.toString());
                }
                this.translation = new StringBuilder();
                this.inTranslation = false;
                this.currentTranslationLanguage = null;
                break;
            }
            case "example": {
                if (this.inCorrectExample) {
                    this.correctExamples.add(new CorrectExample(this.correctExample.toString()));
                } else if (this.inIncorrectExample) {
                    this.incorrectExamples.add(new IncorrectExample(this.incorrectExample.toString()));
                }
                this.inCorrectExample = false;
                this.inIncorrectExample = false;
                this.correctExample = new StringBuilder();
                this.incorrectExample = new StringBuilder();
                break;
            }
            case "message": {
                this.inMessage = false;
                break;
            }
            case "rulegroup": {
                if (!this.suggestions.isEmpty()) {
                    ArrayList<String> l = new ArrayList<String>(this.suggestions);
                    this.suggestionMap.put(this.id, l);
                    this.suggestions.clear();
                }
                this.inRuleGroup = false;
            }
        }
    }

    private String formatTranslations(List<StringBuilder> translations) {
        return translations.stream().map(o -> "\"" + o + "\"").collect(Collectors.joining(", "));
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.inToken && this.inPattern) {
            this.elements.append(s);
        } else if (this.inCorrectExample) {
            this.correctExample.append(s);
        } else if (this.inIncorrectExample) {
            this.incorrectExample.append(s);
        } else if (this.inTranslation) {
            this.translation.append(s);
        }
    }
}

