/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.JavaVersion;
import com.sun.tools.javac.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;

public final class IdeaTestUtil {
    private static final String MOCK_JDK_DIR_NAME_PREFIX = "mockJDK-";
    public static final String WEB_JARS_MODULE_LIBRARY_NAME = "webjars";

    public static void printDetectedPerformanceTimings() {
        System.out.println(Timings.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Runnable r) {
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(0);
        }
        if (level == null) {
            IdeaTestUtil.$$$reportNull$$$0(1);
        }
        if (r == null) {
            IdeaTestUtil.$$$reportNull$$$0(2);
        }
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance((Project)module.getProject());
        LanguageLevel projectLevel = projectExt.getLanguageLevel();
        LanguageLevel moduleLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        try {
            projectExt.setLanguageLevel(level);
            IdeaTestUtil.setModuleLanguageLevel(module, level);
            r.run();
        }
        finally {
            IdeaTestUtil.setModuleLanguageLevel(module, moduleLevel);
            projectExt.setLanguageLevel(projectLevel);
        }
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @Nullable LanguageLevel level) {
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(3);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level));
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Disposable parentDisposable) {
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(4);
        }
        if (level == null) {
            IdeaTestUtil.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            IdeaTestUtil.$$$reportNull$$$0(6);
        }
        LanguageLevel prev = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        IdeaTestUtil.setModuleLanguageLevel(module, level);
        Disposer.register((Disposable)parentDisposable, () -> IdeaTestUtil.setModuleLanguageLevel(module, prev));
    }

    @NotNull
    public static Sdk getMockJdk(@NotNull JavaVersion version) {
        if (version == null) {
            IdeaTestUtil.$$$reportNull$$$0(7);
        }
        int mockJdk = version.feature >= 11 ? 11 : (version.feature >= 9 ? 9 : (version.feature >= 7 ? version.feature : (version.feature >= 5 ? 7 : 4)));
        String path = IdeaTestUtil.getPathForJdkNamed(MOCK_JDK_DIR_NAME_PREFIX + (mockJdk < 11 ? "1." : "") + mockJdk).getPath();
        return IdeaTestUtil.createMockJdk("java " + version, path);
    }

    @NotNull
    public static Sdk createMockJdk(@NotNull String name, @NotNull String path) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(8);
        }
        if (path == null) {
            IdeaTestUtil.$$$reportNull$$$0(9);
        }
        return IdeaTestUtil.createMockJdk(name, path, false);
    }

    @NotNull
    public static Sdk createMockJdk(@NotNull String name, @NotNull String path, boolean isJre) {
        JavaSdk javaSdk;
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(10);
        }
        if (path == null) {
            IdeaTestUtil.$$$reportNull$$$0(11);
        }
        if ((javaSdk = JavaSdk.getInstance()) == null) {
            throw new AssertionError((Object)"The test uses classes from Java plugin but Java plugin wasn't loaded; make sure that Java plugin classes are included into classpath and that the plugin isn't disabled by using 'idea.load.plugins', 'idea.load.plugins.id', 'idea.load.plugins.category' system properties");
        }
        String homePath = PathUtil.toSystemIndependentName((String)path);
        File jdkHomeFile = new File(homePath);
        final MultiMap roots = MultiMap.create();
        SdkModificator sdkModificator = new SdkModificator(){

            @NotNull
            public String getName() {
                throw new UnsupportedOperationException();
            }

            public void setName(@NotNull String name1) {
                if (name1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException();
            }

            public String getHomePath() {
                throw new UnsupportedOperationException();
            }

            public void setHomePath(String path1) {
                throw new UnsupportedOperationException();
            }

            public String getVersionString() {
                throw new UnsupportedOperationException();
            }

            public void setVersionString(String versionString) {
                throw new UnsupportedOperationException();
            }

            public SdkAdditionalData getSdkAdditionalData() {
                throw new UnsupportedOperationException();
            }

            public void setSdkAdditionalData(SdkAdditionalData data) {
                throw new UnsupportedOperationException();
            }

            public VirtualFile @NotNull [] getRoots(@NotNull OrderRootType rootType) {
                if (rootType == null) {
                    1.$$$reportNull$$$0(1);
                }
                VirtualFile[] virtualFileArray = roots.get((Object)rootType).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return virtualFileArray;
            }

            public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                if (root == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (rootType == null) {
                    1.$$$reportNull$$$0(4);
                }
                throw new UnsupportedOperationException();
            }

            public void removeRoots(@NotNull OrderRootType rootType) {
                if (rootType == null) {
                    1.$$$reportNull$$$0(5);
                }
                throw new UnsupportedOperationException();
            }

            public void removeAllRoots() {
                throw new UnsupportedOperationException();
            }

            public void commitChanges() {
                throw new UnsupportedOperationException();
            }

            public boolean isWritable() {
                throw new UnsupportedOperationException();
            }

            public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                if (root == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (rootType == null) {
                    1.$$$reportNull$$$0(7);
                }
                roots.putValue((Object)rootType, (Object)root);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name1";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/testFramework/IdeaTestUtil$1";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/testFramework/IdeaTestUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRoots";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "setName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getRoots";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "removeRoot";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "removeRoots";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "addRoot";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        JavaSdkImpl.addClasses((File)jdkHomeFile, (SdkModificator)sdkModificator, (boolean)isJre);
        JavaSdkImpl.addSources((File)jdkHomeFile, (SdkModificator)sdkModificator);
        JavaSdkImpl.attachJdkAnnotations((SdkModificator)sdkModificator);
        return new MockSdk(name, homePath, name, roots, () -> JavaSdk.getInstance());
    }

    @NotNull
    public static Sdk getMockJdk14() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)4));
    }

    @NotNull
    public static Sdk getMockJdk17() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)7));
    }

    @NotNull
    public static Sdk getMockJdk17(@NotNull String name) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(12);
        }
        return IdeaTestUtil.createMockJdk(name, IdeaTestUtil.getMockJdk17Path().getPath());
    }

    @NotNull
    public static Sdk getMockJdk18() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)8));
    }

    @NotNull
    public static Sdk getMockJdk9() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)9));
    }

    @NotNull
    public static File getMockJdk14Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.4");
    }

    @NotNull
    public static File getMockJdk17Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.7");
    }

    @NotNull
    public static File getMockJdk18Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.8");
    }

    @NotNull
    public static File getMockJdk9Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.9");
    }

    public static String getMockJdkVersion(@NotNull String path) {
        String name;
        if (path == null) {
            IdeaTestUtil.$$$reportNull$$$0(13);
        }
        if ((name = PathUtil.getFileName((String)path)).startsWith(MOCK_JDK_DIR_NAME_PREFIX)) {
            return "java " + StringUtil.trimStart((String)name, (String)MOCK_JDK_DIR_NAME_PREFIX);
        }
        return null;
    }

    @NotNull
    private static File getPathForJdkNamed(@NotNull String name) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(14);
        }
        return new File(PathManager.getCommunityHomePath(), "java/" + name);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static Sdk getWebMockJdk17() {
        Sdk jdk = IdeaTestUtil.getMockJdk17();
        jdk = IdeaTestUtil.addWebJarsTo(jdk);
        return jdk;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static Sdk addWebJarsTo(@NotNull Sdk jdk) {
        if (jdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(15);
        }
        try {
            jdk = (Sdk)jdk.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/jsp-api.jar"), OrderRootType.CLASSES);
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/servlet-api.jar"), OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        Sdk sdk = jdk;
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(16);
        }
        return sdk;
    }

    public static void addWebJarsToModule(@NotNull Module module) {
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(17);
        }
        ModuleRootModificationUtil.updateModel((Module)module, IdeaTestUtil::addWebJarsToModule);
    }

    public static void removeWebJarsFromModule(@NotNull Module module) {
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(18);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            boolean removed = false;
            for (OrderEntry entry : model.getOrderEntries()) {
                LibraryOrderEntry libraryOrderEntry;
                if (!(entry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)entry).isModuleLevel() || !WEB_JARS_MODULE_LIBRARY_NAME.equals(libraryOrderEntry.getLibraryName())) continue;
                model.removeOrderEntry(entry);
                removed = true;
            }
            Assert.assertTrue((String)("Module library webjars was not found in module " + module), (boolean)removed);
        });
    }

    public static void addWebJarsToModule(@NotNull ModifiableRootModel model) {
        if (model == null) {
            IdeaTestUtil.$$$reportNull$$$0(19);
        }
        LibraryEx library = (LibraryEx)model.getModuleLibraryTable().createLibrary(WEB_JARS_MODULE_LIBRARY_NAME);
        LibraryEx.ModifiableModelEx libraryModel = library.getModifiableModel();
        libraryModel.addRoot(IdeaTestUtil.findJar("lib/jsp-api.jar"), OrderRootType.CLASSES);
        libraryModel.addRoot(IdeaTestUtil.findJar("lib/servlet-api.jar"), OrderRootType.CLASSES);
        WriteAction.runAndWait(() -> ((LibraryEx.ModifiableModelEx)libraryModel).commit());
    }

    @NotNull
    private static VirtualFile findJar(@NotNull String name) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(20);
        }
        String path = PathManager.getHomePath() + '/' + name;
        VirtualFile file = VfsTestUtil.findFileByCaseSensitivePath((String)path);
        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        assert (jar != null) : "no .jar for: " + path;
        VirtualFile virtualFile = jar;
        if (virtualFile == null) {
            IdeaTestUtil.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    public static void setTestVersion(@NotNull JavaSdkVersion testVersion, @NotNull Module module, @NotNull Disposable parentDisposable) {
        if (testVersion == null) {
            IdeaTestUtil.$$$reportNull$$$0(22);
        }
        if (module == null) {
            IdeaTestUtil.$$$reportNull$$$0(23);
        }
        if (parentDisposable == null) {
            IdeaTestUtil.$$$reportNull$$$0(24);
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        Assert.assertNotNull((Object)sdk);
        String oldVersionString = sdk.getVersionString();
        ((SdkModificator)sdk).setVersionString(testVersion.getDescription());
        Assert.assertSame((Object)testVersion, (Object)JavaSdk.getInstance().getVersion(sdk));
        Disposer.register((Disposable)parentDisposable, () -> ((SdkModificator)sdk).setVersionString(oldVersionString));
    }

    @NotNull
    public static String requireRealJdkHome() {
        String javaHome = SystemProperties.getJavaHome();
        List paths = ContainerUtil.packNullables((Object[])new String[]{javaHome, new File(javaHome).getParent(), System.getenv("JDK_16_x64"), System.getenv("JDK_16")});
        for (String path : paths) {
            if (!JdkUtil.checkForJdk((String)path)) continue;
            String string = path;
            if (string == null) {
                IdeaTestUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        Assume.assumeTrue((String)("Cannot find JDK, checked paths: " + paths), (boolean)false);
        if (null == null) {
            IdeaTestUtil.$$$reportNull$$$0(26);
        }
        return null;
    }

    @NotNull
    public static File findSourceFile(@NotNull String basePath) {
        File testFile;
        if (basePath == null) {
            IdeaTestUtil.$$$reportNull$$$0(27);
        }
        if (!(testFile = new File(basePath + ".java")).exists()) {
            testFile = new File(basePath + ".groovy");
        }
        if (!testFile.exists()) {
            throw new IllegalArgumentException("No test source for " + basePath);
        }
        File file = testFile;
        if (file == null) {
            IdeaTestUtil.$$$reportNull$$$0(28);
        }
        return file;
    }

    public static void compileFile(@NotNull File source, @NotNull File out, String ... options) {
        if (source == null) {
            IdeaTestUtil.$$$reportNull$$$0(29);
        }
        if (out == null) {
            IdeaTestUtil.$$$reportNull$$$0(30);
        }
        if (options == null) {
            IdeaTestUtil.$$$reportNull$$$0(31);
        }
        Assert.assertTrue((String)("source does not exist: " + source.getPath()), (boolean)source.isFile());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(out.getAbsolutePath());
        ContainerUtil.addAll(args, (Object[])options);
        args.add(source.getAbsolutePath());
        if (source.getName().endsWith(".groovy")) {
            try {
                FileSystemCompiler.commandLineCompile((String[])ArrayUtilRt.toStringArray(args));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            int result = Main.compile(ArrayUtilRt.toStringArray(args));
            if (result != 0) {
                throw new IllegalStateException("javac failed with exit code " + result);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/IdeaTestUtil";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testVersion";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/IdeaTestUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addWebJarsTo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findJar";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRealJdkHome";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setModuleLanguageLevel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdk";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createMockJdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdk17";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdkVersion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPathForJdkNamed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addWebJarsTo";
                break;
            }
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: {
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addWebJarsToModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeWebJarsFromModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findJar";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setTestVersion";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFile";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "compileFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

