/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.konan.debugger;

import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/konan/debugger/KonanLLDBDriverConfiguration;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLDBDriverConfiguration;", "lldbHome", "Ljava/io/File;", "(Ljava/io/File;)V", "framework", "", "frontend", "copyToKonan", "binaryInPlugin", "getLLDBFrameworkFile", "architecture", "Lcom/jetbrains/cidr/ArchitectureType;", "getLLDBFrontendFile", "ultimate-native"})
public final class KonanLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    private final String framework;
    private final String frontend;
    private final File lldbHome;

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architecture) {
        Intrinsics.checkParameterIsNotNull((Object)architecture, (String)"architecture");
        return FilesKt.resolve((File)this.lldbHome, (String)this.framework);
    }

    @NotNull
    protected File getLLDBFrontendFile(@NotNull ArchitectureType architecture) {
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)architecture, (String)"architecture");
        File file3 = CidrPathManager.getBinFile(KonanLLDBDriverConfiguration.class, (String)"", (String)this.frontend, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"CidrPathManager.getBinFi\u2026           null\n        )");
        File binaryInPlugin = file3;
        KonanTarget konanTarget = HostManager.Companion.getHost();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
            file2 = this.copyToKonan(binaryInPlugin);
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE)) {
            file2 = binaryInPlugin;
        } else {
            throw (Throwable)new TargetSupportException("Unsupported host target: " + HostManager.Companion.host_os() + ' ' + HostManager.Companion.host_arch(), null, 2, null);
        }
        return file2;
    }

    private final File copyToKonan(File binaryInPlugin) {
        File binaryInKonan = FilesKt.resolve((File)this.lldbHome, (String)"bin/LLDBFrontend");
        FilesKt.copyTo$default((File)binaryInPlugin, (File)binaryInKonan, (boolean)true, (int)0, (int)4, null);
        File file2 = binaryInKonan;
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file2;
        boolean bl3 = false;
        $this$apply.setExecutable(true);
        return file2;
    }

    public KonanLLDBDriverConfiguration(@NotNull File lldbHome) {
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)lldbHome, (String)"lldbHome");
        this.lldbHome = lldbHome;
        KonanTarget konanTarget = HostManager.Companion.getHost();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE)) {
            string2 = "LLDB.framework";
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
            string2 = "lib/liblldb.so";
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE)) {
            string2 = "bin/liblldb.dll";
        } else {
            throw (Throwable)new TargetSupportException("Unsupported host target: " + HostManager.Companion.host_os() + ' ' + HostManager.Companion.host_arch(), null, 2, null);
        }
        this.framework = string2;
        konanTarget = HostManager.Companion.getHost();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE)) {
            string = "macos/LLDBFrontend";
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
            string = "linux/LLDBFrontend";
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE)) {
            string = "windows/LLDBFrontend.exe";
        } else {
            throw (Throwable)new TargetSupportException("Unsupported host target: " + HostManager.Companion.host_os() + ' ' + HostManager.Companion.host_arch(), null, 2, null);
        }
        this.frontend = string;
    }
}

