/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.cache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.SLRUMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.CachedConfigurationInputs;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationCache;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationCacheScope;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationState;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0096\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationMemoryCache;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationCache;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "memoryCache", "Lcom/intellij/util/containers/SLRUMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationState;", "getProject", "()Lcom/intellij/openapi/project/Project;", "allApplied", "", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "clear", "", "get", "file", "markFileOutOfDate", "markOutOfDate", "scope", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationCacheScope;", "setApplied", "configurationSnapshot", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshot;", "setLoaded", "Companion", "idea-core"})
public class ScriptConfigurationMemoryCache
implements ScriptConfigurationCache {
    private final SLRUMap<VirtualFile, ScriptConfigurationState> memoryCache;
    @NotNull
    private final Project project;
    public static final int MAX_SCRIPTS_CACHED = 50;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public synchronized ScriptConfigurationState get(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return (ScriptConfigurationState)this.memoryCache.get((Object)file2);
    }

    @Override
    public synchronized void setApplied(@NotNull VirtualFile file2, @NotNull ScriptConfigurationSnapshot configurationSnapshot) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)configurationSnapshot, (String)"configurationSnapshot");
        ScriptConfigurationState scriptConfigurationState = (ScriptConfigurationState)this.memoryCache.get((Object)file2);
        if (scriptConfigurationState == null) {
            scriptConfigurationState = new ScriptConfigurationState(null, null, 3, null);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptConfigurationState, (String)"memoryCache[file] ?: ScriptConfigurationState()");
        ScriptConfigurationState old = scriptConfigurationState;
        this.memoryCache.put((Object)file2, (Object)ScriptConfigurationState.copy$default(old, configurationSnapshot, null, 2, null));
    }

    @Override
    public synchronized void setLoaded(@NotNull VirtualFile file2, @NotNull ScriptConfigurationSnapshot configurationSnapshot) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)configurationSnapshot, (String)"configurationSnapshot");
        ScriptConfigurationState scriptConfigurationState = (ScriptConfigurationState)this.memoryCache.get((Object)file2);
        if (scriptConfigurationState == null) {
            scriptConfigurationState = new ScriptConfigurationState(null, null, 3, null);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptConfigurationState, (String)"memoryCache[file] ?: ScriptConfigurationState()");
        ScriptConfigurationState old = scriptConfigurationState;
        this.memoryCache.put((Object)file2, (Object)ScriptConfigurationState.copy$default(old, null, configurationSnapshot, 1, null));
    }

    @Override
    public synchronized void markOutOfDate(@NotNull ScriptConfigurationCacheScope scope2) {
        block3: {
            ScriptConfigurationCacheScope scriptConfigurationCacheScope;
            block4: {
                block2: {
                    VirtualFile file2;
                    Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
                    scriptConfigurationCacheScope = scope2;
                    if (!(scriptConfigurationCacheScope instanceof ScriptConfigurationCacheScope.File)) break block2;
                    PsiFile psiFile2 = ((ScriptConfigurationCacheScope.File)scope2).getFile().getOriginalFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"scope.file.originalFile");
                    VirtualFile virtualFile2 = file2 = psiFile2.getVirtualFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                    this.markFileOutOfDate(virtualFile2);
                    break block3;
                }
                if (!(scriptConfigurationCacheScope instanceof ScriptConfigurationCacheScope.Except)) break block4;
                PsiFile psiFile3 = ((ScriptConfigurationCacheScope.Except)scope2).getFile().getOriginalFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"scope.file.originalFile");
                VirtualFile file3 = psiFile3.getVirtualFile();
                Set set2 = this.memoryCache.entrySet();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"memoryCache.entrySet()");
                Iterable $this$forEach$iv = set2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)((VirtualFile)it.getKey()), (Object)file3) ^ true)) continue;
                    Object k = it.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                    this.markFileOutOfDate((VirtualFile)k);
                }
                break block3;
            }
            if (!(scriptConfigurationCacheScope instanceof ScriptConfigurationCacheScope.All)) break block3;
            Set set3 = this.memoryCache.entrySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"memoryCache.entrySet()");
            Iterable $this$forEach$iv = set3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                this.markFileOutOfDate((VirtualFile)k);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized Map<VirtualFile, ScriptCompilationConfigurationWrapper> allApplied() {
        boolean bl = false;
        HashMap result2 = new HashMap();
        Iterator iterator2 = this.memoryCache.entrySet().iterator();
        while (iterator2.hasNext()) {
            void file2;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            boolean bl2 = false;
            VirtualFile virtualFile2 = (VirtualFile)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            ScriptConfigurationState configuration2 = (ScriptConfigurationState)entry2.getValue();
            ScriptConfigurationSnapshot scriptConfigurationSnapshot = configuration2.getApplied();
            if ((scriptConfigurationSnapshot != null ? scriptConfigurationSnapshot.getConfiguration() : null) == null) continue;
            Map map2 = result2;
            void v2 = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"file");
            map2.put(v2, configuration2.getApplied().getConfiguration());
        }
        return result2;
    }

    @Override
    public synchronized void clear() {
        this.memoryCache.clear();
    }

    private final synchronized void markFileOutOfDate(VirtualFile file2) {
        ScriptConfigurationState scriptConfigurationState = (ScriptConfigurationState)this.memoryCache.get((Object)file2);
        if (scriptConfigurationState == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptConfigurationState, (String)"memoryCache[file] ?: return");
        ScriptConfigurationState old = scriptConfigurationState;
        ScriptConfigurationSnapshot scriptConfigurationSnapshot = old.getApplied();
        ScriptConfigurationSnapshot scriptConfigurationSnapshot2 = old.getLoaded();
        this.memoryCache.put((Object)file2, (Object)old.copy(scriptConfigurationSnapshot != null ? ScriptConfigurationSnapshot.copy$default(scriptConfigurationSnapshot, CachedConfigurationInputs.OutOfDate.INSTANCE, null, null, 6, null) : null, scriptConfigurationSnapshot2 != null ? ScriptConfigurationSnapshot.copy$default(scriptConfigurationSnapshot2, CachedConfigurationInputs.OutOfDate.INSTANCE, null, null, 6, null) : null));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptConfigurationMemoryCache(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.memoryCache = new SLRUMap(50, 50);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationMemoryCache$Companion;", "", "()V", "MAX_SCRIPTS_CACHED", "", "idea-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

